/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.ColumnInfo;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class DatabaseManager {
    private static Logger log = Logger.getLogger(DatabaseManager.class);
    private static boolean initialized = false;
    private static String poolName = "dspacepool";
    private static final Pattern DB_SAFE_NAME = Pattern.compile("^[a-zA-Z_1-9]+$");
    private static Map info = new HashMap();

    protected DatabaseManager() {
    }

    public static TableRowIterator queryTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)("Running query \"" + query + "\"  with parameters: " + sb.toString()));
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            DatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery(), DatabaseManager.canonicalize(table));
            retTRI.setStatement(statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException s) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    public static TableRowIterator query(Context context, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)("Running query \"" + query + "\"  with parameters: " + sb.toString()));
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            DatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery());
            retTRI.setStatement(statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException s) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    public static TableRowIterator queryPreparedTable(String table, PreparedStatement statement) throws SQLException {
        TableRowIterator retTRI = new TableRowIterator(statement.executeQuery(), DatabaseManager.canonicalize(table));
        retTRI.setStatement(statement);
        return retTRI;
    }

    public static TableRowIterator queryPrepared(PreparedStatement statement) throws SQLException {
        TableRowIterator retTRI = new TableRowIterator(statement.executeQuery());
        retTRI.setStatement(statement);
        return retTRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableRow querySingle(Context context, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = null;
        try {
            iterator = DatabaseManager.query(context, query, parameters);
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableRow querySingleTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = DatabaseManager.queryTable(context, DatabaseManager.canonicalize(table), query, parameters);
        try {
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateQuery(Context context, String query, Object ... parameters) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)("Running query \"" + query + "\"  with parameters: " + sb.toString()));
        }
        try {
            statement = context.getDBConnection().prepareStatement(query);
            DatabaseManager.loadParameters(statement, parameters);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public static TableRow create(Context context, String table) throws SQLException {
        TableRow row = new TableRow(DatabaseManager.canonicalize(table), DatabaseManager.getColumnNames(table));
        DatabaseManager.insert(context, row);
        return row;
    }

    public static TableRow find(Context context, String table, int id) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        return DatabaseManager.findByUnique(context, ctable, DatabaseManager.getPrimaryKeyColumn(ctable), new Integer(id));
    }

    public static TableRow findByUnique(Context context, String table, String column, Object value) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute select query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute select query because column name (" + column + ") contains non alphanumeric characters.");
        }
        String sql = "select * from " + ctable + " where " + column + " = ? ";
        return DatabaseManager.querySingleTable(context, ctable, sql, value);
    }

    public static int delete(Context context, String table, int id) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        return DatabaseManager.deleteByValue(context, ctable, DatabaseManager.getPrimaryKeyColumn(ctable), new Integer(id));
    }

    public static int deleteByValue(Context context, String table, String column, Object value) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute delete query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute delete query because column name (" + column + ") contains non alphanumeric characters.");
        }
        String sql = "delete from " + ctable + " where " + column + " = ? ";
        return DatabaseManager.updateQuery(context, sql, value);
    }

    public static Connection getConnection() throws SQLException {
        DatabaseManager.initialize();
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + poolName);
    }

    public static void freeConnection(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static TableRow row(String table) throws SQLException {
        return new TableRow(DatabaseManager.canonicalize(table), DatabaseManager.getColumnNames(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(Context context, TableRow row) throws SQLException {
        int i;
        int newID = -1;
        String table = DatabaseManager.canonicalize(row.getTable());
        Statement statement = null;
        ResultSet rs = null;
        try {
            String myQuery = "SELECT getnextid('" + table + "') AS result";
            if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
                myQuery = "SELECT " + table + "_seq" + ".nextval FROM dual";
            }
            statement = context.getDBConnection().createStatement();
            rs = statement.executeQuery(myQuery);
            rs.next();
            newID = rs.getInt(1);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
        if (newID < 0) {
            throw new SQLException("Unable to retrieve sequence ID");
        }
        row.setColumn(DatabaseManager.getPrimaryKeyColumn(table), newID);
        StringBuffer sql = new StringBuffer().append("INSERT INTO ").append(table).append(" ( ");
        ColumnInfo[] info = DatabaseManager.getColumnInfo(table);
        for (i = 0; i < info.length; ++i) {
            sql.append(i == 0 ? "" : ",").append(info[i].getName());
        }
        sql.append(") VALUES ( ");
        for (i = 0; i < info.length; ++i) {
            sql.append(i == 0 ? "" : ",").append("?");
        }
        sql.append(")");
        DatabaseManager.execute(context.getDBConnection(), sql.toString(), Arrays.asList(info), row);
    }

    public static int update(Context context, TableRow row) throws SQLException {
        String table = DatabaseManager.canonicalize(row.getTable());
        StringBuffer sql = new StringBuffer().append("update ").append(table).append(" set ");
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        ColumnInfo pk = DatabaseManager.getPrimaryKeyColumnInfo(table);
        ColumnInfo[] info = DatabaseManager.getNonPrimaryKeyColumns(table);
        String seperator = "";
        for (int i = 0; i < info.length; ++i) {
            if (!row.hasColumnChanged(info[i].getName())) continue;
            sql.append(seperator).append(info[i].getName()).append(" = ?");
            columns.add(info[i]);
            seperator = ", ";
        }
        if (columns.size() > 0) {
            sql.append(" where ").append(pk.getName()).append(" = ?");
            columns.add(pk);
            return DatabaseManager.execute(context.getDBConnection(), sql.toString(), columns, row);
        }
        return 1;
    }

    public static int delete(Context context, TableRow row) throws SQLException {
        String pk = DatabaseManager.getPrimaryKeyColumn(row);
        if (row.isColumnNull(pk)) {
            throw new IllegalArgumentException("Primary key value is null");
        }
        return DatabaseManager.delete(context, row.getTable(), row.getIntColumn(pk));
    }

    static ColumnInfo[] getColumnInfo(String table) throws SQLException {
        Map cinfo = DatabaseManager.getColumnInfoInternal(table);
        if (cinfo == null) {
            return null;
        }
        Collection info = cinfo.values();
        return info.toArray(new ColumnInfo[info.size()]);
    }

    static ColumnInfo getColumnInfo(String table, String column) throws SQLException {
        Map info = DatabaseManager.getColumnInfoInternal(table);
        return info == null ? null : (ColumnInfo)info.get(column);
    }

    static ColumnInfo[] getNonPrimaryKeyColumns(String table) throws SQLException {
        String pk = DatabaseManager.getPrimaryKeyColumn(table);
        ColumnInfo[] info = DatabaseManager.getColumnInfo(table);
        ColumnInfo[] results = new ColumnInfo[info.length - 1];
        int rcount = 0;
        for (int i = 0; i < info.length; ++i) {
            if (pk.equals(info[i].getName())) continue;
            results[rcount++] = info[i];
        }
        return results;
    }

    protected static List getColumnNames(String table) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        ColumnInfo[] info = DatabaseManager.getColumnInfo(table);
        for (int i = 0; i < info.length; ++i) {
            results.add(info[i].getName());
        }
        return results;
    }

    protected static List getColumnNames(ResultSetMetaData meta) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        int columns = meta.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            results.add(meta.getColumnLabel(i + 1));
        }
        return results;
    }

    static String canonicalize(String table) {
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            return table == null ? null : table.toUpperCase();
        }
        return table == null ? null : table.toLowerCase();
    }

    public static void loadSql(String sql) throws SQLException {
        try {
            DatabaseManager.loadSql(new StringReader(sql));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSql(Reader r) throws SQLException, IOException {
        BufferedReader reader = new BufferedReader(r);
        StringBuffer sql = new StringBuffer();
        String SQL = null;
        String line = null;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DatabaseManager.getConnection();
            connection.setAutoCommit(true);
            statement = connection.createStatement();
            boolean inquote = false;
            while ((line = reader.readLine()) != null) {
                block14: {
                    int endMarker;
                    String input;
                    int commentStart = line.indexOf("--");
                    String string = input = commentStart != -1 ? line.substring(0, commentStart) : line;
                    if (input.trim().equals("")) continue;
                    sql.append(input.replace(';', ' '));
                    sql.append(" ");
                    int index = 0;
                    int count = 0;
                    int inputlen = input.length();
                    while ((index = input.indexOf("'", count)) != -1) {
                        boolean bl = inquote = !inquote;
                        count = index + 1;
                        if (count < inputlen) continue;
                    }
                    if (inquote || (endMarker = input.indexOf(";", index)) == -1) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running database query \"" + sql + "\""));
                    }
                    SQL = sql.toString();
                    try {
                        boolean succeeded = statement.execute(SQL);
                    }
                    catch (SQLWarning sqlw) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Got SQL Warning: " + sqlw), (Throwable)sqlw);
                        }
                    }
                    catch (SQLException sqle) {
                        boolean isNoResults;
                        String msg = "Got SQL Exception: " + sqle;
                        String sqlmessage = sqle.getMessage();
                        boolean isDrop = SQL != null && sqlmessage != null && SQL.toUpperCase().startsWith("DROP") && sqlmessage.indexOf("does not exist") != -1;
                        boolean bl = isNoResults = SQL != null && sqlmessage != null && (SQL.toUpperCase().startsWith("CREATE VIEW") || SQL.toUpperCase().startsWith("CREATE FUNCTION")) && sqlmessage.indexOf("No results were returned") != -1;
                        if (isDrop || isNoResults) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg, (Throwable)sqle);
                            }
                        }
                        if (!log.isEnabledFor((Priority)Level.WARN)) break block14;
                        log.warn((Object)msg, (Throwable)sqle);
                    }
                }
                sql = new StringBuffer();
                SQL = null;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    static TableRow process(ResultSet results, String table) throws SQLException {
        String dbName = ConfigurationManager.getProperty("db.name");
        ResultSetMetaData meta = results.getMetaData();
        int columns = meta.getColumnCount() + 1;
        List columnNames = table == null ? DatabaseManager.getColumnNames(meta) : DatabaseManager.getColumnNames(table);
        TableRow row = new TableRow(DatabaseManager.canonicalize(table), columnNames);
        for (int i = 1; i < columns; ++i) {
            String name;
            block24: {
                name = meta.getColumnName(i);
                int jdbctype = meta.getColumnType(i);
                if (jdbctype == -7) {
                    row.setColumn(name, results.getBoolean(i));
                } else if (jdbctype == 4 || jdbctype == 2 || jdbctype == 3) {
                    if ("oracle".equals(dbName)) {
                        long longValue = results.getLong(i);
                        if (longValue <= Integer.MAX_VALUE) {
                            row.setColumn(name, (int)longValue);
                        } else {
                            row.setColumn(name, longValue);
                        }
                    } else {
                        row.setColumn(name, results.getInt(i));
                    }
                } else if (jdbctype == -5) {
                    row.setColumn(name, results.getLong(i));
                } else if (jdbctype == 2005 && "oracle".equals(dbName)) {
                    row.setColumn(name, results.getString(i));
                } else if (jdbctype == 12) {
                    try {
                        byte[] bytes = results.getBytes(i);
                        if (bytes != null) {
                            String mystring = new String(results.getBytes(i), "UTF-8");
                            row.setColumn(name, mystring);
                            break block24;
                        }
                        row.setColumn(name, results.getString(i));
                    }
                    catch (UnsupportedEncodingException e) {}
                } else if (jdbctype == 91) {
                    row.setColumn(name, results.getDate(i));
                } else if (jdbctype == 92) {
                    row.setColumn(name, results.getTime(i));
                } else if (jdbctype == 93) {
                    row.setColumn(name, results.getTimestamp(i));
                } else {
                    throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
                }
            }
            if (!results.wasNull()) continue;
            row.setColumnNull(name);
        }
        row.resetChanged();
        return row;
    }

    public static String getPrimaryKeyColumn(TableRow row) throws SQLException {
        return DatabaseManager.getPrimaryKeyColumn(row.getTable());
    }

    protected static String getPrimaryKeyColumn(String table) throws SQLException {
        ColumnInfo info = DatabaseManager.getPrimaryKeyColumnInfo(table);
        return info == null ? null : info.getName();
    }

    static ColumnInfo getPrimaryKeyColumnInfo(String table) throws SQLException {
        ColumnInfo[] cinfo = DatabaseManager.getColumnInfo(DatabaseManager.canonicalize(table));
        for (int i = 0; i < cinfo.length; ++i) {
            ColumnInfo info = cinfo[i];
            if (!info.isPrimaryKey()) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int execute(Connection connection, String sql, List columns, TableRow row) throws SQLException {
        String dbName = ConfigurationManager.getProperty("db.name");
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        try {
            statement = connection.prepareStatement(sql);
            int count = 0;
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                java.util.Date t;
                ++count;
                ColumnInfo info = (ColumnInfo)iterator.next();
                String column = info.getName();
                int jdbctype = info.getType();
                if (row.isColumnNull(column)) {
                    statement.setNull(count, jdbctype);
                    continue;
                }
                if (jdbctype == -7) {
                    statement.setBoolean(count, row.getBooleanColumn(column));
                    continue;
                }
                if (jdbctype == 4 || jdbctype == 2 || jdbctype == 3) {
                    if ("oracle".equals(dbName)) {
                        statement.setLong(count, row.getLongColumn(column));
                        continue;
                    }
                    statement.setInt(count, row.getIntColumn(column));
                    continue;
                }
                if (jdbctype == -5) {
                    statement.setLong(count, row.getLongColumn(column));
                    continue;
                }
                if (jdbctype == 2005 && "oracle".equals(dbName)) {
                    statement.setString(count, row.getStringColumn(column));
                    continue;
                }
                if (jdbctype == 12) {
                    statement.setString(count, row.getStringColumn(column));
                    continue;
                }
                if (jdbctype == 91) {
                    Date d = new Date(row.getDateColumn(column).getTime());
                    statement.setDate(count, d);
                    continue;
                }
                if (jdbctype == 92) {
                    t = new Time(row.getDateColumn(column).getTime());
                    statement.setTime(count, (Time)t);
                    continue;
                }
                if (jdbctype == 93) {
                    t = new Timestamp(row.getDateColumn(column).getTime());
                    statement.setTimestamp(count, (Timestamp)t);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
            }
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    private static Map getColumnInfoInternal(String table) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        Map results = (Map)info.get(ctable);
        if (results != null) {
            return results;
        }
        results = DatabaseManager.retrieveColumnInfo(ctable);
        info.put(ctable, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map retrieveColumnInfo(String table) throws SQLException {
        Connection connection = null;
        ResultSet pkcolumns = null;
        ResultSet columns = null;
        try {
            String schema = ConfigurationManager.getProperty("db.schema");
            connection = DatabaseManager.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            HashMap<String, ColumnInfo> results = new HashMap<String, ColumnInfo>();
            int max = metadata.getMaxTableNameLength();
            String tname = table.length() >= max ? table.substring(0, max - 1) : table;
            pkcolumns = metadata.getPrimaryKeys(null, schema, tname);
            HashSet<String> pks = new HashSet<String>();
            while (pkcolumns.next()) {
                pks.add(pkcolumns.getString(4));
            }
            columns = metadata.getColumns(null, schema, tname, null);
            while (columns.next()) {
                String column = columns.getString(4);
                ColumnInfo cinfo = new ColumnInfo();
                cinfo.setName(column);
                cinfo.setType(columns.getShort(5));
                if (pks.contains(column)) {
                    cinfo.setIsPrimaryKey(true);
                }
                results.put(column, cinfo);
            }
            HashMap<String, ColumnInfo> hashMap = results;
            return hashMap;
        }
        finally {
            if (pkcolumns != null) {
                try {
                    pkcolumns.close();
                }
                catch (SQLException sqle) {}
            }
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException sqle) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public static synchronized void shutdown() throws SQLException {
        if (initialized) {
            initialized = false;
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            if (driver != null) {
                driver.closePool(poolName);
            }
        }
    }

    private static synchronized void initialize() throws SQLException {
        if (initialized) {
            return;
        }
        try {
            PoolingDriver driver;
            Class.forName(ConfigurationManager.getProperty("db.driver"));
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
            int maxConnections = ConfigurationManager.getIntProperty("db.maxconnections");
            if (ConfigurationManager.getProperty("db.maxconnections") == null) {
                maxConnections = 30;
            }
            int maxWait = ConfigurationManager.getIntProperty("db.maxwait");
            if (ConfigurationManager.getProperty("db.maxwait") == null) {
                maxWait = 5000;
            }
            int maxIdle = ConfigurationManager.getIntProperty("db.maxidle");
            if (ConfigurationManager.getProperty("db.maxidle") == null) {
                maxIdle = -1;
            }
            boolean useStatementPool = ConfigurationManager.getBooleanProperty("db.statementpool", true);
            GenericObjectPool connectionPool = new GenericObjectPool(null, maxConnections, 1, (long)maxWait, maxIdle, true, false);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(ConfigurationManager.getProperty("db.url"), ConfigurationManager.getProperty("db.username"), ConfigurationManager.getProperty("db.password"));
            String validationQuery = "SELECT 1";
            if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
                validationQuery = "SELECT 1 FROM DUAL";
            }
            GenericKeyedObjectPoolFactory statementFactory = null;
            if (useStatementPool) {
                GenericKeyedObjectPool.Config statementFactoryConfig = new GenericKeyedObjectPool.Config();
                statementFactoryConfig.whenExhaustedAction = (byte)2;
                statementFactory = new GenericKeyedObjectPoolFactory(null, statementFactoryConfig);
            }
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, statementFactory, validationQuery, false, false);
            if (ConfigurationManager.getProperty("db.poolname") != null) {
                poolName = ConfigurationManager.getProperty("db.poolname");
            }
            if ((driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:")) != null) {
                driver.registerPool(poolName, (ObjectPool)connectionPool);
            }
            initialized = true;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            log.warn((Object)"Exception initializing DB pool", (Throwable)e);
            throw new SQLException(e.toString());
        }
    }

    protected static void loadParameters(PreparedStatement statement, Object[] parameters) throws SQLException {
        statement.clearParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            int idx = i + 1;
            if (parameter == null) {
                throw new SQLException("Attempting to insert null value into SQL query.");
            }
            if (parameter instanceof String) {
                statement.setString(idx, (String)parameters[i]);
                continue;
            }
            if (parameter instanceof Integer) {
                int ii = (Integer)parameter;
                statement.setInt(idx, ii);
                continue;
            }
            if (parameter instanceof Double) {
                double d = (Double)parameter;
                statement.setDouble(idx, d);
                continue;
            }
            if (parameter instanceof Float) {
                float f = ((Float)parameter).floatValue();
                statement.setFloat(idx, f);
                continue;
            }
            if (parameter instanceof Short) {
                short s = (Short)parameter;
                statement.setShort(idx, s);
                continue;
            }
            if (parameter instanceof Long) {
                long l = (Long)parameter;
                statement.setLong(idx, l);
                continue;
            }
            if (parameter instanceof Date) {
                Date date = (Date)parameter;
                statement.setDate(idx, date);
                continue;
            }
            if (parameter instanceof Time) {
                Time time = (Time)parameter;
                statement.setTime(idx, time);
                continue;
            }
            if (parameter instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)parameter;
                statement.setTimestamp(idx, timestamp);
                continue;
            }
            throw new SQLException("Attempting to insert unknown datatype (" + parameter.getClass().getName() + ") into SQL statement.");
        }
    }
}

