/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.app.statistics.AbstractUsageEvent;
import org.dspace.core.ConfigurationManager;

public class UsageEventTabFileLogger
extends AbstractUsageEvent {
    private static Logger errorLog = Logger.getLogger(UsageEventTabFileLogger.class);
    private static PrintWriter log = null;

    public UsageEventTabFileLogger() {
        if (null == log) {
            File logFile;
            String logPath = ConfigurationManager.getProperty("usageEvent.tabFileLogger.file");
            if (null == logPath) {
                errorLog.error((Object)"UsageEventTabFileLogger unconfigured, will not log events");
                return;
            }
            String logDir = null;
            if (!new File(logPath).isAbsolute()) {
                logDir = ConfigurationManager.getProperty("log.dir");
            }
            boolean appending = (logFile = new File(logDir, logPath)).length() > 0L;
            try {
                log = new PrintWriter(new OutputStreamWriter(new FileOutputStream(logFile, true)));
            }
            catch (FileNotFoundException e) {
                errorLog.error((Object)"UsageEventTabFileLogger cannot open file, will not log events", (Throwable)e);
                return;
            }
            if (!appending) {
                log.println("date event objectType objectId sessionId sourceAddress eperson");
            }
        }
    }

    public void fire() {
        if (null == log) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String string = dateFormat.format(new Date());
        string = string + "\t" + new Integer(this.eventType);
        string = string + "\t" + new Integer(this.objectType);
        string = string + "\t" + new Integer(this.objectID);
        string = string + "\t" + this.sessionID;
        string = string + "\t" + this.sourceAddress;
        String epersonName = null == this.eperson ? "anonymous" : this.eperson.getEmail();
        string = string + "\t" + epersonName;
        log.println(string);
        log.flush();
    }
}

