/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.xpath.XPathAPI;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ItemImport {
    static boolean useWorkflow = false;
    static boolean isTest = false;
    static boolean isResume = false;
    static boolean template = false;
    static PrintWriter mapOut = null;
    static FilenameFilter metadataFileFilter = new FilenameFilter(){

        public boolean accept(File dir, String n) {
            return n.startsWith("metadata_");
        }
    };
    static FilenameFilter directoryFilter = new FilenameFilter(){

        public boolean accept(File dir, String n) {
            File item = new File(dir.getAbsolutePath() + File.separatorChar + n);
            return item.isDirectory();
        }
    };

    public static void main(String[] argv) throws Exception {
        File myFile;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("a", "add", false, "add items to DSpace");
        options.addOption("r", "replace", false, "replace items in mapfile");
        options.addOption("d", "delete", false, "delete items listed in mapfile");
        options.addOption("s", "source", true, "source of items (directory)");
        options.addOption("c", "collection", true, "destination collection(s) Handle or database ID");
        options.addOption("m", "mapfile", true, "mapfile items in mapfile");
        options.addOption("e", "eperson", true, "email of eperson doing importing");
        options.addOption("w", "workflow", false, "send submission through collection's workflow");
        options.addOption("t", "test", false, "test run - do not actually import items");
        options.addOption("p", "template", false, "apply template");
        options.addOption("R", "resume", false, "resume a failed import (add only)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, argv);
        String command = null;
        String sourcedir = null;
        String mapfile = null;
        String eperson = null;
        String[] collections = null;
        int status = 0;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("ItemImport\n", options);
            System.out.println("\nadding items:    ItemImport -a -e eperson -c collection -s sourcedir -m mapfile");
            System.out.println("replacing items: ItemImport -r -e eperson -c collection -s sourcedir -m mapfile");
            System.out.println("deleting items:  ItemImport -d -e eperson -m mapfile");
            System.out.println("If multiple collections are specified, the first collection will be the one that owns the item.");
            System.exit(0);
        }
        if (line.hasOption('a')) {
            command = "add";
        }
        if (line.hasOption('r')) {
            command = "replace";
        }
        if (line.hasOption('d')) {
            command = "delete";
        }
        if (line.hasOption('w')) {
            useWorkflow = true;
        }
        if (line.hasOption('t')) {
            isTest = true;
            System.out.println("**Test Run** - not actually importing items.");
        }
        if (line.hasOption('p')) {
            template = true;
        }
        if (line.hasOption('s')) {
            sourcedir = line.getOptionValue('s');
        }
        if (line.hasOption('m')) {
            mapfile = line.getOptionValue('m');
        }
        if (line.hasOption('e')) {
            eperson = line.getOptionValue('e');
        }
        if (line.hasOption('c')) {
            collections = line.getOptionValues('c');
        }
        if (line.hasOption('R')) {
            isResume = true;
            System.out.println("**Resume import** - attempting to import items not already imported");
        }
        if (command == null) {
            System.out.println("Error - must run with either add, replace, or remove (run with -h flag for details)");
            System.exit(1);
        } else if (command.equals("add") || command.equals("replace")) {
            if (sourcedir == null) {
                System.out.println("Error - a source directory containing items must be set");
                System.out.println(" (run with -h flag for details)");
                System.exit(1);
            }
            if (mapfile == null) {
                System.out.println("Error - a map file to hold importing results must be specified");
                System.out.println(" (run with -h flag for details)");
                System.exit(1);
            }
            if (eperson == null) {
                System.out.println("Error - an eperson to do the importing must be specified");
                System.out.println(" (run with -h flag for details)");
                System.exit(1);
            }
            if (collections == null) {
                System.out.println("Error - at least one destination collection must be specified");
                System.out.println(" (run with -h flag for details)");
                System.exit(1);
            }
        } else if (command.equals("delete")) {
            if (eperson == null) {
                System.out.println("Error - an eperson to do the importing must be specified");
                System.exit(1);
            }
            if (mapfile == null) {
                System.out.println("Error - a map file must be specified");
                System.exit(1);
            }
        }
        if (isResume && !command.equals("add")) {
            System.out.println("Error - resume option only works with --add command");
            System.exit(1);
        }
        if ((myFile = new File(mapfile)).exists() && command.equals("add") && !isResume) {
            System.out.println("Error - the mapfile " + mapfile + " already exists.");
            System.out.println("Either delete it or use --resume if attempting to resume an aborted import.");
            System.exit(1);
        }
        ItemImport myloader = new ItemImport();
        Context c = new Context();
        EPerson myEPerson = null;
        myEPerson = eperson.indexOf(64) != -1 ? EPerson.findByEmail(c, eperson) : EPerson.find(c, Integer.parseInt(eperson));
        if (myEPerson == null) {
            System.out.println("Error, eperson cannot be found: " + eperson);
            System.exit(1);
        }
        c.setCurrentUser(myEPerson);
        Collection[] mycollections = null;
        if (!command.equals("delete")) {
            System.out.println("Destination collections:");
            mycollections = new Collection[collections.length];
            for (int i = 0; i < collections.length; ++i) {
                if (collections[i].indexOf(47) != -1) {
                    mycollections[i] = (Collection)HandleManager.resolveToObject(c, collections[i]);
                    if (mycollections[i] == null || mycollections[i].getType() != 3) {
                        mycollections[i] = null;
                    }
                } else if (collections[i] != null) {
                    mycollections[i] = Collection.find(c, Integer.parseInt(collections[i]));
                }
                if (mycollections[i] == null) {
                    throw new IllegalArgumentException("Cannot resolve " + collections[i] + " to collection");
                }
                String owningPrefix = "";
                if (i == 0) {
                    owningPrefix = "Owning ";
                }
                System.out.println(owningPrefix + " Collection: " + mycollections[i].getMetadata("name"));
            }
        }
        try {
            c.setIgnoreAuthorization(true);
            if (command.equals("add")) {
                myloader.addItems(c, mycollections, sourcedir, mapfile, template);
            } else if (command.equals("replace")) {
                myloader.replaceItems(c, mycollections, sourcedir, mapfile, template);
            } else if (command.equals("delete")) {
                myloader.deleteItems(c, mapfile);
            }
            c.complete();
        }
        catch (Exception e) {
            if (mapOut != null) {
                mapOut.close();
            }
            mapOut = null;
            c.abort();
            e.printStackTrace();
            System.out.println(e);
            status = 1;
        }
        if (mapOut != null) {
            mapOut.close();
        }
        if (isTest) {
            System.out.println("***End of Test Run***");
        }
        System.exit(status);
    }

    private void addItems(Context c, Collection[] mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File d;
        Map skipItems = new HashMap();
        System.out.println("Adding items from directory: " + sourceDir);
        System.out.println("Generating mapfile: " + mapFile);
        File outFile = null;
        if (!isTest) {
            if (isResume) {
                skipItems = this.readMapFile(mapFile);
            }
            if ((mapOut = new PrintWriter(new FileWriter(outFile = new File(mapFile), isResume))) == null) {
                throw new Exception("can't open mapfile: " + mapFile);
            }
        }
        if ((d = new File(sourceDir)) == null) {
            System.out.println("Error, cannot open source directory " + sourceDir);
            System.exit(1);
        }
        String[] dircontents = d.list(directoryFilter);
        for (int i = 0; i < dircontents.length; ++i) {
            if (skipItems.containsKey(dircontents[i])) {
                System.out.println("Skipping import of " + dircontents[i]);
                continue;
            }
            this.addItem(c, mycollections, sourceDir, dircontents[i], mapOut, template);
            System.out.println(i + " " + dircontents[i]);
        }
    }

    private void replaceItems(Context c, Collection[] mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File d = new File(sourceDir);
        if (d == null) {
            System.out.println("Error, cannot open source directory " + sourceDir);
            System.exit(1);
        }
        Map myhash = this.readMapFile(mapFile);
        Iterator i = myhash.keySet().iterator();
        ArrayList itemsToDelete = new ArrayList();
        while (i.hasNext()) {
            String newItemName = (String)i.next();
            String oldHandle = (String)myhash.get(newItemName);
            Item oldItem = null;
            Item newItem = null;
            if (oldHandle.indexOf(47) != -1) {
                System.out.println("\tReplacing:  " + oldHandle);
                oldItem = (Item)HandleManager.resolveToObject(c, oldHandle);
            } else {
                oldItem = Item.find(c, Integer.parseInt(oldHandle));
            }
            File handleFile = new File(sourceDir + File.separatorChar + newItemName + File.separatorChar + "handle");
            PrintWriter handleOut = new PrintWriter(new FileWriter(handleFile, true));
            if (handleOut == null) {
                throw new Exception("can't open handle file: " + handleFile.getCanonicalPath());
            }
            handleOut.println(oldHandle);
            handleOut.close();
            this.deleteItem(c, oldItem);
            newItem = this.addItem(c, mycollections, sourceDir, newItemName, null, template);
        }
    }

    private void deleteItems(Context c, String mapFile) throws Exception {
        System.out.println("Deleting items listed in mapfile: " + mapFile);
        Map myhash = this.readMapFile(mapFile);
        Iterator i = myhash.keySet().iterator();
        while (i.hasNext()) {
            String itemID = (String)myhash.get(i.next());
            if (itemID.indexOf(47) != -1) {
                String myhandle = itemID;
                System.out.println("Deleting item " + myhandle);
                this.deleteItem(c, myhandle);
                continue;
            }
            Item myitem = Item.find(c, Integer.parseInt(itemID));
            System.out.println("Deleting item " + itemID);
            this.deleteItem(c, myitem);
        }
    }

    private Item addItem(Context c, Collection[] mycollections, String path, String itemname, PrintWriter mapOut, boolean template) throws Exception {
        String mapOutput = null;
        System.out.println("Adding item from directory " + itemname);
        Item myitem = null;
        WorkspaceItem wi = null;
        if (!isTest) {
            wi = WorkspaceItem.create(c, mycollections[0], template);
            myitem = wi.getItem();
        }
        this.loadMetadata(c, myitem, path + File.separatorChar + itemname + File.separatorChar);
        Vector options = this.processContentsFile(c, myitem, path + File.separatorChar + itemname, "contents");
        if (useWorkflow) {
            if (!isTest) {
                WorkflowManager.startWithoutNotify(c, wi);
                mapOutput = itemname + " " + myitem.getID();
            }
        } else {
            String myhandle = this.processHandleFile(c, myitem, path + File.separatorChar + itemname, "handle");
            if (!isTest) {
                InstallItem.installItem(c, wi, myhandle);
                myhandle = HandleManager.findHandle(c, myitem);
                mapOutput = itemname + " " + myhandle;
            }
            if (options.size() > 0) {
                System.out.println("Processing options");
                this.processOptions(c, myitem, options);
            }
        }
        if (mycollections.length > 1) {
            for (int i = 1; i < mycollections.length; ++i) {
                if (isTest) continue;
                mycollections[i].addItem(myitem);
            }
        }
        if (mapOut != null) {
            mapOut.println(mapOutput);
        }
        c.commit();
        return myitem;
    }

    private void deleteItem(Context c, Item myitem) throws Exception {
        if (!isTest) {
            Collection[] collections = myitem.getCollections();
            for (int i = 0; i < collections.length; ++i) {
                collections[i].removeItem(myitem);
            }
        }
    }

    private void deleteItem(Context c, String myhandle) throws Exception {
        Item myitem = (Item)HandleManager.resolveToObject(c, myhandle);
        if (myitem == null) {
            System.out.println("Error - cannot locate item - already deleted?");
        } else {
            this.deleteItem(c, myitem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map readMapFile(String filename) throws Exception {
        HashMap<String, String> myhash = new HashMap<String, String>();
        BufferedReader is = null;
        try {
            String line;
            is = new BufferedReader(new FileReader(filename));
            while ((line = is.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myfile = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myhandle = st.nextToken();
                myhash.put(myfile, myhandle);
            }
            Object var9_8 = null;
            if (is == null) return myhash;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return myhash;
    }

    private void loadMetadata(Context c, Item myitem, String path) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        this.loadDublinCore(c, myitem, path + "dublin_core.xml");
        File folder = new File(path);
        File[] file = folder.listFiles(metadataFileFilter);
        for (int i = 0; i < file.length; ++i) {
            this.loadDublinCore(c, myitem, file[i].getAbsolutePath());
        }
    }

    private void loadDublinCore(Context c, Item myitem, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = ItemImport.loadXML(filename);
        NodeList metadata = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core");
        Node schemaAttr = metadata.item(0).getAttributes().getNamedItem("schema");
        String schema = schemaAttr == null ? "dc" : schemaAttr.getNodeValue();
        NodeList dcNodes = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core/dcvalue");
        System.out.println("\tLoading dublin core from " + filename);
        for (int i = 0; i < dcNodes.getLength(); ++i) {
            Node n = dcNodes.item(i);
            this.addDCValue(c, myitem, schema, n);
        }
    }

    private void addDCValue(Context c, Item i, String schema, Node n) throws TransformerException, SQLException, AuthorizeException {
        String value = this.getStringValue(n);
        if (value == null) {
            value = "";
        }
        String element = this.getAttributeValue(n, "element");
        String qualifier = this.getAttributeValue(n, "qualifier");
        String language = this.getAttributeValue(n, "language");
        System.out.println("\tSchema: " + schema + " Element: " + element + " Qualifier: " + qualifier + " Value: " + value);
        if (qualifier.equals("none") || "".equals(qualifier)) {
            qualifier = null;
        }
        if (language.equals("")) {
            language = ConfigurationManager.getProperty("default.language");
        }
        if (language == null) {
            language = "en";
        }
        if (!isTest) {
            i.addMetadata(schema, element, qualifier, language, value);
        } else {
            MetadataSchema foundSchema = MetadataSchema.find(c, schema);
            if (foundSchema == null) {
                System.out.println("ERROR: schema '" + schema + "' was not found in the registry.");
                return;
            }
            int schemaID = foundSchema.getSchemaID();
            MetadataField foundField = MetadataField.findByElement(c, schemaID, element, qualifier);
            if (foundField == null) {
                System.out.println("ERROR: Metadata field: '" + schema + "." + element + "." + qualifier + "' was not found in the registry.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processHandleFile(Context c, Item i, String path, String filename) {
        String filePath = path + File.separatorChar + filename;
        String line = "";
        String result = null;
        System.out.println("Processing handle file: " + filename);
        BufferedReader is = null;
        is = new BufferedReader(new FileReader(filePath));
        result = is.readLine();
        System.out.println("read handle: '" + result + "'");
        Object var11_9 = null;
        if (is == null) return result;
        try {
            is.close();
            return result;
        }
        catch (IOException e1) {
            System.err.println("Non-critical problem releasing resources.");
        }
        return result;
        {
            catch (Exception e) {
                System.out.println("It appears there is no handle file -- generating one");
                Object var11_10 = null;
                if (is == null) return result;
                try {
                    is.close();
                    return result;
                }
                catch (IOException e1) {
                    System.err.println("Non-critical problem releasing resources.");
                }
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e1) {
                System.err.println("Non-critical problem releasing resources.");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector processContentsFile(Context c, Item i, String path, String filename) throws SQLException, IOException, AuthorizeException {
        String contentspath = path + File.separatorChar + filename;
        String line = "";
        Vector<String> options = new Vector<String>();
        System.out.println("\tProcessing contents file: " + contentspath);
        BufferedReader is = null;
        try {
            is = new BufferedReader(new FileReader(contentspath));
            while ((line = is.readLine()) != null) {
                if ("".equals(line.trim())) continue;
                if (line.trim().startsWith("-r ")) {
                    String sRegistrationLine = line.trim();
                    int iAssetstore = -1;
                    String sFilePath = null;
                    String sBundle = null;
                    StringTokenizer tokenizer = new StringTokenizer(sRegistrationLine);
                    while (tokenizer.hasMoreTokens()) {
                        String sToken = tokenizer.nextToken();
                        if (sToken.equals("-r")) continue;
                        if (sToken.equals("-s") && tokenizer.hasMoreTokens()) {
                            try {
                                iAssetstore = Integer.parseInt(tokenizer.nextToken());
                            }
                            catch (NumberFormatException e) {}
                            continue;
                        }
                        if (sToken.equals("-f") && tokenizer.hasMoreTokens()) {
                            sFilePath = tokenizer.nextToken();
                            continue;
                        }
                        if (!sToken.startsWith("bundle:")) continue;
                        sBundle = sToken.substring(7);
                    }
                    if (iAssetstore == -1 || sFilePath == null) {
                        System.out.println("\tERROR: invalid contents file line");
                        System.out.println("\t\tSkipping line: " + sRegistrationLine);
                        continue;
                    }
                    this.registerBitstream(c, i, iAssetstore, sFilePath, sBundle);
                    System.out.println("\tRegistering Bitstream: " + sFilePath + "\tAssetstore: " + iAssetstore + "\tBundle: " + sBundle + "\tDescription: " + sBundle);
                    continue;
                }
                int bitstreamEndIndex = line.indexOf("\t");
                if (bitstreamEndIndex == -1) {
                    this.processContentFileEntry(c, i, path, line, null);
                    System.out.println("\tBitstream: " + line);
                    continue;
                }
                String bitstreamName = line.substring(0, bitstreamEndIndex);
                boolean bundleExists = false;
                boolean permissionsExist = false;
                boolean descriptionExists = false;
                String bundleMarker = "\tbundle:";
                int bMarkerIndex = line.indexOf(bundleMarker);
                int bEndIndex = 0;
                if (bMarkerIndex > 0) {
                    bEndIndex = line.indexOf("\t", bMarkerIndex + 1);
                    if (bEndIndex == -1) {
                        bEndIndex = line.length();
                    }
                    bundleExists = true;
                }
                String permissionsMarker = "\tpermissions:";
                int pMarkerIndex = line.indexOf(permissionsMarker);
                int pEndIndex = 0;
                if (pMarkerIndex > 0) {
                    pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                    if (pEndIndex == -1) {
                        pEndIndex = line.length();
                    }
                    permissionsExist = true;
                }
                String descriptionMarker = "\tdescription:";
                int dMarkerIndex = line.indexOf(descriptionMarker);
                int dEndIndex = 0;
                if (dMarkerIndex > 0) {
                    dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                    if (dEndIndex == -1) {
                        dEndIndex = line.length();
                    }
                    descriptionExists = true;
                }
                if (bundleExists) {
                    String bundleName = line.substring(bMarkerIndex + bundleMarker.length(), bEndIndex).trim();
                    this.processContentFileEntry(c, i, path, bitstreamName, bundleName);
                    System.out.println("\tBitstream: " + bitstreamName + "\tBundle: " + bundleName);
                } else {
                    this.processContentFileEntry(c, i, path, bitstreamName, null);
                    System.out.println("\tBitstream: " + bitstreamName);
                }
                if (!permissionsExist && !descriptionExists) continue;
                String extraInfo = bitstreamName;
                if (permissionsExist) {
                    extraInfo = extraInfo + line.substring(pMarkerIndex, pEndIndex);
                }
                if (descriptionExists) {
                    extraInfo = extraInfo + line.substring(dMarkerIndex, dEndIndex);
                }
                options.add(extraInfo);
            }
            Object var25_30 = null;
            if (is == null) return options;
        }
        catch (Throwable throwable) {
            Object var25_31 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return options;
    }

    private void processContentFileEntry(Context c, Item i, String path, String fileName, String bundleName) throws SQLException, IOException, AuthorizeException {
        String fullpath = path + File.separatorChar + fileName;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fullpath));
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (bundleName == null) {
            newBundleName = fileName.equals("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        if (!isTest) {
            Bundle[] bundles = i.getBundles(newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.length < 1 ? i.createBundle(newBundleName) : bundles[0];
            bs = targetBundle.createBitstream(bis);
            bs.setName(fileName);
            BitstreamFormat bf = FormatIdentifier.guessFormat(c, bs);
            bs.setFormat(bf);
            bs.update();
        }
    }

    private void registerBitstream(Context c, Item i, int assetstore, String bitstreamPath, String bundleName) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (bundleName == null) {
            newBundleName = bitstreamPath.endsWith("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        if (!isTest) {
            Bundle[] bundles = i.getBundles(newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.length < 1 ? i.createBundle(newBundleName) : bundles[0];
            bs = targetBundle.registerBitstream(assetstore, bitstreamPath);
            int iLastSlash = bitstreamPath.lastIndexOf(47);
            bs.setName(bitstreamPath.substring(iLastSlash + 1));
            BitstreamFormat bf = FormatIdentifier.guessFormat(c, bs);
            bs.setFormat(bf);
            bs.update();
        }
    }

    private void processOptions(Context c, Item myItem, Vector options) throws SQLException, AuthorizeException {
        for (int i = 0; i < options.size(); ++i) {
            String line = options.elementAt(i).toString();
            System.out.println("\tprocessing " + line);
            boolean permissionsExist = false;
            boolean descriptionExists = false;
            String permissionsMarker = "\tpermissions:";
            int pMarkerIndex = line.indexOf(permissionsMarker);
            int pEndIndex = 0;
            if (pMarkerIndex > 0) {
                pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                if (pEndIndex == -1) {
                    pEndIndex = line.length();
                }
                permissionsExist = true;
            }
            String descriptionMarker = "\tdescription:";
            int dMarkerIndex = line.indexOf(descriptionMarker);
            int dEndIndex = 0;
            if (dMarkerIndex > 0) {
                dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                if (dEndIndex == -1) {
                    dEndIndex = line.length();
                }
                descriptionExists = true;
            }
            int bsEndIndex = line.indexOf("\t");
            String bitstreamName = line.substring(0, bsEndIndex);
            int actionID = -1;
            String groupName = "";
            Group myGroup = null;
            if (permissionsExist) {
                String thisPermission = line.substring(pMarkerIndex + permissionsMarker.length(), pEndIndex);
                int pTypeIndex = thisPermission.indexOf("-");
                int groupIndex = thisPermission.indexOf("'", pTypeIndex);
                int groupEndIndex = thisPermission.indexOf("'", groupIndex + 1);
                if (groupIndex == -1) {
                    groupIndex = thisPermission.indexOf(" ", pTypeIndex);
                    groupEndIndex = thisPermission.length();
                }
                groupName = thisPermission.substring(groupIndex + 1, groupEndIndex);
                if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'r') {
                    actionID = 0;
                } else if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'w') {
                    actionID = 1;
                }
                try {
                    myGroup = Group.findByName(c, groupName);
                }
                catch (SQLException sqle) {
                    System.out.println("SQL Exception finding group name: " + groupName);
                }
            }
            String thisDescription = "";
            if (descriptionExists) {
                thisDescription = line.substring(dMarkerIndex + descriptionMarker.length(), dEndIndex).trim();
            }
            Bitstream bs = null;
            boolean notfound = true;
            if (!isTest) {
                Bitstream[] bitstreams = myItem.getNonInternalBitstreams();
                for (int j = 0; j < bitstreams.length && notfound; ++j) {
                    if (!bitstreams[j].getName().equals(bitstreamName)) continue;
                    bs = bitstreams[j];
                    notfound = false;
                }
            }
            if (notfound && !isTest) {
                System.out.println("\tdefault permissions set for " + bitstreamName);
                continue;
            }
            if (isTest) continue;
            if (permissionsExist) {
                if (myGroup == null) {
                    System.out.println("\t" + groupName + " not found, permissions set to default");
                } else if (actionID == -1) {
                    System.out.println("\tinvalid permissions flag, permissions set to default");
                } else {
                    System.out.println("\tSetting special permissions for " + bitstreamName);
                    this.setPermission(c, myGroup, actionID, bs);
                }
            }
            if (!descriptionExists) continue;
            System.out.println("\tSetting description for " + bitstreamName);
            bs.setDescription(thisDescription);
            bs.update();
        }
    }

    private void setPermission(Context c, Group g, int actionID, Bitstream bs) throws SQLException, AuthorizeException {
        if (!isTest) {
            AuthorizeManager.removeAllPolicies(c, bs);
            ResourcePolicy rp = ResourcePolicy.create(c);
            rp.setResource(bs);
            rp.setAction(actionID);
            rp.setGroup(g);
            rp.update();
        } else if (actionID == 0) {
            System.out.println("\t\tpermissions: READ for " + g.getName());
        } else if (actionID == 1) {
            System.out.println("\t\tpermissions: WRITE for " + g.getName());
        }
    }

    private String getAttributeValue(Node n, String name) {
        NamedNodeMap nm = n.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Node node = nm.item(i);
            if (!name.equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        return "";
    }

    private String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue();
        }
        return value;
    }

    private static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }
}

