/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;

public class XPDF2Text
extends MediaFilter {
    private static Logger log = Logger.getLogger(XPDF2Text.class);
    private static final String[] XPDF_PDFTOTEXT_COMMAND = new String[]{"@COMMAND@", "-q", "@infile@", "-"};
    private String pdftotextPath = null;

    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    public String getBundleName() {
        return "TEXT";
    }

    public String getFormatString() {
        return "Text";
    }

    public String getDescription() {
        return "Extracted Text";
    }

    public InputStream getDestinationStream(InputStream sourceStream) throws Exception {
        if (this.pdftotextPath == null) {
            this.pdftotextPath = ConfigurationManager.getProperty("xpdf.path.pdftotext");
            if (this.pdftotextPath == null) {
                throw new IllegalStateException("No value for key \"xpdf.path.pdftotext\" in DSpace configuration!  Should be path to XPDF pdftotext executable.");
            }
        }
        File sourceTmp = File.createTempFile("DSfilt", ".pdf");
        sourceTmp.deleteOnExit();
        int status = -1;
        try {
            FileOutputStream sto = new FileOutputStream(sourceTmp);
            Utils.copy(sourceStream, sto);
            ((OutputStream)sto).close();
            sourceStream.close();
            Object[] pdfCmd = (String[])XPDF_PDFTOTEXT_COMMAND.clone();
            pdfCmd[0] = this.pdftotextPath;
            pdfCmd[2] = sourceTmp.toString();
            log.debug((Object)("Running command: " + Arrays.deepToString(pdfCmd)));
            Process pdfProc = Runtime.getRuntime().exec((String[])pdfCmd);
            InputStream stdout = pdfProc.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.copy(new BufferedInputStream(stdout), baos);
            stdout.close();
            baos.close();
            status = pdfProc.waitFor();
            if (status != 0) {
                String msg = "pdftotext failed, maybe corrupt PDF? status=" + String.valueOf(status);
                log.error((Object)msg);
                throw new IOException(msg);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (InterruptedException e) {
            log.error((Object)"Failed in pdftotext subprocess: ", (Throwable)e);
            throw e;
        }
        finally {
            sourceTmp.delete();
            if (status != 0) {
                log.error((Object)("PDF conversion proc failed, returns=" + status + ", file=" + sourceTmp));
            }
        }
    }
}

