/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.event.Event;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Bitstream
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Bitstream.class);
    private Context bContext;
    private TableRow bRow;
    private BitstreamFormat bitstreamFormat;
    private boolean modified;
    private boolean modifiedMetadata;

    Bitstream(Context context, TableRow row) throws SQLException {
        this.bContext = context;
        this.bRow = row;
        this.bitstreamFormat = BitstreamFormat.find(context, row.getIntColumn("bitstream_format_id"));
        if (this.bitstreamFormat == null) {
            this.bitstreamFormat = BitstreamFormat.findUnknown(context);
            if (this.bitstreamFormat == null) {
                throw new IllegalStateException("No Unknown bitsream format");
            }
        }
        context.cache(this, row.getIntColumn("bitstream_id"));
        this.modifiedMetadata = false;
        this.modified = false;
        this.clearDetails();
    }

    public static Bitstream find(Context context, int id) throws SQLException {
        Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "bitstream", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bitstream", "not_found,bitstream_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bitstream", "bitstream_id=" + id));
        }
        return new Bitstream(context, row);
    }

    static Bitstream create(Context context, InputStream is) throws IOException, SQLException {
        int bitstreamID = BitstreamStorageManager.store(context, is);
        log.info((Object)LogManager.getHeader(context, "create_bitstream", "bitstream_id=" + bitstreamID));
        Bitstream bitstream = Bitstream.find(context, bitstreamID);
        bitstream.setFormat(null);
        context.addEvent(new Event(1, 0, bitstreamID, null));
        return bitstream;
    }

    static Bitstream register(Context context, int assetstore, String bitstreamPath) throws IOException, SQLException {
        int bitstreamID = BitstreamStorageManager.register(context, assetstore, bitstreamPath);
        log.info((Object)LogManager.getHeader(context, "create_bitstream", "bitstream_id=" + bitstreamID));
        Bitstream bitstream = Bitstream.find(context, bitstreamID);
        bitstream.setFormat(null);
        context.addEvent(new Event(1, 0, bitstreamID, "REGISTER"));
        return bitstream;
    }

    public int getID() {
        return this.bRow.getIntColumn("bitstream_id");
    }

    public String getHandle() {
        return null;
    }

    public int getSequenceID() {
        return this.bRow.getIntColumn("sequence_id");
    }

    public void setSequenceID(int sid) {
        this.bRow.setColumn("sequence_id", sid);
        this.modifiedMetadata = true;
        this.addDetails("SequenceID");
    }

    public String getName() {
        return this.bRow.getStringColumn("name");
    }

    public void setName(String n) {
        this.bRow.setColumn("name", n);
        this.modifiedMetadata = true;
        this.addDetails("Name");
    }

    public String getSource() {
        return this.bRow.getStringColumn("source");
    }

    public void setSource(String n) {
        this.bRow.setColumn("source", n);
        this.modifiedMetadata = true;
        this.addDetails("Source");
    }

    public String getDescription() {
        return this.bRow.getStringColumn("description");
    }

    public void setDescription(String n) {
        this.bRow.setColumn("description", n);
        this.modifiedMetadata = true;
        this.addDetails("Description");
    }

    public String getChecksum() {
        return this.bRow.getStringColumn("checksum");
    }

    public String getChecksumAlgorithm() {
        return this.bRow.getStringColumn("checksum_algorithm");
    }

    public long getSize() {
        return this.bRow.getLongColumn("size_bytes");
    }

    public void setUserFormatDescription(String desc) throws SQLException {
        this.setFormat(null);
        this.bRow.setColumn("user_format_description", desc);
        this.modifiedMetadata = true;
        this.addDetails("UserFormatDescription");
    }

    public String getUserFormatDescription() {
        return this.bRow.getStringColumn("user_format_description");
    }

    public String getFormatDescription() {
        if (this.bitstreamFormat.getShortDescription().equals("Unknown")) {
            String desc = this.bRow.getStringColumn("user_format_description");
            if (desc == null) {
                return "Unknown";
            }
            return desc;
        }
        return this.bitstreamFormat.getShortDescription();
    }

    public BitstreamFormat getFormat() {
        return this.bitstreamFormat;
    }

    public void setFormat(BitstreamFormat f) throws SQLException {
        this.bitstreamFormat = f == null ? BitstreamFormat.findUnknown(this.bContext) : f;
        this.bRow.setColumnNull("user_format_description");
        this.bRow.setColumn("bitstream_format_id", this.bitstreamFormat.getID());
        this.modified = true;
    }

    public void update() throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.bContext, this, 1);
        log.info((Object)LogManager.getHeader(this.bContext, "update_bitstream", "bitstream_id=" + this.getID()));
        if (this.modified) {
            this.bContext.addEvent(new Event(2, 0, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.bContext.addEvent(new Event(4, 0, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
        DatabaseManager.update(this.bContext, this.bRow);
    }

    void delete() throws SQLException {
        boolean oracle = false;
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            oracle = true;
        }
        log.info((Object)LogManager.getHeader(this.bContext, "delete_bitstream", "bitstream_id=" + this.getID()));
        this.bContext.addEvent(new Event(32, 0, this.getID(), String.valueOf(this.getSequenceID())));
        this.bContext.removeCached(this, this.getID());
        AuthorizeManager.removeAllPolicies(this.bContext, this);
        String query = "update bundle set primary_bitstream_id = ";
        query = query + (oracle ? "''" : "Null") + " where primary_bitstream_id = ? ";
        DatabaseManager.updateQuery(this.bContext, query, this.bRow.getIntColumn("bitstream_id"));
        BitstreamStorageManager.delete(this.bContext, this.bRow.getIntColumn("bitstream_id"));
    }

    public InputStream retrieve() throws IOException, SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.bContext, this, 0);
        return BitstreamStorageManager.retrieve(this.bContext, this.bRow.getIntColumn("bitstream_id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(this.bContext, "bundle", "SELECT bundle.* FROM bundle, bundle2bitstream WHERE bundle.bundle_id=bundle2bitstream.bundle_id AND bundle2bitstream.bitstream_id= ? ", this.bRow.getIntColumn("bitstream_id"));
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try {
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Bundle fromCache = (Bundle)this.bContext.fromCache(Bundle.class, r.getIntColumn("bundle_id"));
                if (fromCache != null) {
                    bundles.add(fromCache);
                    continue;
                }
                bundles.add(new Bundle(this.bContext, r));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Bundle[] bundleArray = new Bundle[bundles.size()];
        bundleArray = bundles.toArray(bundleArray);
        return bundleArray;
    }

    public int getType() {
        return 0;
    }

    public boolean isRegisteredBitstream() {
        return BitstreamStorageManager.isRegisteredBitstream(this.bRow.getStringColumn("internal_id"));
    }

    public int getStoreNumber() {
        return this.bRow.getIntColumn("store_number");
    }
}

