/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.ItemIterator;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Item
extends DSpaceObject {
    public static final String ANY = "*";
    private static Logger log = Logger.getLogger(Item.class);
    private Context ourContext;
    private TableRow itemRow;
    private EPerson submitter;
    private List<Bundle> bundles;
    private List<DCValue> dublinCore;
    private String handle;
    private boolean dublinCoreChanged;
    private boolean modified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Item(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.itemRow = row;
        this.dublinCoreChanged = false;
        this.modified = false;
        this.dublinCore = new ArrayList<DCValue>();
        this.clearDetails();
        TableRowIterator tri = this.retrieveMetadata();
        try {
            while (tri.hasNext()) {
                TableRow resultRow = tri.next();
                int fieldID = resultRow.getIntColumn("metadata_field_id");
                MetadataField field = MetadataField.find(context, fieldID);
                if (field == null) {
                    log.error((Object)("Loading item - cannot found metadata field " + fieldID));
                    continue;
                }
                MetadataSchema schema = MetadataSchema.find(context, field.getSchemaID());
                DCValue dcv = new DCValue();
                dcv.element = field.getElement();
                dcv.qualifier = field.getQualifier();
                dcv.value = resultRow.getStringColumn("text_value");
                dcv.language = resultRow.getStringColumn("text_lang");
                dcv.schema = schema.getName();
                this.dublinCore.add(dcv);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("item_id"));
    }

    private TableRowIterator retrieveMetadata() throws SQLException {
        return DatabaseManager.queryTable(this.ourContext, "MetadataValue", "SELECT * FROM MetadataValue WHERE item_id= ? ORDER BY metadata_field_id, place", this.itemRow.getIntColumn("item_id"));
    }

    public static Item find(Context context, int id) throws SQLException {
        Item fromCache = (Item)context.fromCache(Item.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "item", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_item", "not_found,item_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_item", "item_id=" + id));
        }
        return new Item(context, row);
    }

    static Item create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "item");
        Item i = new Item(context, row);
        context.setIgnoreAuthorization(true);
        i.update();
        context.setIgnoreAuthorization(false);
        context.addEvent(new Event(1, 2, i.getID(), null));
        log.info((Object)LogManager.getHeader(context, "create_item", "item_id=" + row.getIntColumn("item_id")));
        return i;
    }

    public static ItemIterator findAll(Context context) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1'";
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findBySubmitter(Context context, EPerson eperson) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1' AND submitter_id=" + eperson.getID();
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public int getID() {
        return this.itemRow.getIntColumn("item_id");
    }

    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public boolean isArchived() {
        return this.itemRow.getBooleanColumn("in_archive");
    }

    public boolean isWithdrawn() {
        return this.itemRow.getBooleanColumn("withdrawn");
    }

    public Date getLastModified() {
        Date myDate = this.itemRow.getDateColumn("last_modified");
        if (myDate == null) {
            myDate = new Date();
        }
        return myDate;
    }

    public void setArchived(boolean isArchived) {
        this.itemRow.setColumn("in_archive", isArchived);
        this.modified = true;
    }

    public void setOwningCollection(Collection c) {
        this.itemRow.setColumn("owning_collection", c.getID());
        this.modified = true;
    }

    public Collection getOwningCollection() throws SQLException {
        Collection myCollection = null;
        int cid = this.itemRow.getIntColumn("owning_collection");
        myCollection = Collection.find(this.ourContext, cid);
        return myCollection;
    }

    @Deprecated
    public DCValue[] getDC(String element, String qualifier, String lang) {
        return this.getMetadata("dc", element, qualifier, lang);
    }

    public DCValue[] getMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<DCValue> values = new ArrayList<DCValue>();
        for (DCValue dcv : this.dublinCore) {
            if (!this.match(schema, element, qualifier, lang, dcv)) continue;
            DCValue copy = new DCValue();
            copy.element = dcv.element;
            copy.qualifier = dcv.qualifier;
            copy.value = dcv.value;
            copy.language = dcv.language;
            copy.schema = dcv.schema;
            values.add(copy);
        }
        DCValue[] valueArray = new DCValue[values.size()];
        valueArray = values.toArray(valueArray);
        return valueArray;
    }

    public DCValue[] getMetadata(String mdString) {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().toLowerCase().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        DCValue[] values = ANY.equals(qualifier) ? this.getMetadata(schema, element, ANY, ANY) : ("".equals(qualifier) ? this.getMetadata(schema, element, null, ANY) : this.getMetadata(schema, element, qualifier, ANY));
        return values;
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String[] values) {
        this.addMetadata("dc", element, qualifier, lang, values);
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String value) {
        this.addMetadata("dc", element, qualifier, lang, value);
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            DCValue dcv = new DCValue();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            dcv.language = lang;
            if (values[i] != null) {
                String temp = values[i].trim();
                char[] dcvalue = temp.toCharArray();
                for (int charPos = 0; charPos < dcvalue.length; ++charPos) {
                    if (!Character.isISOControl(dcvalue[charPos]) || String.valueOf(dcvalue[charPos]).equals("\t") || String.valueOf(dcvalue[charPos]).equals("\n") || String.valueOf(dcvalue[charPos]).equals("\r")) continue;
                    dcvalue[charPos] = 32;
                }
                dcv.value = String.valueOf(dcvalue);
            } else {
                dcv.value = null;
            }
            this.dublinCore.add(dcv);
            this.addDetails(schema + "." + element + (qualifier == null ? "" : "." + qualifier));
        }
        if (values.length > 0) {
            this.dublinCoreChanged = true;
        }
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String value) {
        String[] valArray = new String[]{value};
        this.addMetadata(schema, element, qualifier, lang, valArray);
    }

    @Deprecated
    public void clearDC(String element, String qualifier, String lang) {
        this.clearMetadata("dc", element, qualifier, lang);
    }

    public void clearMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<DCValue> values = new ArrayList<DCValue>();
        for (DCValue dcv : this.dublinCore) {
            if (this.match(schema, element, qualifier, lang, dcv)) continue;
            values.add(dcv);
        }
        this.dublinCore = values;
        this.dublinCoreChanged = true;
    }

    private boolean match(String schema, String element, String qualifier, String language, DCValue dcv) {
        if (!element.equals(ANY) && !element.equals(dcv.element)) {
            return false;
        }
        if (qualifier == null ? dcv.qualifier != null : !qualifier.equals(ANY) && !qualifier.equals(dcv.qualifier)) {
            return false;
        }
        return !(language == null ? dcv.language != null : (!language.equals(ANY) ? !language.equals(dcv.language) : !schema.equals(ANY) && dcv.schema != null && !dcv.schema.equals(schema)));
    }

    public EPerson getSubmitter() throws SQLException {
        if (this.submitter == null && !this.itemRow.isColumnNull("submitter_id")) {
            this.submitter = EPerson.find(this.ourContext, this.itemRow.getIntColumn("submitter_id"));
        }
        return this.submitter;
    }

    public void setSubmitter(EPerson sub) {
        this.submitter = sub;
        if (this.submitter != null) {
            this.itemRow.setColumn("submitter_id", this.submitter.getID());
        } else {
            this.itemRow.setColumnNull("submitter_id");
        }
        this.modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection[] getCollections() throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "collection", "SELECT collection.* FROM collection, collection2item WHERE collection2item.collection_id=collection.collection_id AND collection2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Collection fromCache = (Collection)this.ourContext.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(this.ourContext, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community[] getCommunities() throws SQLException {
        ArrayList<Community> communities = new ArrayList<Community>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2item WHERE community2item.community_id=community.community_id AND community2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Community owner = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                if (owner == null) {
                    owner = new Community(this.ourContext, row);
                }
                communities.add(owner);
                Community[] parents = owner.getAllParents();
                for (int i = 0; i < parents.length; ++i) {
                    communities.add(parents[i]);
                }
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() throws SQLException {
        if (this.bundles == null) {
            this.bundles = new ArrayList<Bundle>();
            TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "bundle", "SELECT bundle.* FROM bundle, item2bundle WHERE item2bundle.bundle_id=bundle.bundle_id AND item2bundle.item_id= ? ", this.itemRow.getIntColumn("item_id"));
            try {
                while (tri.hasNext()) {
                    TableRow r = tri.next();
                    Bundle fromCache = (Bundle)this.ourContext.fromCache(Bundle.class, r.getIntColumn("bundle_id"));
                    if (fromCache != null) {
                        this.bundles.add(fromCache);
                        continue;
                    }
                    this.bundles.add(new Bundle(this.ourContext, r));
                }
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
        }
        Bundle[] bundleArray = new Bundle[this.bundles.size()];
        bundleArray = this.bundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle[] getBundles(String name) throws SQLException {
        ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (!name.equals(bunds[i].getName())) continue;
            matchingBundles.add(bunds[i]);
        }
        Bundle[] bundleArray = new Bundle[matchingBundles.size()];
        bundleArray = matchingBundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle createBundle(String name) throws SQLException, AuthorizeException {
        if (name == null || "".equals(name)) {
            throw new SQLException("Bundle must be created with non-null name");
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bundle b = Bundle.create(this.ourContext);
        b.setName(name);
        b.update();
        this.addBundle(b);
        return b;
    }

    public void addBundle(Bundle b) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            return;
        }
        AuthorizeManager.inheritPolicies(this.ourContext, this, b);
        this.bundles.add(b);
        TableRow mappingRow = DatabaseManager.create(this.ourContext, "item2bundle");
        mappingRow.setColumn("item_id", this.getID());
        mappingRow.setColumn("bundle_id", b.getID());
        DatabaseManager.update(this.ourContext, mappingRow);
        this.ourContext.addEvent(new Event(8, 2, this.getID(), 1, b.getID(), b.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundle(Bundle b) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            this.bundles.remove(bunds[i]);
            break;
        }
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM item2bundle WHERE item_id= ? AND bundle_id= ? ", this.getID(), b.getID());
        this.ourContext.addEvent(new Event(16, 2, this.getID(), 1, b.getID(), b.getName()));
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM item2bundle WHERE bundle_id= ? ", b.getID());
        try {
            if (!tri.hasNext()) {
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 2, this.ourContext.getCurrentUser());
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 4, this.ourContext.getCurrentUser());
                b.delete();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public Bitstream createSingleBitstream(InputStream is, String name) throws AuthorizeException, IOException, SQLException {
        Bundle bnd = this.createBundle(name);
        Bitstream bitstream = bnd.createBitstream(is);
        this.addBundle(bnd);
        return bitstream;
    }

    public Bitstream createSingleBitstream(InputStream is) throws AuthorizeException, IOException, SQLException {
        return this.createSingleBitstream(is, "ORIGINAL");
    }

    public Bitstream[] getNonInternalBitstreams() throws SQLException {
        ArrayList<Bitstream> bitstreamList = new ArrayList<Bitstream>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bitstream[] bitstreams = bunds[i].getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                if (bitstreams[j].getFormat().isInternal()) continue;
                bitstreamList.add(bitstreams[j]);
            }
        }
        Bitstream[] bsArray = new Bitstream[bitstreamList.size()];
        bsArray = bitstreamList.toArray(bsArray);
        return bsArray;
    }

    public void licenseGranted(String license, EPerson eperson) throws SQLException, IOException, AuthorizeException {
        String licenseText = "License granted by " + eperson.getFullName() + " (" + eperson.getEmail() + ") on " + DCDate.getCurrent().toString() + " (GMT):\n\n" + license;
        byte[] licenseBytes = licenseText.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(licenseBytes);
        Bitstream b = this.createSingleBitstream(bais, "LICENSE");
        b.setName("license.txt");
        b.setSource("Written by org.dspace.content.Item");
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(this.ourContext, "License");
        b.setFormat(bf);
        b.update();
    }

    public void removeDSpaceLicense() throws SQLException, AuthorizeException, IOException {
        Bundle[] bunds = this.getBundles("LICENSE");
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
    }

    public void removeLicenses() throws SQLException, AuthorizeException, IOException {
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(this.ourContext, "License");
        int licensetype = bf.getID();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            boolean removethisbundle = false;
            Bitstream[] bits = bunds[i].getBitstreams();
            for (int j = 0; j < bits.length; ++j) {
                BitstreamFormat bft = bits[j].getFormat();
                if (bft.getID() != licensetype) continue;
                removethisbundle = true;
            }
            if (!removethisbundle) continue;
            this.removeBundle(bunds[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws SQLException, AuthorizeException {
        int k;
        Bitstream[] streams;
        int i;
        if (!this.canEdit()) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "update_item", "item_id=" + this.getID()));
        this.itemRow.setColumn("last_modified", new Date());
        int sequence = 0;
        Bundle[] bunds = this.getBundles();
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() <= sequence) continue;
                sequence = streams[k].getSequenceID();
            }
        }
        ++sequence;
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() >= 0) continue;
                streams[k].setSequenceID(sequence);
                ++sequence;
                streams[k].update();
            }
        }
        if (this.itemRow.isColumnNull("in_archive")) {
            this.itemRow.setColumn("in_archive", false);
        }
        if (this.itemRow.isColumnNull("withdrawn")) {
            this.itemRow.setColumn("withdrawn", false);
        }
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        DatabaseManager.update(this.ourContext, this.itemRow);
        if (this.dublinCoreChanged) {
            int[] placeNum = new int[this.dublinCore.size()];
            boolean[] storedDC = new boolean[this.dublinCore.size()];
            MetadataField[] dcFields = new MetadataField[this.dublinCore.size()];
            for (int dcIdx = 0; dcIdx < this.dublinCore.size(); ++dcIdx) {
                DCValue dcv = this.dublinCore.get(dcIdx);
                int current = 0;
                String key = dcv.element + (dcv.qualifier == null ? "" : "." + dcv.qualifier);
                Integer currentInteger = (Integer)elementCount.get(key);
                if (currentInteger != null) {
                    current = currentInteger;
                }
                elementCount.put(key, ++current);
                placeNum[dcIdx] = current;
                storedDC[dcIdx] = false;
                dcFields[dcIdx] = this.getMetadataField(dcv);
                if (dcFields[dcIdx] != null) continue;
                log.warn((Object)LogManager.getHeader(this.ourContext, "bad_dc", "Bad DC field. schema=" + String.valueOf(dcv.schema) + ", element: \"" + (dcv.element == null ? "null" : dcv.element) + "\" qualifier: \"" + (dcv.qualifier == null ? "null" : dcv.qualifier) + "\" value: \"" + (dcv.value == null ? "null" : dcv.value) + "\""));
                throw new SQLException("bad_dublin_core schema=" + dcv.schema + ", " + dcv.element + " " + dcv.qualifier);
            }
            TableRowIterator tri = this.retrieveMetadata();
            if (tri != null) {
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean removeRow = true;
                        for (int dcIdx = 0; dcIdx < this.dublinCore.size() && removeRow; ++dcIdx) {
                            if (storedDC[dcIdx]) continue;
                            boolean matched = true;
                            DCValue dcv = this.dublinCore.get(dcIdx);
                            if (matched && dcFields[dcIdx].getFieldID() != tr.getIntColumn("metadata_field_id")) {
                                matched = false;
                            }
                            if (matched && placeNum[dcIdx] != tr.getIntColumn("place")) {
                                matched = false;
                            }
                            if (matched) {
                                String text = tr.getStringColumn("text_value");
                                matched = dcv.value == null && text == null ? true : dcv.value != null && dcv.value.equals(text);
                            }
                            if (matched) {
                                String lang = tr.getStringColumn("text_lang");
                                matched = dcv.language == null && lang == null ? true : dcv.language != null && dcv.language.equals(lang);
                            }
                            if (!matched) continue;
                            storedDC[dcIdx] = true;
                            removeRow = false;
                        }
                        if (!removeRow) continue;
                        DatabaseManager.delete(this.ourContext, tr);
                    }
                }
                finally {
                    tri.close();
                }
            }
            for (int dcIdx = 0; dcIdx < this.dublinCore.size(); ++dcIdx) {
                if (storedDC[dcIdx]) continue;
                DCValue dcv = this.dublinCore.get(dcIdx);
                MetadataValue metadata = new MetadataValue();
                metadata.setItemId(this.getID());
                metadata.setFieldId(dcFields[dcIdx].getFieldID());
                metadata.setValue(dcv.value);
                metadata.setLanguage(dcv.language);
                metadata.setPlace(placeNum[dcIdx]);
                metadata.create(this.ourContext);
            }
            this.ourContext.addEvent(new Event(4, 2, this.getID(), this.getDetails()));
            this.dublinCoreChanged = false;
            this.clearDetails();
        }
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null));
            this.modified = false;
        }
    }

    private MetadataField getMetadataField(DCValue dcv) throws SQLException, AuthorizeException {
        return MetadataField.findByElement(this.ourContext, this.getMetadataSchemaID(dcv), dcv.element, dcv.qualifier);
    }

    private int getMetadataSchemaID(DCValue dcv) throws SQLException {
        MetadataSchema schema = MetadataSchema.find(this.ourContext, dcv.schema);
        int schemaID = schema == null ? 1 : schema.getSchemaID();
        return schemaID;
    }

    public void withdraw() throws SQLException, AuthorizeException, IOException {
        String timestamp = DCDate.getCurrent().toString();
        String collectionProv = "";
        Collection[] colls = this.getCollections();
        for (int i = 0; i < colls.length; ++i) {
            collectionProv = collectionProv + colls[i].getMetadata("name") + " (ID: " + colls[i].getID() + ")\n";
        }
        if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, this.getOwningCollection(), 11) && !AuthorizeManager.authorizeActionBoolean(this.ourContext, this.getOwningCollection(), 4)) {
            throw new AuthorizeException("To withdraw item must be COLLECTION_ADMIN or have REMOVE authorization on owning Collection");
        }
        this.itemRow.setColumn("withdrawn", true);
        this.itemRow.setColumn("in_archive", false);
        EPerson e = this.ourContext.getCurrentUser();
        String prov = "Item withdrawn by " + e.getFullName() + " (" + e.getEmail() + ") on " + timestamp + "\n" + "Item was in collections:\n" + collectionProv + InstallItem.getBitstreamProvenanceMessage(this);
        this.addDC("description", "provenance", "en", prov);
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "WITHDRAW"));
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        log.info((Object)LogManager.getHeader(this.ourContext, "withdraw_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    public void reinstate() throws SQLException, AuthorizeException, IOException {
        String timestamp = DCDate.getCurrent().toString();
        String collectionProv = "";
        Collection[] colls = this.getCollections();
        for (int i = 0; i < colls.length; ++i) {
            collectionProv = collectionProv + colls[i].getMetadata("name") + " (ID: " + colls[i].getID() + ")\n";
            AuthorizeManager.authorizeAction(this.ourContext, colls[i], 3);
        }
        this.itemRow.setColumn("withdrawn", false);
        this.itemRow.setColumn("in_archive", true);
        EPerson e = this.ourContext.getCurrentUser();
        String prov = "Item reinstated by " + e.getFullName() + " (" + e.getEmail() + ") on " + timestamp + "\n" + "Item was in collections:\n" + collectionProv + InstallItem.getBitstreamProvenanceMessage(this);
        this.addDC("description", "provenance", "en", prov);
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "REINSTATE"));
        if (colls.length > 0) {
            this.inheritCollectionDefaultPolicies(colls[0]);
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "reinstate_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    void delete() throws SQLException, AuthorizeException, IOException {
        this.ourContext.addEvent(new Event(32, 2, this.getID(), this.getHandle()));
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_item", "item_id=" + this.getID()));
        this.ourContext.removeCached(this, this.getID());
        try {
            IndexBrowse ib = new IndexBrowse(this.ourContext);
            ib.itemRemoved(this);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SQLException(e.getMessage());
        }
        this.removeMetadataFromDatabase();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM handle WHERE resource_type_id= ? AND resource_id= ? ", 2, this.getID());
        DatabaseManager.delete(this.ourContext, this.itemRow);
    }

    public void decache() throws SQLException {
        this.ourContext.removeCached(this, this.getID());
        if (this.submitter != null) {
            this.ourContext.removeCached(this.submitter, this.submitter.getID());
        }
        if (this.bundles != null) {
            Bundle[] bunds = this.getBundles();
            for (int i = 0; i < bunds.length; ++i) {
                this.ourContext.removeCached(bunds[i], bunds[i].getID());
                Bitstream[] bitstreams = bunds[i].getBitstreams();
                for (int j = 0; j < bitstreams.length; ++j) {
                    this.ourContext.removeCached(bitstreams[j], bitstreams[j].getID());
                }
            }
        }
    }

    public boolean equals(DSpaceObject other) {
        return this.getType() == other.getType() && this.getID() == other.getID();
    }

    public boolean isOwningCollection(Collection c) {
        int owner_id = this.itemRow.getIntColumn("owning_collection");
        return c.getID() == owner_id;
    }

    private void removeMetadataFromDatabase() throws SQLException {
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM MetadataValue WHERE item_id= ? ", this.getID());
    }

    public int getType() {
        return 2;
    }

    public void replaceAllItemPolicies(List newpolicies) throws SQLException, AuthorizeException {
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        AuthorizeManager.addPolicies(this.ourContext, newpolicies, this);
    }

    public void replaceAllBitstreamPolicies(List newpolicies) throws SQLException, AuthorizeException {
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            mybundle.replaceAllBitstreamPolicies(newpolicies);
        }
    }

    public void removeGroupPolicies(Group g) throws SQLException {
        AuthorizeManager.removeGroupPolicies(this.ourContext, this, g);
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            Bitstream[] bs = mybundle.getBitstreams();
            for (int j = 0; j < bs.length; ++j) {
                Bitstream mybitstream = bs[j];
                AuthorizeManager.removeGroupPolicies(this.ourContext, bs[j], g);
            }
            AuthorizeManager.removeGroupPolicies(this.ourContext, mybundle, g);
        }
    }

    public void inheritCollectionDefaultPolicies(Collection c) throws SQLException, AuthorizeException {
        ResourcePolicy rp;
        List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 10);
        Iterator<ResourcePolicy> i = policies.iterator();
        if (!i.hasNext()) {
            throw new SQLException("Collection " + c.getID() + " has no default item READ policies");
        }
        while (i.hasNext()) {
            rp = i.next();
            rp.setAction(0);
        }
        this.replaceAllItemPolicies(policies);
        policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 9);
        i = policies.iterator();
        if (!i.hasNext()) {
            throw new SQLException("Collection " + c.getID() + " has no default bitstream READ policies");
        }
        while (i.hasNext()) {
            rp = i.next();
            rp.setAction(0);
        }
        this.replaceAllBitstreamPolicies(policies);
    }

    public void move(Collection from, Collection to) throws SQLException, AuthorizeException, IOException {
        to.addItem(this);
        from.removeItem(this);
        if (this.isOwningCollection(from)) {
            this.setOwningCollection(to);
            this.update();
        } else {
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null));
        }
    }

    public boolean hasUploadedFiles() throws SQLException {
        Bundle[] bundles = this.getBundles("ORIGINAL");
        if (bundles.length == 0) {
            return false;
        }
        Bitstream[] bitstreams = bundles[0].getBitstreams();
        return bitstreams.length != 0;
    }

    public Collection[] getCollectionsNotLinked() throws SQLException {
        Collection[] allCollections = Collection.findAll(this.ourContext);
        Collection[] linkedCollections = this.getCollections();
        Collection[] notLinkedCollections = new Collection[allCollections.length - linkedCollections.length];
        if (allCollections.length - linkedCollections.length == 0) {
            return notLinkedCollections;
        }
        int i = 0;
        for (Collection collection : allCollections) {
            boolean alreadyLinked = false;
            for (Collection linkedCommunity : linkedCollections) {
                if (collection.getID() != linkedCommunity.getID()) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked) continue;
            notLinkedCollections[i++] = collection;
        }
        return notLinkedCollections;
    }

    public boolean canEdit() throws SQLException {
        if (AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 1)) {
            return true;
        }
        if (this.getOwningCollection() == null) {
            return true;
        }
        if (this.getOwningCollection().canEditBoolean()) {
            return true;
        }
        return AuthorizeManager.authorizeActionBoolean(this.ourContext, this.getOwningCollection(), 11);
    }

    public String getName() {
        DCValue[] t = this.getMetadata("dc", "title", null, ANY);
        return t.length >= 1 ? t[0].value : null;
    }
}

