/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.Checksumtype;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FLocat;
import edu.harvard.hul.ois.mets.File;
import edu.harvard.hul.ois.mets.FileGrp;
import edu.harvard.hul.ois.mets.FileSec;
import edu.harvard.hul.ois.mets.Fptr;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.TechMD;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PCData;
import edu.harvard.hul.ois.mets.helper.PreformedXML;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractMETSDisseminator
implements PackageDisseminator {
    private static Logger log = Logger.getLogger(AbstractMETSDisseminator.class);
    public static final String MANIFEST_FILE = "mets.xml";
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    private int idCounter = 1;
    protected Map extraFiles = null;

    protected String gensym(String prefix) {
        return prefix + "_" + String.valueOf(this.idCounter++);
    }

    public String getMIMEType(PackageParameters params) {
        return params != null && params.getProperty("manifestOnly") != null ? "text/xml" : "application/zip";
    }

    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, OutputStream pkg) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (dso.getType() == 2) {
            String unauth;
            Item item = (Item)dso;
            long lmTime = item.getLastModified().getTime();
            String string = unauth = params == null ? null : params.getProperty("unauthorized");
            if (params != null && params.getProperty("manifestOnly") != null) {
                this.extraFiles = null;
                this.writeManifest(context, item, params, pkg);
            } else {
                this.extraFiles = new HashMap();
                ZipOutputStream zip = new ZipOutputStream(pkg);
                zip.setComment("METS archive created by DSpace METSDisseminationCrosswalk");
                ZipEntry me = new ZipEntry(MANIFEST_FILE);
                me.setTime(lmTime);
                zip.putNextEntry(me);
                this.writeManifest(context, item, params, zip);
                zip.closeEntry();
                for (String fname : this.extraFiles.keySet()) {
                    ZipEntry ze = new ZipEntry(fname);
                    ze.setTime(lmTime);
                    zip.putNextEntry(ze);
                    Utils.copy((InputStream)this.extraFiles.get(fname), zip);
                    zip.closeEntry();
                }
                Bundle[] bundles = item.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if (PackageUtils.isMetaInfoBundle(bundles[i])) continue;
                    if (!AuthorizeManager.authorizeActionBoolean(context, bundles[i], 0)) {
                        if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                            log.warn((Object)("Skipping Bundle[\"" + bundles[i].getName() + "\"] because you are not authorized to read it."));
                            continue;
                        }
                        throw new AuthorizeException("Not authorized to read Bundle named \"" + bundles[i].getName() + "\"");
                    }
                    Bitstream[] bitstreams = bundles[i].getBitstreams();
                    for (int k = 0; k < bitstreams.length; ++k) {
                        boolean auth = AuthorizeManager.authorizeActionBoolean(context, bitstreams[k], 0);
                        if (auth || unauth != null && unauth.equalsIgnoreCase("zero")) {
                            ZipEntry ze = new ZipEntry(this.makeBitstreamName(bitstreams[k]));
                            ze.setTime(lmTime);
                            ze.setSize(auth ? bitstreams[k].getSize() : 0L);
                            zip.putNextEntry(ze);
                            if (auth) {
                                Utils.copy(bitstreams[k].retrieve(), zip);
                            } else {
                                log.warn((Object)("Adding zero-length file for Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()) + ", not authorized for READ."));
                            }
                            zip.closeEntry();
                            continue;
                        }
                        if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                            log.warn((Object)("Skipping Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()) + ", not authorized for READ."));
                            continue;
                        }
                        throw new AuthorizeException("Not authorized to read Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()));
                    }
                }
                zip.close();
                this.extraFiles = null;
            }
        } else {
            throw new PackageValidationException("Can only disseminate an Item now.");
        }
    }

    private String makeBitstreamName(Bitstream bitstream) {
        String base = "bitstream_" + String.valueOf(bitstream.getID());
        String[] ext = bitstream.getFormat().getExtensions();
        return ext.length > 0 ? base + "." + ext[0] : base;
    }

    private void setMdType(MdWrap mdWrap, String mdtype) {
        try {
            mdWrap.setMDTYPE(Mdtype.parse((String)mdtype));
        }
        catch (MetsException e) {
            mdWrap.setMDTYPE(Mdtype.OTHER);
            mdWrap.setOTHERMDTYPE(mdtype);
        }
    }

    private void writeManifest(Context context, Item item, PackageParameters params, OutputStream out) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        try {
            String xwalkName;
            String metsName;
            Mets mets = new Mets();
            mets.setID(this.gensym("mets"));
            mets.setOBJID("hdl:" + item.getHandle());
            mets.setLABEL("DSpace Item");
            mets.setPROFILE(this.getProfile());
            MetsHdr metsHdr = new MetsHdr();
            metsHdr.setCREATEDATE(new Date());
            Agent agent = new Agent();
            agent.setROLE(Role.CUSTODIAN);
            agent.setTYPE(Type.ORGANIZATION);
            Name name = new Name();
            name.getContent().add(new PCData(ConfigurationManager.getProperty("dspace.name")));
            agent.getContent().add(name);
            metsHdr.getContent().add(agent);
            mets.getContent().add(metsHdr);
            String[] dmdTypes = this.getDmdTypes(params);
            String dmdGroup = this.gensym("dmd_group");
            String[] dmdId = new String[dmdTypes.length];
            for (int i = 0; i < dmdTypes.length; ++i) {
                String xwalkName2;
                String metsName2;
                dmdId[i] = this.gensym("dmd");
                XmlData xmlData = new XmlData();
                String[] parts = dmdTypes[i].split(":", 2);
                if (parts.length > 1) {
                    metsName2 = parts[0];
                    xwalkName2 = parts[1];
                } else {
                    xwalkName2 = metsName2 = dmdTypes[i];
                }
                DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, xwalkName2);
                if (xwalk == null) {
                    throw new PackageValidationException("Cannot find " + dmdTypes[i] + " crosswalk plugin!");
                }
                this.crosswalkToMets(xwalk, item, (MetsElement)xmlData);
                DmdSec dmdSec = new DmdSec();
                dmdSec.setID(dmdId[i]);
                dmdSec.setGROUPID(dmdGroup);
                MdWrap mdWrap = new MdWrap();
                this.setMdType(mdWrap, metsName2);
                mdWrap.getContent().add(xmlData);
                dmdSec.getContent().add(mdWrap);
                mets.getContent().add(dmdSec);
            }
            String licenseID = null;
            try {
                AmdSec amdSec = new AmdSec();
                this.addRightsMd(context, item, amdSec);
                if (amdSec.getContent().size() > 0) {
                    licenseID = this.gensym("license");
                    amdSec.setID(licenseID);
                    mets.getContent().add(amdSec);
                }
            }
            catch (AuthorizeException e) {
                String unauth;
                String string = unauth = params == null ? null : params.getProperty("unauthorized");
                if (unauth == null || !unauth.equalsIgnoreCase("skip")) {
                    throw e;
                }
                log.warn((Object)("Skipping license metadata because of access failure: " + e.toString()));
            }
            FileSec fileSec = new FileSec();
            String techMdType = this.getTechMdType(params);
            String[] parts = techMdType.split(":", 2);
            if (parts.length > 1) {
                metsName = parts[0];
                xwalkName = parts[1];
            } else {
                xwalkName = metsName = techMdType;
            }
            DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, xwalkName);
            if (xwalk == null) {
                throw new PackageValidationException("Cannot find " + xwalkName + " crosswalk plugin!");
            }
            String primaryBitstreamFileID = null;
            ArrayList<Div> contentDivs = new ArrayList<Div>();
            String unauth = params == null ? null : params.getProperty("unauthorized");
            Bundle[] bundles = item.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (PackageUtils.isMetaInfoBundle(bundles[i])) continue;
                if (!AuthorizeManager.authorizeActionBoolean(context, bundles[i], 0)) {
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) continue;
                    throw new AuthorizeException("Not authorized to read Bundle named \"" + bundles[i].getName() + "\"");
                }
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                FileGrp fileGrp = new FileGrp();
                String bName = bundles[i].getName();
                if (bName != null && !bName.equals("")) {
                    fileGrp.setUSE(this.bundleToFileGrp(bName));
                }
                int primaryBitstreamID = -1;
                boolean isContentBundle = false;
                if (bName != null && bName.equals("ORIGINAL")) {
                    isContentBundle = true;
                    primaryBitstreamID = bundles[i].getPrimaryBitstreamID();
                }
                for (int bits = 0; bits < bitstreams.length; ++bits) {
                    Bitstream original;
                    boolean auth = AuthorizeManager.authorizeActionBoolean(context, bitstreams[bits], 0);
                    if (!auth) {
                        if (unauth != null && unauth.equalsIgnoreCase("skip")) continue;
                        if (unauth == null || !unauth.equalsIgnoreCase("zero")) {
                            throw new AuthorizeException("Not authorized to read Bitstream, SID=" + String.valueOf(bitstreams[bits].getSequenceID()));
                        }
                    }
                    String sid = String.valueOf(bitstreams[bits].getSequenceID());
                    File file = new File();
                    String xmlIDstart = "bitstream_";
                    String fileID = xmlIDstart + sid;
                    file.setID(fileID);
                    if (bitstreams[bits].getID() == primaryBitstreamID) {
                        primaryBitstreamFileID = fileID;
                    }
                    if (isContentBundle) {
                        Div div = new Div();
                        div.setID(this.gensym("div"));
                        div.setTYPE("DSpace Content Bitstream");
                        Fptr fptr = new Fptr();
                        fptr.setFILEID(fileID);
                        div.getContent().add(fptr);
                        contentDivs.add(div);
                    }
                    file.setSEQ(bitstreams[bits].getSequenceID());
                    String groupID = "GROUP_" + xmlIDstart + sid;
                    if (bundles[i].getName() != null && (bundles[i].getName().equals("THUMBNAIL") || bundles[i].getName().startsWith("TEXT")) && (original = AbstractMETSDisseminator.findOriginalBitstream(item, bitstreams[bits])) != null) {
                        groupID = "GROUP_" + xmlIDstart + original.getSequenceID();
                    }
                    file.setGROUPID(groupID);
                    file.setMIMETYPE(bitstreams[bits].getFormat().getMIMEType());
                    file.setSIZE(auth ? bitstreams[bits].getSize() : 0L);
                    String csType = bitstreams[bits].getChecksumAlgorithm();
                    String cs = bitstreams[bits].getChecksum();
                    if (auth && cs != null && csType != null) {
                        try {
                            file.setCHECKSUMTYPE(Checksumtype.parse((String)csType));
                            file.setCHECKSUM(cs);
                        }
                        catch (MetsException e) {
                            log.warn((Object)("Cannot set bitstream checksum type=" + csType + " in METS."));
                        }
                    }
                    FLocat flocat = new FLocat();
                    flocat.setLOCTYPE(Loctype.URL);
                    flocat.setXlinkHref(this.makeBitstreamName(bitstreams[bits]));
                    String techID = "techMd_for_bitstream_" + bitstreams[bits].getSequenceID();
                    AmdSec fAmdSec = new AmdSec();
                    fAmdSec.setID(techID);
                    TechMD techMd = new TechMD();
                    techMd.setID(this.gensym("tech"));
                    MdWrap mdWrap = new MdWrap();
                    this.setMdType(mdWrap, metsName);
                    XmlData xmlData = new XmlData();
                    mdWrap.getContent().add(xmlData);
                    techMd.getContent().add(mdWrap);
                    fAmdSec.getContent().add(techMd);
                    mets.getContent().add(fAmdSec);
                    this.crosswalkToMets(xwalk, bitstreams[bits], (MetsElement)xmlData);
                    file.setADMID(techID);
                    file.getContent().add(flocat);
                    fileGrp.getContent().add(file);
                }
                fileSec.getContent().add(fileGrp);
            }
            mets.getContent().add(fileSec);
            StringBuffer dmdIds = new StringBuffer();
            for (int i = 0; i < dmdId.length; ++i) {
                dmdIds.append(" " + dmdId[i]);
            }
            StructMap structMap = new StructMap();
            structMap.setID(this.gensym("struct"));
            structMap.setTYPE("LOGICAL");
            structMap.setLABEL("DSpace");
            Div div0 = new Div();
            div0.setID(this.gensym("div"));
            div0.setTYPE("DSpace Item");
            div0.setDMDID(dmdIds.substring(1));
            if (licenseID != null) {
                div0.setADMID(licenseID);
            }
            if (primaryBitstreamFileID != null) {
                Fptr fptr = new Fptr();
                fptr.setFILEID(primaryBitstreamFileID);
                div0.getContent().add(fptr);
            }
            div0.getContent().addAll(contentDivs);
            structMap.getContent().add(div0);
            this.addStructMap(context, item, params, mets);
            mets.getContent().add(structMap);
            mets.validate(new MetsValidator());
            mets.write(new MetsWriter(out));
        }
        catch (MetsException e) {
            throw new PackageValidationException((Exception)((Object)e));
        }
    }

    protected static Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        Bundle[] bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().length() - 4);
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getName() == null || !bundles[i].getName().equals("ORIGINAL")) continue;
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int bsnum = 0; bsnum < bitstreams.length; ++bsnum) {
                if (!bitstreams[bsnum].getName().equals(originalFilename)) continue;
                return bitstreams[bsnum];
            }
        }
        return null;
    }

    private void crosswalkToMets(DisseminationCrosswalk xwalk, DSpaceObject dso, MetsElement me) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        String raw = xwalk.getSchemaLocation();
        String[] sloc = raw == null ? null : raw.split("\\s+");
        Namespace[] ns = xwalk.getNamespaces();
        for (int i = 0; i < ns.length; ++i) {
            String uri = ns[i].getURI();
            if (sloc != null && sloc.length > 1 && uri.equals(sloc[0])) {
                me.setSchema(ns[i].getPrefix(), uri, sloc[1]);
                continue;
            }
            me.setSchema(ns[i].getPrefix(), uri);
        }
        PreformedXML pXML = new PreformedXML(xwalk.preferList() ? outputter.outputString(xwalk.disseminateList(dso)) : outputter.outputString(xwalk.disseminateElement(dso)));
        me.getContent().add(pXML);
    }

    public abstract String getProfile();

    public abstract String bundleToFileGrp(String var1);

    public abstract String[] getDmdTypes(PackageParameters var1) throws SQLException, IOException, AuthorizeException;

    public abstract String getTechMdType(PackageParameters var1) throws SQLException, IOException, AuthorizeException;

    public abstract void addRightsMd(Context var1, Item var2, AmdSec var3) throws SQLException, IOException, AuthorizeException, MetsException;

    public abstract void addStructMap(Context var1, Item var2, PackageParameters var3, Mets var4) throws SQLException, IOException, AuthorizeException, MetsException;
}

