/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdRef;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.RightsMD;
import edu.harvard.hul.ois.mets.helper.Base64;
import edu.harvard.hul.ois.mets.helper.MetsException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.packager.AbstractMETSDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.license.CreativeCommons;

public class DSpaceMETSDisseminator
extends AbstractMETSDisseminator {
    private static Logger log = Logger.getLogger(DSpaceMETSDisseminator.class);
    private static final String PROFILE_LABEL = "DSpace METS SIP Profile 1.0";
    private static final String DSPACE_DEPOSIT_LICENSE_MDTYPE = "DSpace Deposit License";
    private static final String CREATIVE_COMMONS_LICENSE_MDTYPE = "Creative Commons";

    public String getProfile() {
        return PROFILE_LABEL;
    }

    public String bundleToFileGrp(String bname) {
        if (bname.equals("ORIGINAL")) {
            return "CONTENT";
        }
        return bname;
    }

    public String[] getDmdTypes(PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String[] result = null;
        if (params != null) {
            result = params.getProperties("dmd");
        }
        if (result == null || result.length == 0) {
            result = new String[]{"MODS"};
        }
        return result;
    }

    public String getTechMdType(PackageParameters params) throws SQLException, IOException, AuthorizeException {
        return "PREMIS";
    }

    public void addRightsMd(Context context, Item item, AmdSec amdSec) throws SQLException, IOException, AuthorizeException, MetsException {
        this.addDepositLicense(context, item, amdSec);
        this.addCreativeCommons(context, item, amdSec);
    }

    private boolean addDepositLicense(Context context, Item item, AmdSec amdSec) throws SQLException, IOException, AuthorizeException, MetsException {
        Bitstream licenseBs = DSpaceMETSDisseminator.findDepositLicense(context, item);
        if (licenseBs == null) {
            return false;
        }
        String resource = "depositlicense_" + String.valueOf(licenseBs.getSequenceID()) + ".txt";
        this.addRightsStream(licenseBs.retrieve(), resource, "text/plain", DSPACE_DEPOSIT_LICENSE_MDTYPE, amdSec);
        return true;
    }

    private boolean addCreativeCommons(Context context, Item item, AmdSec amdSec) throws SQLException, IOException, AuthorizeException, MetsException {
        Bitstream cc = CreativeCommons.getLicenseRdfBitstream(item);
        if (cc != null) {
            this.addRightsStream(cc.retrieve(), this.gensym("creativecommons") + ".rdf", "text/rdf", CREATIVE_COMMONS_LICENSE_MDTYPE, amdSec);
        } else {
            cc = CreativeCommons.getLicenseTextBitstream(item);
            if (cc != null) {
                this.addRightsStream(cc.retrieve(), this.gensym("creativecommons") + ".txt", "text/plain", CREATIVE_COMMONS_LICENSE_MDTYPE, amdSec);
            } else {
                return false;
            }
        }
        return true;
    }

    private void addRightsStream(InputStream is, String resourceName, String mimeType, String mdType, AmdSec amdSec) throws IOException, MetsException {
        RightsMD rightsMD = new RightsMD();
        rightsMD.setID(this.gensym("rights"));
        if (this.extraFiles == null) {
            MdWrap rightsMDWrap = new MdWrap();
            rightsMDWrap.setMIMETYPE(mimeType);
            rightsMDWrap.setMDTYPE(Mdtype.OTHER);
            rightsMDWrap.setOTHERMDTYPE(mdType);
            BinData bin = new BinData();
            bin.getContent().add(new Base64(is));
            rightsMDWrap.getContent().add(bin);
            rightsMD.getContent().add(rightsMDWrap);
        } else {
            this.extraFiles.put(resourceName, is);
            MdRef rightsMDRef = new MdRef();
            rightsMDRef.setMIMETYPE(mimeType);
            rightsMDRef.setMDTYPE(Mdtype.OTHER);
            rightsMDRef.setOTHERMDTYPE(mdType);
            rightsMDRef.setLOCTYPE(Loctype.URL);
            rightsMDRef.setXlinkHref(resourceName);
            rightsMD.getContent().add(rightsMDRef);
        }
        amdSec.getContent().add(rightsMD);
    }

    private static Bitstream findDepositLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        int licenseFormatId = -1;
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        if (bf != null) {
            licenseFormatId = bf.getID();
        }
        Bundle[] bundles = item.getBundles("LICENSE");
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            if (bitstreams[0].getFormat().getID() != licenseFormatId) continue;
            return bitstreams[0];
        }
        return null;
    }

    public void addStructMap(Context context, Item item, PackageParameters params, Mets mets) throws SQLException, IOException, AuthorizeException, MetsException {
    }
}

