/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEditChange {
    private Item item;
    private ArrayList<DCValue> adds;
    private ArrayList<DCValue> removes;
    private ArrayList<DCValue> constant;
    private ArrayList<DCValue> complete;
    private ArrayList<Collection> oldOwningCollections;
    private ArrayList<Collection> newOwningCollections;
    private boolean newItem;
    private boolean empty;

    public BulkEditChange() {
        this.item = null;
        this.newItem = true;
        this.empty = true;
        this.adds = new ArrayList();
        this.removes = new ArrayList();
        this.constant = new ArrayList();
        this.complete = new ArrayList();
        this.oldOwningCollections = new ArrayList();
        this.newOwningCollections = new ArrayList();
    }

    public BulkEditChange(Item i) {
        this.item = i;
        this.newItem = false;
        this.empty = true;
        this.adds = new ArrayList();
        this.removes = new ArrayList();
        this.constant = new ArrayList();
        this.complete = new ArrayList();
        this.oldOwningCollections = new ArrayList();
        this.newOwningCollections = new ArrayList();
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public void registerAdd(DCValue dcv) {
        this.adds.add(dcv);
        this.complete.add(dcv);
        this.empty = false;
    }

    public void registerRemove(DCValue dcv) {
        this.removes.add(dcv);
        this.empty = false;
    }

    public void registerConstant(DCValue dcv) {
        this.constant.add(dcv);
        this.complete.add(dcv);
    }

    public void registerNewOwningCollection(Collection c) {
        this.newOwningCollections.add(c);
        this.empty = false;
    }

    public void registerOldOwningCollection(Collection c) {
        this.oldOwningCollections.add(c);
        this.empty = false;
    }

    public Item getItem() {
        return this.item;
    }

    public ArrayList<DCValue> getAdds() {
        return this.adds;
    }

    public ArrayList<DCValue> getRemoves() {
        return this.removes;
    }

    public ArrayList<DCValue> getConstant() {
        return this.constant;
    }

    public ArrayList<DCValue> getComplete() {
        return this.complete;
    }

    public ArrayList<Collection> getNewOwningCollections() {
        return this.newOwningCollections;
    }

    public ArrayList<Collection> getOldOwningCollections() {
        return this.oldOwningCollections;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public boolean hasChanges() {
        return !this.empty;
    }
}

