/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.itemupdate.ContentsEntry;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.itemupdate.UpdateBitstreamsAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class AddBitstreamsAction
extends UpdateBitstreamsAction {
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws IllegalArgumentException, ParseException, IOException, AuthorizeException, SQLException {
        Item item = itarch.getItem();
        File dir = itarch.getDirectory();
        List<ContentsEntry> contents = MetadataUtilities.readContentsFile(new File(dir, "contents"));
        if (contents.isEmpty()) {
            ItemUpdate.pr("Contents is empty - no bitstreams to add");
            return;
        }
        ItemUpdate.pr("Contents bitstream count: " + contents.size());
        String[] files = dir.list(ItemUpdate.fileFilter);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String filename : files) {
            fileList.add(filename);
            ItemUpdate.pr("file: " + filename);
        }
        for (ContentsEntry ce : contents) {
            if (fileList.contains(ce.filename)) continue;
            throw new IllegalArgumentException("File listed in contents is missing: " + ce.filename);
        }
        for (ContentsEntry ce : contents) {
            this.addBitstream(context, itarch, item, dir, ce, suppressUndo, isTest);
        }
    }

    private void addBitstream(Context context, ItemArchive itarch, Item item, File dir, ContentsEntry ce, boolean suppressUndo, boolean isTest) throws IOException, IllegalArgumentException, SQLException, AuthorizeException, ParseException {
        ItemUpdate.pr("contents entry for bitstream: " + ce.toString());
        File f = new File(dir, ce.filename);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        Bitstream bs = null;
        String newBundleName = ce.bundlename;
        if (ce.bundlename == null) {
            newBundleName = ce.filename.equals("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        ItemUpdate.pr("  Bitstream " + ce.filename + " to be added to bundle: " + newBundleName);
        if (!isTest) {
            Group group;
            Bundle[] bundles = item.getBundles(newBundleName);
            Bundle targetBundle = null;
            if (bundles.length < 1) {
                targetBundle = item.createBundle(newBundleName);
            } else {
                for (Bundle b : bundles) {
                    Bitstream[] bitstreams;
                    for (Bitstream bsm : bitstreams = b.getBitstreams()) {
                        if (!bsm.getName().equals(ce.filename)) continue;
                        throw new IllegalArgumentException("Duplicate bundle + filename cannot be added: " + b.getName() + " + " + bsm.getName());
                    }
                }
                targetBundle = bundles[0];
            }
            bs = targetBundle.createBitstream(bis);
            bs.setName(ce.filename);
            BitstreamFormat fmt = FormatIdentifier.guessFormat(context, bs);
            bs.setFormat(fmt);
            if (ce.description != null) {
                bs.setDescription(ce.description);
            }
            if (ce.permissionsActionId != -1 && ce.permissionsGroupName != null && (group = Group.findByName(context, ce.permissionsGroupName)) != null) {
                AuthorizeManager.removeAllPolicies(context, bs);
                ResourcePolicy rp = ResourcePolicy.create(context);
                rp.setResource(bs);
                rp.setAction(ce.permissionsActionId);
                rp.setGroup(group);
                rp.update();
            }
            if (this.alterProvenance && !targetBundle.getName().equals("THUMBMNAIL") && !targetBundle.getName().equals("TEXT")) {
                DtoMetadata dtom = DtoMetadata.create("dc.description.provenance", "en", "");
                String append = "Bitstream added on " + DCDate.getCurrent() + " : " + InstallItem.getBitstreamProvenanceMessage(item);
                MetadataUtilities.appendMetadata(item, dtom, false, append);
            }
            bs.update();
            if (!suppressUndo) {
                itarch.addUndoDeleteContents(bs.getID());
            }
        }
    }
}

