/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.dspace.app.itemupdate.ContentsEntry;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataUtilities {
    public static boolean deleteMetadataByValue(Item item, DtoMetadata dtom, boolean isLanguageStrict) {
        DCValue[] ar = null;
        ar = isLanguageStrict ? item.getMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language) : item.getMetadata(dtom.schema, dtom.element, dtom.qualifier, "*");
        boolean found = false;
        ArrayList<String> vals = new ArrayList<String>();
        for (DCValue dcv : ar) {
            if (dcv.value.equals(dtom.value)) {
                found = true;
                continue;
            }
            vals.add(dcv.value);
        }
        if (found) {
            if (isLanguageStrict) {
                item.clearMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language);
            } else {
                item.clearMetadata(dtom.schema, dtom.element, dtom.qualifier, "*");
            }
            item.addMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language, vals.toArray(new String[0]));
        }
        return found;
    }

    public static void appendMetadata(Item item, DtoMetadata dtom, boolean isLanguageStrict, String textToAppend) throws IllegalArgumentException {
        DCValue[] ar = null;
        ar = isLanguageStrict ? item.getMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language) : item.getMetadata(dtom.schema, dtom.element, dtom.qualifier, "*");
        if (ar.length == 0) {
            throw new IllegalArgumentException("Metadata to append to not found");
        }
        int idx = 0;
        if (ar.length > 1) {
            // empty if block
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (int i = 0; i < ar.length; ++i) {
            if (i == idx) {
                vals.add(ar[i].value + textToAppend);
                continue;
            }
            vals.add(ar[i].value);
        }
        if (isLanguageStrict) {
            item.clearMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language);
        } else {
            item.clearMetadata(dtom.schema, dtom.element, dtom.qualifier, "*");
        }
        item.addMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language, vals.toArray(new String[0]));
    }

    public static List<DtoMetadata> loadDublinCore(DocumentBuilder docBuilder, InputStream is) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = docBuilder.parse(is);
        ArrayList<DtoMetadata> dtomList = new ArrayList<DtoMetadata>();
        String schema = null;
        NodeList metadata = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core");
        Node schemaAttr = metadata.item(0).getAttributes().getNamedItem("schema");
        schema = schemaAttr == null ? "dc" : schemaAttr.getNodeValue();
        NodeList dcNodes = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core/dcvalue");
        for (int i = 0; i < dcNodes.getLength(); ++i) {
            String language;
            String qualifier;
            String element;
            Node n = dcNodes.item(i);
            String value = MetadataUtilities.getStringValue(n).trim();
            if (value == null) {
                value = "";
            }
            if ((element = MetadataUtilities.getAttributeValue(n, "element")) != null) {
                element = element.trim();
            }
            if ((qualifier = MetadataUtilities.getAttributeValue(n, "qualifier")) != null) {
                qualifier = qualifier.trim();
            }
            if ((language = MetadataUtilities.getAttributeValue(n, "language")) != null) {
                language = language.trim();
            }
            if (qualifier.equals("none") || "".equals(qualifier)) {
                qualifier = null;
            }
            if (language == null) {
                language = "en";
            } else if (language.equals("")) {
                language = ConfigurationManager.getProperty("default.language");
            }
            DtoMetadata dtom = DtoMetadata.create(schema, element, qualifier, language, value);
            ItemUpdate.pr(dtom.toString());
            dtomList.add(dtom);
        }
        return dtomList;
    }

    public static Document writeDublinCore(DocumentBuilder docBuilder, List<DtoMetadata> dtomList) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("dublin_core");
        doc.appendChild(root);
        for (DtoMetadata dtom : dtomList) {
            Element mel = doc.createElement("dcvalue");
            mel.setAttribute("element", dtom.element);
            if (dtom.qualifier == null) {
                mel.setAttribute("qualifier", "none");
            } else {
                mel.setAttribute("qualifier", dtom.qualifier);
            }
            if (dtom.language == null || dtom.language.equals("")) {
                mel.setAttribute("language", "en");
            } else {
                mel.setAttribute("language", dtom.language);
            }
            mel.setTextContent(dtom.value);
            root.appendChild(mel);
        }
        return doc;
    }

    public static void writeDocument(Document doc, Transformer transformer, OutputStream out) throws IOException, TransformerException {
        DOMSource src = new DOMSource(doc);
        StreamResult dest = new StreamResult(out);
        transformer.transform(src, dest);
    }

    private static String getAttributeValue(Node n, String name) {
        NamedNodeMap nm = n.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Node node = nm.item(i);
            if (!name.equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        return "";
    }

    private static String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContentsEntry> readContentsFile(File f) throws FileNotFoundException, IOException, ParseException {
        ArrayList<ContentsEntry> list = new ArrayList<ContentsEntry>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                ItemUpdate.pr("Contents entry: " + line);
                list.add(ContentsEntry.parse(line));
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> readDeleteContentsFile(File f) throws FileNotFoundException, IOException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                int n = 0;
                try {
                    n = Integer.parseInt(line);
                    list.add(n);
                }
                catch (NumberFormatException e) {
                    ItemUpdate.pr("Error reading delete contents line:" + e.toString());
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public static String getDCValueString(DCValue dcv) {
        return "schema: " + dcv.schema + "; element: " + dcv.element + "; qualifier: " + dcv.qualifier + "; language: " + dcv.language + "; value: " + dcv.value;
    }

    public static String getCompoundForm(String schema, String element, String qualifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(schema).append(".").append(element);
        if (qualifier != null) {
            sb.append(".").append(qualifier);
        }
        return sb.toString();
    }

    public static String[] parseCompoundForm(String compoundForm) throws ParseException {
        String[] ar = compoundForm.split("\\s*\\.\\s*");
        if (ar[0].equals("")) {
            throw new ParseException("schema is empty string: " + compoundForm, 0);
        }
        if (ar.length < 2 || ar.length > 3 || ar[1].equals("")) {
            throw new ParseException("element is malformed or empty string: " + compoundForm, 0);
        }
        return ar;
    }
}

