/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.dspace.core.ConfigurationManager;

public class JPEGFilter
extends MediaFilter {
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    public String getBundleName() {
        return "THUMBNAIL";
    }

    public String getFormatString() {
        return "JPEG";
    }

    public String getDescription() {
        return "Generated Thumbnail";
    }

    public InputStream getDestinationStream(InputStream source) throws Exception {
        float scale_factor;
        BufferedImage buf = ImageIO.read(source);
        float xmax = ConfigurationManager.getIntProperty("thumbnail.maxwidth");
        float ymax = ConfigurationManager.getIntProperty("thumbnail.maxheight");
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (MediaFilterManager.isVerbose) {
            System.out.println("original size: " + xsize + "," + ysize);
        }
        if (xsize > xmax) {
            scale_factor = xmax / xsize;
            if (MediaFilterManager.isVerbose) {
                System.out.println("x scale factor: " + scale_factor);
            }
            xsize *= scale_factor;
            ysize *= scale_factor;
            if (MediaFilterManager.isVerbose) {
                System.out.println("new size: " + xsize + "," + ysize);
            }
        }
        if (ysize > ymax) {
            scale_factor = ymax / ysize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        if (MediaFilterManager.isVerbose) {
            System.out.println("created thumbnail size: " + xsize + ", " + ysize);
        }
        BufferedImage thumbnail = new BufferedImage((int)xsize, (int)ysize, 1);
        Graphics2D g2d = thumbnail.createGraphics();
        g2d.drawImage(buf, 0, 0, (int)xsize, (int)ysize, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)thumbnail, "jpeg", baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }
}

