/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.util.Date;

public class LogLine {
    private Date date = null;
    private String level = null;
    private String user = null;
    private String action = null;
    private String params = null;

    LogLine(Date date, String level, String user, String action, String params) {
        this.date = date;
        this.level = level;
        this.user = user;
        this.action = action;
        this.params = params;
    }

    public Date getDate() {
        return this.date;
    }

    public String getLevel() {
        return this.level;
    }

    public String getUser() {
        return this.user;
    }

    public String getAction() {
        return this.action;
    }

    public String getParams() {
        return this.params;
    }

    public boolean beforeDate(Date date) {
        if (date != null) {
            return date.compareTo(this.getDate()) >= 0;
        }
        return false;
    }

    public boolean afterDate(Date date) {
        if (date != null) {
            return date.compareTo(this.getDate()) <= 0;
        }
        return false;
    }

    public boolean isLevel(String level) {
        return this.getLevel().equals(level);
    }

    public boolean isAction(String action) {
        return this.getAction().equals(action);
    }
}

