/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.core.ConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsLoader {
    private static Map<String, StatsFile> monthlyAnalysis = null;
    private static Map<String, StatsFile> monthlyReports = null;
    private static StatsFile generalAnalysis = null;
    private static StatsFile generalReport = null;
    private static Date lastLoaded = null;
    private static int fileCount = 0;
    private static Pattern analysisMonthlyPattern = Pattern.compile("dspace-log-monthly-([0-9][0-9][0-9][0-9]-[0-9]+)\\.dat");
    private static Pattern analysisGeneralPattern = Pattern.compile("dspace-log-general-([0-9]+-[0-9]+-[0-9]+)\\.dat");
    private static Pattern reportMonthlyPattern = Pattern.compile("report-([0-9][0-9][0-9][0-9]-[0-9]+)\\.html");
    private static Pattern reportGeneralPattern = Pattern.compile("report-general-([0-9]+-[0-9]+-[0-9]+)\\.html");
    private static SimpleDateFormat monthlySDF = new SimpleDateFormat("yyyy'-'M");
    private static SimpleDateFormat generalSDF = new SimpleDateFormat("yyyy'-'M'-'dd");

    public static Date[] getMonthlyReportDates() {
        return StatisticsLoader.sortDatesDescending(StatisticsLoader.getDatesFromMap(monthlyReports));
    }

    public static Date[] getMonthlyAnalysisDates() {
        return StatisticsLoader.sortDatesDescending(StatisticsLoader.getDatesFromMap(monthlyAnalysis));
    }

    protected static Date[] getDatesFromMap(Map<String, StatsFile> monthlyMap) {
        Set<String> keys = monthlyMap.keySet();
        Date[] dates = new Date[keys.size()];
        int i = 0;
        for (String date : keys) {
            try {
                dates[i] = monthlySDF.parse(date);
            }
            catch (ParseException pe) {
                // empty catch block
            }
            ++i;
        }
        return dates;
    }

    protected static Date[] sortDatesDescending(Date[] dates) {
        Arrays.sort(dates, new Comparator<Date>(){
            SimpleDateFormat sdf = StatisticsLoader.access$000();

            @Override
            public int compare(Date d1, Date d2) {
                if (d1 == null && d2 == null) {
                    return 0;
                }
                if (d1 == null) {
                    return -1;
                }
                if (d2 == null) {
                    return 1;
                }
                if (d1.before(d2)) {
                    return 1;
                }
                if (d2.before(d1)) {
                    return -1;
                }
                return 0;
            }
        });
        return dates;
    }

    public static File getAnalysisFor(String date) {
        StatisticsLoader.syncFileList();
        StatsFile sf = monthlyAnalysis == null ? null : monthlyAnalysis.get(date);
        return sf == null ? null : sf.file;
    }

    public static File getReportFor(String date) {
        StatisticsLoader.syncFileList();
        StatsFile sf = monthlyReports == null ? null : monthlyReports.get(date);
        return sf == null ? null : sf.file;
    }

    public static File getGeneralAnalysis() {
        StatisticsLoader.syncFileList();
        return generalAnalysis == null ? null : StatisticsLoader.generalAnalysis.file;
    }

    public static File getGeneralReport() {
        StatisticsLoader.syncFileList();
        return generalReport == null ? null : StatisticsLoader.generalReport.file;
    }

    private static void syncFileList() {
        File[] fileList = StatisticsLoader.getAnalysisAndReportFileList();
        if (fileList != null && fileList.length != fileCount) {
            StatisticsLoader.loadFileList(fileList);
        } else if (lastLoaded == null) {
            StatisticsLoader.loadFileList(fileList);
        } else if (DateUtils.addHours((Date)lastLoaded, (int)1).before(new Date())) {
            StatisticsLoader.loadFileList(fileList);
        }
    }

    private static synchronized void loadFileList(File[] fileList) {
        if (fileList == null || fileList.length == 0) {
            fileList = StatisticsLoader.getAnalysisAndReportFileList();
        }
        HashMap<String, StatsFile> newMonthlyAnalysis = new HashMap<String, StatsFile>();
        HashMap<String, StatsFile> newMonthlyReports = new HashMap<String, StatsFile>();
        StatsFile newGeneralAnalysis = null;
        StatsFile newGeneralReport = null;
        if (fileList != null) {
            for (File thisFile : fileList) {
                StatsFile statsFile = null;
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, analysisMonthlyPattern, monthlySDF)) != null) {
                    newMonthlyAnalysis.put(statsFile.dateStr, statsFile);
                }
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, reportMonthlyPattern, monthlySDF)) != null) {
                    newMonthlyReports.put(statsFile.dateStr, statsFile);
                }
                if (statsFile == null && (statsFile = StatisticsLoader.makeStatsFile(thisFile, analysisGeneralPattern, generalSDF)) != null && (newGeneralAnalysis == null || statsFile.date.after(newGeneralAnalysis.date))) {
                    newGeneralAnalysis = statsFile;
                }
                if (statsFile != null || (statsFile = StatisticsLoader.makeStatsFile(thisFile, reportGeneralPattern, generalSDF)) == null || newGeneralReport != null && !statsFile.date.after(newGeneralReport.date)) continue;
                newGeneralReport = statsFile;
            }
        }
        monthlyAnalysis = newMonthlyAnalysis;
        monthlyReports = newMonthlyReports;
        generalAnalysis = newGeneralAnalysis;
        generalReport = newGeneralReport;
        lastLoaded = new Date();
    }

    private static StatsFile makeStatsFile(File thisFile, Pattern thisPattern, SimpleDateFormat sdf) {
        Matcher matcher = thisPattern.matcher(thisFile.getName());
        if (matcher.matches()) {
            StatsFile sf = new StatsFile();
            sf.file = thisFile;
            sf.path = thisFile.getPath();
            sf.dateStr = matcher.group(1).trim();
            try {
                sf.date = sdf.parse(sf.dateStr);
            }
            catch (ParseException e) {
                // empty catch block
            }
            return sf;
        }
        return null;
    }

    private static File[] getAnalysisAndReportFileList() {
        File reportDir = new File(ConfigurationManager.getProperty("log.dir"));
        if (reportDir != null) {
            return reportDir.listFiles(new AnalysisAndReportFilter());
        }
        return null;
    }

    static /* synthetic */ SimpleDateFormat access$000() {
        return monthlySDF;
    }

    private static class AnalysisAndReportFilter
    implements FilenameFilter {
        private AnalysisAndReportFilter() {
        }

        public boolean accept(File dir, String name) {
            if (analysisMonthlyPattern.matcher(name).matches()) {
                return true;
            }
            if (analysisGeneralPattern.matcher(name).matches()) {
                return true;
            }
            if (reportMonthlyPattern.matcher(name).matches()) {
                return true;
            }
            return reportGeneralPattern.matcher(name).matches();
        }
    }

    private static class StatsFile {
        File file;
        String path;
        Date date;
        String dateStr;

        private StatsFile() {
        }
    }
}

