/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class MetadataExposure {
    private static Logger log = Logger.getLogger(MetadataExposure.class);
    private static Map<String, Set<String>> hiddenElementSets = null;
    private static Map<String, Map<String, Set<String>>> hiddenElementMaps = null;
    private static final String CONFIG_PREFIX = "metadata.hide.";

    public static boolean isHidden(Context context, String schema, String element, String qualifier) throws SQLException {
        if (context != null && AuthorizeManager.isAdmin(context)) {
            return false;
        }
        MetadataExposure.init();
        if (qualifier == null) {
            Set<String> elts = hiddenElementSets.get(schema);
            return elts == null ? false : elts.contains(element);
        }
        Map<String, Set<String>> elts = hiddenElementMaps.get(schema);
        if (elts == null) {
            return false;
        }
        Set<String> quals = elts.get(element);
        return quals == null ? false : quals.contains(qualifier);
    }

    private static void init() {
        if (hiddenElementSets == null) {
            hiddenElementSets = new HashMap<String, Set<String>>();
            hiddenElementMaps = new HashMap<String, Map<String, Set<String>>>();
            Enumeration pne = ConfigurationManager.propertyNames();
            while (pne.hasMoreElements()) {
                String key = (String)pne.nextElement();
                if (!key.startsWith(CONFIG_PREFIX)) continue;
                String mdField = key.substring(CONFIG_PREFIX.length());
                String[] segment = mdField.split("\\.", 3);
                if (segment.length == 3) {
                    Map<String, Set<String>> eltMap = hiddenElementMaps.get(segment[0]);
                    if (eltMap == null) {
                        eltMap = new HashMap<String, Set<String>>();
                        hiddenElementMaps.put(segment[0], eltMap);
                    }
                    if (!eltMap.containsKey(segment[1])) {
                        eltMap.put(segment[1], new HashSet());
                    }
                    eltMap.get(segment[1]).add(segment[2]);
                    continue;
                }
                if (segment.length == 2) {
                    if (!hiddenElementSets.containsKey(segment[0])) {
                        hiddenElementSets.put(segment[0], new HashSet());
                    }
                    hiddenElementSets.get(segment[0]).add(segment[1]);
                    continue;
                }
                log.warn((Object)("Bad format in hidden metadata directive, field=\"" + mdField + "\", config property=" + key));
            }
        }
    }
}

