/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.opensearch.OpenSearchModule;
import com.sun.syndication.feed.module.opensearch.entity.OSQuery;
import com.sun.syndication.feed.module.opensearch.impl.OpenSearchModuleImpl;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.search.QueryResults;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSearch {
    private static final Logger log;
    private static boolean enabled;
    private static List<String> formats;
    private static final String osNs = "http://a9.com/-/spec/opensearch/1.1/";
    private static String uiUrl;
    private static String svcUrl;

    public static List<String> getFormats() {
        return formats;
    }

    public static String getContentType(String format) {
        return "html".equals(format) ? "text/html" : "application/" + format + "+xml; charset=UTF-8";
    }

    public static org.w3c.dom.Document getDescriptionDoc(String scope) throws IOException {
        return OpenSearch.jDomToW3(OpenSearch.getServiceDocument(scope));
    }

    public static String getDescription(String scope) {
        return new XMLOutputter().outputString(OpenSearch.getServiceDocument(scope));
    }

    public static String getResultsString(String format, String query, QueryResults qResults, DSpaceObject scope, DSpaceObject[] results, Map<String, String> labels) throws IOException {
        try {
            return OpenSearch.getResults(format, query, qResults, scope, results, labels).outputString();
        }
        catch (FeedException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new IOException("Unable to generate feed");
        }
    }

    public static org.w3c.dom.Document getResultsDoc(String format, String query, QueryResults qResults, DSpaceObject scope, DSpaceObject[] results, Map<String, String> labels) throws IOException {
        try {
            return OpenSearch.getResults(format, query, qResults, scope, results, labels).outputW3CDom();
        }
        catch (FeedException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new IOException("Unable to generate feed");
        }
    }

    private static SyndicationFeed getResults(String format, String query, QueryResults qResults, DSpaceObject scope, DSpaceObject[] results, Map<String, String> labels) {
        if ("rss".equals(format)) {
            format = "rss_2.0";
        } else if ("atom".equals(format)) {
            format = "atom_1.0";
        }
        SyndicationFeed feed = new SyndicationFeed(labels.get("ui.type"));
        feed.populate(null, scope, results, labels);
        feed.setType(format);
        feed.addModule((Module)OpenSearch.openSearchMarkup(query, qResults));
        return feed;
    }

    private static OpenSearchModule openSearchMarkup(String query, QueryResults qRes) {
        OpenSearchModuleImpl osMod = new OpenSearchModuleImpl();
        osMod.setTotalResults(qRes.getHitCount());
        osMod.setStartIndex(qRes.getStart());
        osMod.setItemsPerPage(qRes.getPageSize());
        OSQuery osq = new OSQuery();
        osq.setRole("request");
        try {
            osq.setSearchTerms(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        osq.setStartPage(1 + qRes.getStart() / qRes.getPageSize());
        osMod.addQuery(osq);
        return osMod;
    }

    private static Document getServiceDocument(String scope) {
        String faviconUrl;
        String contact;
        String tags;
        Namespace ns = Namespace.getNamespace((String)osNs);
        Element root = new Element("OpenSearchDescription", ns);
        root.addContent((Content)new Element("ShortName", ns).setText(ConfigurationManager.getProperty("websvc.opensearch.shortname")));
        root.addContent((Content)new Element("LongName", ns).setText(ConfigurationManager.getProperty("websvc.opensearch.longname")));
        root.addContent((Content)new Element("Description", ns).setText(ConfigurationManager.getProperty("websvc.opensearch.description")));
        root.addContent((Content)new Element("InputEncoding", ns).setText("UTF-8"));
        root.addContent((Content)new Element("OutputEncoding", ns).setText("UTF-8"));
        String sample = ConfigurationManager.getProperty("websvc.opensearch.samplequery");
        if (sample != null && sample.length() > 0) {
            Element sq = new Element("Query", ns).setAttribute("role", "example");
            root.addContent((Content)sq.setAttribute("searchTerms", sample));
        }
        if ((tags = ConfigurationManager.getProperty("websvc.opensearch.tags")) != null && tags.length() > 0) {
            root.addContent((Content)new Element("Tags", ns).setText(tags));
        }
        if ((contact = ConfigurationManager.getProperty("mail.admin")) != null && contact.length() > 0) {
            root.addContent((Content)new Element("Contact", ns).setText(contact));
        }
        if ((faviconUrl = ConfigurationManager.getProperty("websvc.opensearch.faviconurl")) != null && faviconUrl.length() > 0) {
            String dim = String.valueOf(16);
            String type = faviconUrl.endsWith("ico") ? "image/vnd.microsoft.icon" : "image/png";
            Element fav = new Element("Image", ns).setAttribute("height", dim).setAttribute("width", dim).setAttribute("type", type).setText(faviconUrl);
            root.addContent((Content)fav);
        }
        for (String format : formats) {
            Element url = new Element("Url", ns).setAttribute("type", OpenSearch.getContentType(format));
            StringBuffer template = new StringBuffer();
            if ("html".equals(format)) {
                template.append(uiUrl);
            } else {
                template.append(svcUrl);
            }
            template.append("?query={searchTerms}");
            if (!"html".equals(format)) {
                template.append("&start={startIndex?}&rpp={count?}&format=");
                template.append(format);
            }
            if (scope != null) {
                template.append("&scope=");
                template.append(scope);
            }
            url.setAttribute("template", template.toString());
            root.addContent((Content)url);
        }
        return new Document(root);
    }

    private static org.w3c.dom.Document jDomToW3(Document jdomDoc) throws IOException {
        DOMOutputter domOut = new DOMOutputter();
        try {
            return domOut.output(jdomDoc);
        }
        catch (JDOMException jde) {
            throw new IOException("JDOM output exception");
        }
    }

    static {
        String fmtsStr;
        log = Logger.getLogger(OpenSearch.class);
        enabled = false;
        formats = null;
        uiUrl = null;
        svcUrl = null;
        enabled = ConfigurationManager.getBooleanProperty("websvc.opensearch.enable");
        svcUrl = ConfigurationManager.getProperty("dspace.url") + "/" + ConfigurationManager.getProperty("websvc.opensearch.svccontext");
        uiUrl = ConfigurationManager.getProperty("dspace.url") + "/" + ConfigurationManager.getProperty("websvc.opensearch.uicontext");
        formats = new ArrayList<String>();
        if (enabled && (fmtsStr = ConfigurationManager.getProperty("websvc.opensearch.formats")) != null) {
            for (String fmt : fmtsStr.split(",")) {
                formats.add(fmt);
            }
        }
    }
}

