/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class ShibAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(ShibAuthentication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        EPerson p;
        log.info((Object)"Shibboleth login started...");
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            log.debug((Object)("header:" + name + "=" + request.getHeader(name)));
        }
        boolean isUsingTomcatUser = ConfigurationManager.getBooleanProperty("authentication.shib.email-use-tomcat-remote-user");
        String emailHeader = ConfigurationManager.getProperty("authentication.shib.email-header");
        String fnameHeader = ConfigurationManager.getProperty("authentication.shib.firstname-header");
        String lnameHeader = ConfigurationManager.getProperty("authentication.shib.lastname-header");
        String email = null;
        String fname = null;
        String lname = null;
        if (emailHeader != null && (email = request.getHeader(emailHeader)) == null) {
            email = request.getHeader(emailHeader.toLowerCase());
        }
        if (email == null && isUsingTomcatUser) {
            email = request.getRemoteUser();
            log.info((Object)("RemoteUser identified as: " + email));
        }
        if (email == null && (p = context.getCurrentUser()) != null) {
            email = p.getEmail();
        }
        if (email == null) {
            log.error((Object)"No email is given, you're denied access by Shib, please release email address");
            return 5;
        }
        email = email.toLowerCase();
        if (fnameHeader != null && (fname = request.getHeader(fnameHeader)) == null) {
            fname = request.getHeader(fnameHeader.toLowerCase());
        }
        if (lnameHeader != null && (lname = request.getHeader(lnameHeader)) == null) {
            lname = request.getHeader(lnameHeader.toLowerCase());
        }
        EPerson eperson = null;
        try {
            eperson = EPerson.findByEmail(context, email);
            context.setCurrentUser(eperson);
        }
        catch (AuthorizeException e) {
            log.warn((Object)("Fail to locate user with email:" + email), (Throwable)e);
            eperson = null;
        }
        if (eperson == null && ConfigurationManager.getBooleanProperty("authentication.shib.autoregister")) {
            log.info((Object)LogManager.getHeader(context, "autoregister", "email=" + email));
            context.setIgnoreAuthorization(true);
            try {
                eperson = EPerson.create(context);
                eperson.setEmail(email);
                if (fname != null) {
                    eperson.setFirstName(fname);
                }
                if (lname != null) {
                    eperson.setLastName(lname);
                }
                eperson.setCanLogIn(true);
                AuthenticationManager.initEPerson(context, request, eperson);
                eperson.update();
                context.commit();
                context.setCurrentUser(eperson);
            }
            catch (AuthorizeException e) {
                log.warn((Object)("Fail to authorize user with email:" + email), (Throwable)e);
                eperson = null;
            }
            finally {
                context.setIgnoreAuthorization(false);
            }
        }
        if (eperson == null) {
            return 4;
        }
        context.setCurrentUser(eperson);
        request.getSession().setAttribute("shib.authenticated", (Object)new Boolean("true"));
        return 1;
    }

    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        String affiliations;
        if (context.getCurrentUser() == null || request.getSession().getAttribute("shib.authenticated") == null) {
            return new int[0];
        }
        if (request.getSession().getAttribute("shib.specialgroup") != null) {
            return (int[])request.getSession().getAttribute("shib.specialgroup");
        }
        HashSet groups = new HashSet();
        String roleHeader = ConfigurationManager.getProperty("authentication.shib.role-header");
        boolean roleHeader_ignoreScope = ConfigurationManager.getBooleanProperty("authentication.shib.role-header.ignore-scope");
        if (roleHeader == null || roleHeader.trim().length() == 0) {
            roleHeader = "Shib-EP-UnscopedAffiliation";
        }
        if ((affiliations = request.getHeader(roleHeader)) == null) {
            affiliations = request.getHeader(roleHeader.toLowerCase());
        }
        String defaultRoles = ConfigurationManager.getProperty("authentication.shib.default-roles");
        if (affiliations == null && defaultRoles != null) {
            affiliations = defaultRoles;
        }
        if (affiliations != null) {
            StringTokenizer st = new StringTokenizer(affiliations, ";,");
            while (st.hasMoreTokens()) {
                String groupLabels;
                int index;
                String affiliation = st.nextToken().trim();
                if (roleHeader_ignoreScope && (index = affiliation.indexOf("@")) != -1) {
                    affiliation = affiliation.substring(0, index);
                }
                if ((groupLabels = ConfigurationManager.getProperty("authentication.shib.role." + affiliation)) == null || groupLabels.trim().length() == 0) {
                    groupLabels = ConfigurationManager.getProperty("authentication.shib.role." + affiliation.toLowerCase());
                }
                if (groupLabels == null) {
                    groupLabels = affiliation;
                }
                String[] labels = groupLabels.split(",");
                for (int i = 0; i < labels.length; ++i) {
                    this.addGroup(groups, context, labels[i].trim());
                }
            }
        }
        int[] ids = new int[groups.size()];
        Iterator it = groups.iterator();
        int i = 0;
        while (it.hasNext()) {
            ids[i] = (Integer)it.next();
            ++i;
        }
        if (ids.length != 0) {
            request.getSession().setAttribute("shib.specialgroup", (Object)ids);
        }
        return ids;
    }

    private void addGroup(Collection groups, Context context, String dspaceGroup) {
        try {
            Group g = Group.findByName(context, dspaceGroup);
            if (g == null) {
                log.warn((Object)LogManager.getHeader(context, dspaceGroup + " group is not found!! Admin needs to create one!", "requiredGroup=" + dspaceGroup));
                groups.add(new Integer(0));
            } else {
                groups.add(new Integer(g.getID()));
            }
            log.info((Object)("Mapping group: " + dspaceGroup + " to groupID: " + (g == null ? 0 : g.getID())));
        }
        catch (SQLException e) {
            log.error((Object)("Mapping group:" + dspaceGroup + " failed with error"), (Throwable)e);
        }
    }

    public boolean allowSetPassword(Context context, HttpServletRequest request, String email) throws SQLException {
        return false;
    }

    public boolean isImplicit() {
        return true;
    }

    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return true;
    }

    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/shibboleth-login");
    }

    public String loginPageTitle(Context context) {
        return "org.dspace.authenticate.ShibAuthentication.title";
    }
}

