/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseCreateDAOOracle;
import org.dspace.browse.BrowseCreateDAOPostgres;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseDAOOracle;
import org.dspace.browse.BrowseDAOPostgres;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseDAOUtilsOracle;
import org.dspace.browse.BrowseDAOUtilsPostgres;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.browse.BrowseItemDAOOracle;
import org.dspace.browse.BrowseItemDAOPostgres;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class BrowseDAOFactory {
    public static BrowseDAO getInstance(Context context) throws BrowseException {
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            return new BrowseDAOPostgres(context);
        }
        if ("oracle".equals(db)) {
            return new BrowseDAOOracle(context);
        }
        throw new BrowseException("The configuration for db.name is either invalid, or contains an unrecognised database");
    }

    public static BrowseCreateDAO getCreateInstance(Context context) throws BrowseException {
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            return new BrowseCreateDAOPostgres(context);
        }
        if ("oracle".equals(db)) {
            return new BrowseCreateDAOOracle(context);
        }
        throw new BrowseException("The configuration for db.name is either invalid, or contains an unrecognised database");
    }

    public static BrowseItemDAO getItemInstance(Context context) throws BrowseException {
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            return new BrowseItemDAOPostgres(context);
        }
        if ("oracle".equals(db)) {
            return new BrowseItemDAOOracle(context);
        }
        throw new BrowseException("The configuration for db.name is either invalid, or contains an unrecognised database");
    }

    public static BrowseDAOUtils getUtils(Context context) throws BrowseException {
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            return new BrowseDAOUtilsPostgres();
        }
        if ("oracle".equals(db)) {
            return new BrowseDAOUtilsOracle();
        }
        throw new BrowseException("The configuration for db.name is either invalid, or contains an unrecognised database");
    }
}

