/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.SelfNamedPlugin;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class MODSDisseminationCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(MODSDisseminationCrosswalk.class);
    private static final String CONFIG_PREFIX = "crosswalk.mods.properties.";
    private static String[] aliases = null;
    public static final Namespace MODS_NS;
    private static final Namespace XLINK_NS;
    private static final Namespace[] namespaces;
    public static final String MODS_XSD = "http://www.loc.gov/standards/mods/v3/mods-3-1.xsd";
    private static final String schemaLocation;
    private static XMLOutputter outputUgly;
    private static XMLOutputter outputPretty;
    private static SAXBuilder builder;
    private HashMap modsMap = null;

    public static String[] getPluginNames() {
        return aliases;
    }

    private void initMap() throws CrosswalkInternalException {
        if (this.modsMap != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            log.error((Object)"Must use PluginManager to instantiate MODSDisseminationCrosswalk so the class knows its name.");
            return;
        }
        String cmPropName = CONFIG_PREFIX + myAlias;
        String propsFilename = ConfigurationManager.getProperty(cmPropName);
        if (propsFilename == null) {
            String msg = "MODS crosswalk missing configuration file for crosswalk named \"" + myAlias + "\"";
            log.error((Object)msg);
            throw new CrosswalkInternalException(msg);
        }
        String parent = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        File propsFile = new File(parent, propsFilename);
        Properties modsConfig = new Properties();
        FileInputStream pfs = null;
        try {
            pfs = new FileInputStream(propsFile);
            modsConfig.load(pfs);
        }
        catch (IOException e) {
            log.error((Object)("Error opening or reading MODS properties file: " + propsFile.toString() + ": " + e.toString()));
            throw new CrosswalkInternalException("MODS crosswalk cannot open config file: " + e.toString());
        }
        finally {
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.modsMap = new HashMap();
        Enumeration<?> pe = modsConfig.propertyNames();
        while (pe.hasMoreElements()) {
            String qdc = (String)pe.nextElement();
            String val = modsConfig.getProperty(qdc);
            String[] pair = val.split("\\s+\\|\\s+", 2);
            if (pair.length < 2) {
                log.warn((Object)("Illegal MODS mapping in " + propsFile.toString() + ", line = " + qdc + " = " + val));
                continue;
            }
            modsTriple trip = modsTriple.create(qdc, pair[0], pair[1]);
            if (trip == null) continue;
            this.modsMap.put(qdc, trip);
        }
    }

    public Namespace[] getNamespaces() {
        return namespaces;
    }

    public String getSchemaLocation() {
        return schemaLocation;
    }

    public List disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateListInternal(dso, true);
    }

    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element root = new Element("mods", MODS_NS);
        root.setAttribute("schemaLocation", schemaLocation, XSI_NS);
        root.addContent((Collection)this.disseminateListInternal(dso, false));
        return root;
    }

    private List disseminateListInternal(DSpaceObject dso, boolean addSchema) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("MODSDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        this.initMap();
        DCValue[] dc = item.getMetadata("*", "*", "*", "*");
        ArrayList<Element> result = new ArrayList<Element>(dc.length);
        for (int i = 0; i < dc.length; ++i) {
            String qdc = dc[i].schema + "." + (dc[i].qualifier == null ? dc[i].element : dc[i].element + "." + dc[i].qualifier);
            modsTriple trip = (modsTriple)this.modsMap.get(qdc);
            if (trip == null) {
                log.warn((Object)("WARNING: " + this.getPluginInstanceName() + ": No MODS mapping for \"" + qdc + "\""));
                continue;
            }
            try {
                Iterator ni;
                Element me = (Element)trip.xml.clone();
                if (addSchema) {
                    me.setAttribute("schemaLocation", schemaLocation, XSI_NS);
                }
                if (!(ni = trip.xpath.selectNodes((Object)me).iterator()).hasNext()) {
                    log.warn((Object)("XPath \"" + trip.xpath.getXPath() + "\" found no elements in \"" + outputUgly.outputString(me) + "\", qdc=" + qdc));
                }
                while (ni.hasNext()) {
                    Object what = ni.next();
                    if (what instanceof Element) {
                        ((Element)what).setText(dc[i].value);
                        continue;
                    }
                    if (what instanceof Attribute) {
                        ((Attribute)what).setValue(dc[i].value);
                        continue;
                    }
                    if (what instanceof Text) {
                        ((Text)what).setText(dc[i].value);
                        continue;
                    }
                    log.warn((Object)("Got unknown object from XPath, class=" + what.getClass().getName()));
                }
                result.add(me);
                continue;
            }
            catch (JDOMException je) {
                log.error((Object)("Error following XPath in modsTriple: context=" + outputUgly.outputString(trip.xml) + ", xpath=" + trip.xpath.getXPath() + ", exception=" + je.toString()));
            }
        }
        return result;
    }

    public boolean canDisseminate(DSpaceObject dso) {
        return true;
    }

    public boolean preferList() {
        return false;
    }

    static {
        ArrayList<String> aliasList = new ArrayList<String>();
        Enumeration pe = ConfigurationManager.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            aliasList.add(key.substring(CONFIG_PREFIX.length()));
        }
        aliases = aliasList.toArray(new String[aliasList.size()]);
        MODS_NS = Namespace.getNamespace((String)"mods", (String)"http://www.loc.gov/mods/v3");
        XLINK_NS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
        namespaces = new Namespace[]{MODS_NS, XLINK_NS};
        schemaLocation = MODS_NS.getURI() + " " + MODS_XSD;
        outputUgly = new XMLOutputter();
        outputPretty = new XMLOutputter(Format.getPrettyFormat());
        builder = new SAXBuilder();
    }

    static class modsTriple {
        public String qdc = null;
        public Element xml = null;
        public XPath xpath = null;

        modsTriple() {
        }

        public static modsTriple create(String qdc, String xml, String xpath) {
            modsTriple result = new modsTriple();
            String prolog = "<mods xmlns:" + MODS_NS.getPrefix() + "=\"" + MODS_NS.getURI() + "\" " + "xmlns:" + XLINK_NS.getPrefix() + "=\"" + XLINK_NS.getURI() + "\">";
            String postlog = "</mods>";
            try {
                result.qdc = qdc;
                result.xpath = XPath.newInstance((String)xpath);
                result.xpath.addNamespace(MODS_NS.getPrefix(), MODS_NS.getURI());
                result.xpath.addNamespace(XLINK_NS);
                Document d = builder.build((Reader)new StringReader(prolog + xml + "</mods>"));
                result.xml = (Element)d.getRootElement().getContent(0);
            }
            catch (JDOMException je) {
                log.error((Object)("Error initializing modsTriple(\"" + qdc + "\",\"" + xml + "\",\"" + xpath + "\"): got " + je.toString()));
                return null;
            }
            catch (IOException je) {
                log.error((Object)("Error initializing modsTriple(\"" + qdc + "\",\"" + xml + "\",\"" + xpath + "\"): got " + je.toString()));
                return null;
            }
            return result;
        }
    }
}

