/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class METSManifest {
    private static Logger log = Logger.getLogger(METSManifest.class);
    public static final String MANIFEST_FILE = "mets.xml";
    private static final String CONFIG_METADATA_PREFIX = "mets.submission.crosswalk.";
    private static final String CONFIG_XSD_PREFIX = "mets.xsd.";
    private static Namespace dcNS = Namespace.getNamespace((String)"http://purl.org/dc/elements/1.1/");
    private static Namespace dcTermNS = Namespace.getNamespace((String)"http://purl.org/dc/terms/");
    public static Namespace metsNS = Namespace.getNamespace((String)"mets", (String)"http://www.loc.gov/METS/");
    private static Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private Element mets = null;
    private List mdFiles = null;
    private List contentFiles = null;
    private SAXBuilder parser = null;
    private static String localSchemas;

    private METSManifest(SAXBuilder builder, Element mets) {
        this.mets = mets;
        this.parser = builder;
    }

    public static METSManifest create(InputStream is, boolean validate) throws IOException, MetadataValidationException {
        Document metsDocument;
        SAXBuilder builder = new SAXBuilder(validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        if (localSchemas.length() > 0) {
            builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)localSchemas);
        }
        try {
            metsDocument = builder.build(is);
        }
        catch (JDOMException je) {
            throw new MetadataValidationException("Error validating METS in " + is.toString(), je);
        }
        return new METSManifest(builder, metsDocument.getRootElement());
    }

    public String getProfile() {
        return this.mets.getAttributeValue("PROFILE");
    }

    public List getContentFiles() throws MetadataValidationException {
        if (this.contentFiles != null) {
            return this.contentFiles;
        }
        Element fileSec = this.mets.getChild("fileSec", metsNS);
        if (fileSec == null) {
            throw new MetadataValidationException("Invalid METS Manifest: DSpace requires a fileSec element, but it is missing.");
        }
        this.contentFiles = new ArrayList();
        for (Element fg : fileSec.getChildren("fileGrp", metsNS)) {
            for (Element f : fg.getChildren("file", metsNS)) {
                this.contentFiles.add(f);
            }
        }
        return this.contentFiles;
    }

    public List getMdFiles() throws MetadataValidationException {
        if (this.mdFiles == null) {
            try {
                XPath xpath = XPath.newInstance((String)"descendant::mets:mdRef");
                xpath.addNamespace(metsNS);
                this.mdFiles = xpath.selectNodes((Object)this.mets);
            }
            catch (JDOMException je) {
                throw new MetadataValidationException("Failed while searching for mdRef elements in manifest: ", je);
            }
        }
        return this.mdFiles;
    }

    public Element getOriginalFile(Element file) {
        String groupID = file.getAttributeValue("GROUPID");
        if (groupID == null || groupID.equals("")) {
            return null;
        }
        try {
            XPath xpath = XPath.newInstance((String)("mets:fileSec/mets:fileGrp[@USE=\"CONTENT\"]/mets:file[@GROUPID=\"" + groupID + "\"]"));
            xpath.addNamespace(metsNS);
            List oFiles = xpath.selectNodes((Object)this.mets);
            if (oFiles.size() > 0) {
                log.debug((Object)("Got ORIGINAL file for derived=" + file.toString()));
                return (Element)oFiles.get(0);
            }
            return null;
        }
        catch (JDOMException je) {
            log.warn((Object)("Got exception on XPATH looking for Original file, " + je.toString()));
            return null;
        }
    }

    private static String normalizeBundleName(String in) {
        if (in.equals("CONTENT")) {
            return "ORIGINAL";
        }
        if (in.equals("MANIFESTMD")) {
            return "METADATA";
        }
        return in;
    }

    public static String getBundleName(Element file) throws MetadataValidationException {
        Element fg = file.getParentElement();
        String fgUse = fg.getAttributeValue("USE");
        if (fgUse == null) {
            throw new MetadataValidationException("Invalid METS Manifest: every fileGrp element must have a USE attribute.");
        }
        return METSManifest.normalizeBundleName(fgUse);
    }

    public static String getFileName(Element file) throws MetadataValidationException {
        String loctype;
        Element ref;
        if (file.getName().equals("file")) {
            ref = file.getChild("FLocat", metsNS);
            if (ref == null) {
                if (file.getChild("FContent", metsNS) == null) {
                    throw new MetadataValidationException("Invalid METS Manifest: Every file element must have FLocat child.");
                }
                throw new MetadataValidationException("Invalid METS Manifest: file element has forbidden FContent child, only FLocat is allowed.");
            }
        } else if (file.getName().equals("mdRef")) {
            ref = file;
        } else {
            throw new MetadataValidationException("getFileName() called with recognized element type: " + file.toString());
        }
        if ((loctype = ref.getAttributeValue("LOCTYPE")) != null && loctype.equals("URL")) {
            String result = ref.getAttributeValue("href", xlinkNS);
            if (result == null) {
                throw new MetadataValidationException("Invalid METS Manifest: FLocat/mdRef is missing the required xlink:href attribute.");
            }
            return result;
        }
        throw new MetadataValidationException("Invalid METS Manifest: FLocat/mdRef does not have LOCTYPE=\"URL\" attribute.");
    }

    public Element getPrimaryBitstream() throws MetadataValidationException {
        Element firstDiv = this.getFirstDiv();
        Element fptr = firstDiv.getChild("fptr", metsNS);
        if (fptr == null) {
            return null;
        }
        String id = fptr.getAttributeValue("FILEID");
        if (id == null) {
            throw new MetadataValidationException("fptr for Primary Bitstream is missing the required FILEID attribute.");
        }
        Element result = this.getElementByXPath("descendant::mets:file[@ID=\"" + id + "\"]", false);
        if (result == null) {
            throw new MetadataValidationException("Cannot find file element for Primary Bitstream: looking for ID=" + id);
        }
        return result;
    }

    public String getMdType(Element mdSec) throws MetadataValidationException {
        Element md = mdSec.getChild("mdRef", metsNS);
        if (md == null) {
            md = mdSec.getChild("mdWrap", metsNS);
        }
        if (md == null) {
            throw new MetadataValidationException("Invalid METS Manifest: ?mdSec element has neither mdRef nor mdWrap child.");
        }
        String result = md.getAttributeValue("MDTYPE");
        if (result != null && result.equals("OTHER")) {
            result = md.getAttributeValue("OTHERMDTYPE");
        }
        if (result == null) {
            throw new MetadataValidationException("Invalid METS Manifest: " + md.getName() + " has no MDTYPE or OTHERMDTYPE attribute.");
        }
        return result;
    }

    public String getMdContentMimeType(Element mdSec) throws MetadataValidationException {
        Element mdWrap = mdSec.getChild("mdWrap", metsNS);
        if (mdWrap != null) {
            String mimeType = mdWrap.getAttributeValue("MIMETYPE");
            if (mimeType == null && mdWrap.getChild("xmlData", metsNS) != null) {
                mimeType = "text/xml";
            }
            return mimeType;
        }
        Element mdRef = mdSec.getChild("mdRef", metsNS);
        if (mdRef != null) {
            return mdRef.getAttributeValue("MIMETYPE");
        }
        return null;
    }

    public List getMdContentAsXml(Element mdSec, Mdref callback) throws MetadataValidationException, IOException, SQLException, AuthorizeException {
        try {
            Element mdRef = null;
            Element mdWrap = mdSec.getChild("mdWrap", metsNS);
            if (mdWrap != null) {
                Element xmlData = mdWrap.getChild("xmlData", metsNS);
                if (xmlData == null) {
                    Element bin = mdWrap.getChild("binData", metsNS);
                    if (bin == null) {
                        throw new MetadataValidationException("Invalid METS Manifest: mdWrap element with neither xmlData nor binData child.");
                    }
                    String mimeType = mdWrap.getAttributeValue("MIMETYPE");
                    if (mimeType != null && mimeType.equalsIgnoreCase("text/xml")) {
                        byte[] value = Base64.decodeBase64((byte[])bin.getText().getBytes());
                        Document mdd = this.parser.build((InputStream)new ByteArrayInputStream(value));
                        ArrayList<Element> result = new ArrayList<Element>(1);
                        result.add(mdd.getRootElement());
                        return result;
                    }
                    log.warn((Object)("Ignoring binData section because MIMETYPE is not XML, but: " + mimeType));
                    return new ArrayList(0);
                }
                return xmlData.getChildren();
            }
            mdRef = mdSec.getChild("mdRef", metsNS);
            if (mdRef != null) {
                String mimeType = mdRef.getAttributeValue("MIMETYPE");
                if (mimeType != null && mimeType.equalsIgnoreCase("text/xml")) {
                    Document mdd = this.parser.build(callback.getInputStream(mdRef));
                    ArrayList<Element> result = new ArrayList<Element>(1);
                    result.add(mdd.getRootElement());
                    return result;
                }
                log.warn((Object)("Ignoring mdRef section because MIMETYPE is not XML, but: " + mimeType));
                return new ArrayList(0);
            }
            throw new MetadataValidationException("Invalid METS Manifest: ?mdSec element with neither mdRef nor mdWrap child.");
        }
        catch (JDOMException je) {
            throw new MetadataValidationException("Error parsing or validating metadata section in mdRef or binData within " + mdSec.toString(), je);
        }
    }

    public InputStream getMdContentAsStream(Element mdSec, Mdref callback) throws MetadataValidationException, IOException, SQLException, AuthorizeException {
        Element mdRef = null;
        Element mdWrap = mdSec.getChild("mdWrap", metsNS);
        if (mdWrap != null) {
            Element xmlData = mdWrap.getChild("xmlData", metsNS);
            if (xmlData == null) {
                Element bin = mdWrap.getChild("binData", metsNS);
                if (bin == null) {
                    throw new MetadataValidationException("Invalid METS Manifest: mdWrap element with neither xmlData nor binData child.");
                }
                byte[] value = Base64.decodeBase64((byte[])bin.getText().getBytes());
                return new ByteArrayInputStream(value);
            }
            XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
            return new ByteArrayInputStream(outputPretty.outputString(xmlData.getChildren()).getBytes());
        }
        mdRef = mdSec.getChild("mdRef", metsNS);
        if (mdRef != null) {
            return callback.getInputStream(mdRef);
        }
        throw new MetadataValidationException("Invalid METS Manifest: ?mdSec element with neither mdRef nor mdWrap child.");
    }

    private void crosswalkMdContent(Element mdSec, Mdref callback, IngestionCrosswalk xwalk, Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        List xml = this.getMdContentAsXml(mdSec, callback);
        try {
            xwalk.ingest(context, dso, xml);
        }
        catch (CrosswalkObjectNotSupported e) {
            log.warn((Object)("Skipping metadata for inappropriate type of object: Object=" + dso.toString() + ", error=" + e.toString()));
        }
    }

    private Element getFirstDiv() throws MetadataValidationException {
        Element sm = this.mets.getChild("structMap", metsNS);
        if (sm == null) {
            throw new MetadataValidationException("METS document is missing the required structMap element.");
        }
        Element result = sm.getChild("div", metsNS);
        if (result == null) {
            throw new MetadataValidationException("METS document is missing the required first div element in first structMap.");
        }
        log.debug((Object)("Got firstDiv result=" + result.toString()));
        return result;
    }

    private Element getElementByXPath(String path, boolean nullOk) throws MetadataValidationException {
        try {
            XPath xpath = XPath.newInstance((String)path);
            xpath.addNamespace(metsNS);
            xpath.addNamespace(xlinkNS);
            Object result = xpath.selectSingleNode((Object)this.mets);
            if (result == null && nullOk) {
                return null;
            }
            if (result instanceof Element) {
                return (Element)result;
            }
            throw new MetadataValidationException("METSManifest: Failed to resolve XPath, path=\"" + path + "\"");
        }
        catch (JDOMException je) {
            throw new MetadataValidationException("METSManifest: Failed to resolve XPath, path=\"" + path + "\"", je);
        }
    }

    private IngestionCrosswalk getCrosswalk(String type) {
        String xwalkName = ConfigurationManager.getProperty(CONFIG_METADATA_PREFIX + type);
        if (xwalkName == null) {
            xwalkName = type;
        }
        return (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, xwalkName);
    }

    public Element[] getItemDmds() throws MetadataValidationException {
        Element firstDiv = this.getFirstDiv();
        String dmds = firstDiv.getAttributeValue("DMDID");
        if (dmds == null) {
            throw new MetadataValidationException("Invalid METS: Missing reference to Item descriptive metadata, first div on first structmap must have a DMDID attribute.");
        }
        String[] dmdID = dmds.split("\\s+");
        Element[] result = new Element[dmdID.length];
        for (int i = 0; i < dmdID.length; ++i) {
            result[i] = this.getElementByXPath("mets:dmdSec[@ID=\"" + dmdID[i] + "\"]", false);
        }
        return result;
    }

    public Element[] getItemRightsMD() throws MetadataValidationException {
        Element firstDiv = this.getFirstDiv();
        String amds = firstDiv.getAttributeValue("ADMID");
        if (amds == null) {
            log.debug((Object)"getItemRightsMD: No ADMID references found.");
            return new Element[0];
        }
        String[] amdID = amds.split("\\s+");
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < amdID.length; ++i) {
            List rmds = this.getElementByXPath("mets:amdSec[@ID=\"" + amdID[i] + "\"]", false).getChildren("rightsMD", metsNS);
            if (rmds.size() <= 0) continue;
            resultList.addAll(rmds);
        }
        return resultList.toArray(new Element[resultList.size()]);
    }

    public void crosswalkItem(Context context, Item item, Element dmd, Mdref callback) throws MetadataValidationException, CrosswalkException, IOException, SQLException, AuthorizeException {
        String type = this.getMdType(dmd);
        IngestionCrosswalk xwalk = this.getCrosswalk(type);
        if (xwalk == null) {
            throw new MetadataValidationException("Cannot process METS Manifest: No crosswalk found for MDTYPE=" + type);
        }
        this.crosswalkMdContent(dmd, callback, xwalk, context, item);
    }

    public void crosswalkBitstream(Context context, Bitstream bitstream, String fileId, Mdref callback) throws MetadataValidationException, CrosswalkException, IOException, SQLException, AuthorizeException {
        Element file = this.getElementByXPath("descendant::mets:file[@ID=\"" + fileId + "\"]", false);
        if (file == null) {
            throw new MetadataValidationException("Failed in Bitstream crosswalk, Could not find file element with ID=" + fileId);
        }
        String amds = file.getAttributeValue("ADMID");
        if (amds == null) {
            log.warn((Object)("Got no bitstream ADMID, file@ID=" + fileId));
            return;
        }
        String[] amdID = amds.split("\\s+");
        for (int i = 0; i < amdID.length; ++i) {
            List techMDs = this.getElementByXPath("mets:amdSec[@ID=\"" + amdID[i] + "\"]", false).getChildren("techMD", metsNS);
            for (Element techMD : techMDs) {
                if (techMD == null) continue;
                String type = this.getMdType(techMD);
                IngestionCrosswalk xwalk = this.getCrosswalk(type);
                log.debug((Object)("Got bitstream techMD of type=" + type + ", for file ID=" + fileId));
                if (xwalk == null) {
                    throw new MetadataValidationException("Cannot process METS Manifest: No crosswalk found for techMD MDTYPE=" + type);
                }
                this.crosswalkMdContent(techMD, callback, xwalk, context, bitstream);
            }
        }
    }

    public String getHandle() throws MetadataValidationException {
        String handle = this.mets.getAttributeValue("OBJID");
        if (handle != null && handle.startsWith("hdl:")) {
            return handle.substring(4);
        }
        throw new MetadataValidationException("Item has no valid Handle (OBJID)");
    }

    static {
        String dspace_dir = ConfigurationManager.getProperty("dspace.dir");
        File xsdPath1 = new File(dspace_dir + "/config/schemas/");
        File xsdPath2 = new File(dspace_dir + "/config/");
        Enumeration pe = ConfigurationManager.propertyNames();
        StringBuffer result = new StringBuffer();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(CONFIG_XSD_PREFIX)) continue;
            String spec = ConfigurationManager.getProperty(key);
            String[] val = spec.trim().split("\\s+");
            if (val.length == 2) {
                File xsd = new File(xsdPath1, val[1]);
                if (!xsd.exists()) {
                    xsd = new File(xsdPath2, val[1]);
                }
                if (!xsd.exists()) {
                    log.warn((Object)("Schema file not found for config entry=\"" + spec + "\""));
                    continue;
                }
                try {
                    String u = xsd.toURL().toString();
                    if (result.length() > 0) {
                        result.append(" ");
                    }
                    result.append(val[0]).append(" ").append(u);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Skipping badly formed XSD URL: " + e.toString()));
                }
                continue;
            }
            log.warn((Object)("Schema config entry has wrong format, entry=\"" + spec + "\""));
        }
        localSchemas = result.toString();
        log.debug((Object)("Got local schemas = \"" + localSchemas + "\""));
    }

    public static interface Mdref {
        public InputStream getInputStream(Element var1) throws MetadataValidationException, IOException, SQLException, AuthorizeException;
    }
}

