/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPerson
extends DSpaceObject {
    public static final int EMAIL = 1;
    public static final int LASTNAME = 2;
    public static final int ID = 3;
    public static final int NETID = 4;
    public static final int LANGUAGE = 5;
    private static Logger log = Logger.getLogger(EPerson.class);
    private Context myContext;
    private TableRow myRow;
    private boolean modified;
    private boolean modifiedMetadata;

    EPerson(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
        context.cache(this, row.getIntColumn("eperson_id"));
        this.modifiedMetadata = false;
        this.modified = false;
        this.clearDetails();
    }

    public static EPerson find(Context context, int id) throws SQLException {
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "eperson", id);
        if (row == null) {
            return null;
        }
        return new EPerson(context, row);
    }

    public static EPerson findByEmail(Context context, String email) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.findByUnique(context, "eperson", "email", email);
        if (row == null) {
            return null;
        }
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
        if (fromCache != null) {
            return fromCache;
        }
        return new EPerson(context, row);
    }

    public static EPerson findByNetid(Context context, String netid) throws SQLException {
        if (netid == null) {
            return null;
        }
        TableRow row = DatabaseManager.findByUnique(context, "eperson", "netid", netid);
        if (row == null) {
            return null;
        }
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
        if (fromCache != null) {
            return fromCache;
        }
        return new EPerson(context, row);
    }

    public static EPerson[] search(Context context, String query) throws SQLException {
        return EPerson.search(context, query, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPerson[] search(Context context, String query, int offset, int limit) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT * FROM eperson WHERE eperson_id = ? OR ");
        queryBuf.append("LOWER(firstname) LIKE LOWER(?) OR LOWER(lastname) LIKE LOWER(?) OR LOWER(email) LIKE LOWER(?) ORDER BY lastname, firstname ASC ");
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            if (limit > 0 || offset > 0) {
                queryBuf.insert(0, "SELECT /*+ FIRST_ROWS(n) */ rec.*, ROWNUM rnum  FROM (");
                queryBuf.append(") ");
            }
            if (limit > 0) {
                queryBuf.append("rec WHERE rownum<=? ");
                if (offset > 0) {
                    limit += offset;
                }
            }
            if (offset > 0) {
                queryBuf.insert(0, "SELECT * FROM (");
                queryBuf.append(") WHERE rnum>?");
            }
        } else {
            if (limit > 0) {
                queryBuf.append(" LIMIT ? ");
            }
            if (offset > 0) {
                queryBuf.append(" OFFSET ? ");
            }
        }
        String dbquery = queryBuf.toString();
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = new Integer(-1);
        }
        Object[] paramArr = new Object[]{int_param, params, params, params};
        if (limit > 0 && offset > 0) {
            paramArr = new Object[]{int_param, params, params, params, limit, offset};
        } else if (limit > 0) {
            paramArr = new Object[]{int_param, params, params, params, limit};
        } else if (offset > 0) {
            paramArr = new Object[]{int_param, params, params, params, offset};
        }
        TableRowIterator rows = DatabaseManager.query(context, dbquery, paramArr);
        try {
            List epeopleRows = rows.toList();
            EPerson[] epeople = new EPerson[epeopleRows.size()];
            for (int i = 0; i < epeopleRows.size(); ++i) {
                TableRow row = (TableRow)epeopleRows.get(i);
                EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
                epeople[i] = fromCache != null ? fromCache : new EPerson(context, row);
            }
            EPerson[] ePersonArray = epeople;
            return ePersonArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static int searchResultCount(Context context, String query) throws SQLException {
        Integer int_param;
        String dbquery = "%" + query.toLowerCase() + "%";
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = new Integer(-1);
        }
        TableRow row = DatabaseManager.querySingle(context, "SELECT count(*) as epcount FROM eperson WHERE eperson_id = ? OR LOWER(firstname) LIKE LOWER(?) OR LOWER(lastname) LIKE LOWER(?) OR LOWER(email) LIKE LOWER(?)", int_param, dbquery, dbquery, dbquery);
        Long count = "oracle".equals(ConfigurationManager.getProperty("db.name")) ? new Long(row.getIntColumn("epcount")) : new Long(row.getLongColumn("epcount"));
        return count.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPerson[] findAll(Context context, int sortField) throws SQLException {
        String s;
        switch (sortField) {
            case 3: {
                s = "eperson_id";
                break;
            }
            case 1: {
                s = "email";
                break;
            }
            case 5: {
                s = "language";
                break;
            }
            case 4: {
                s = "netid";
                break;
            }
            default: {
                s = "lastname";
            }
        }
        TableRowIterator rows = DatabaseManager.query(context, "SELECT * FROM eperson ORDER BY " + s, new Object[0]);
        try {
            List epeopleRows = rows.toList();
            EPerson[] epeople = new EPerson[epeopleRows.size()];
            for (int i = 0; i < epeopleRows.size(); ++i) {
                TableRow row = (TableRow)epeopleRows.get(i);
                EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
                epeople[i] = fromCache != null ? fromCache : new EPerson(context, row);
            }
            EPerson[] ePersonArray = epeople;
            return ePersonArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static EPerson create(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson");
        }
        TableRow row = DatabaseManager.create(context, "eperson");
        EPerson e = new EPerson(context, row);
        log.info((Object)LogManager.getHeader(context, "create_eperson", "eperson_id=" + e.getID()));
        context.addEvent(new Event(1, 7, e.getID(), null));
        return e;
    }

    public void delete() throws SQLException, AuthorizeException, EPersonDeletionException {
        if (!AuthorizeManager.isAdmin(this.myContext)) {
            throw new AuthorizeException("You must be an admin to delete an EPerson");
        }
        Vector<String> constraintList = this.getDeleteConstraints();
        if (constraintList.size() > 0) {
            throw new EPersonDeletionException(constraintList);
        }
        this.myContext.addEvent(new Event(32, 7, this.getID(), this.getEmail()));
        this.myContext.removeCached(this, this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM EPersonGroup2EPerson WHERE eperson_id= ? ", this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM subscription WHERE eperson_id= ? ", this.getID());
        DatabaseManager.delete(this.myContext, this.myRow);
        log.info((Object)LogManager.getHeader(this.myContext, "delete_eperson", "eperson_id=" + this.getID()));
    }

    @Override
    public int getID() {
        return this.myRow.getIntColumn("eperson_id");
    }

    public String getLanguage() {
        return this.myRow.getStringColumn("language");
    }

    public void setLanguage(String language) {
        this.myRow.setColumn("language", language);
    }

    @Override
    public String getHandle() {
        return null;
    }

    public String getEmail() {
        return this.myRow.getStringColumn("email");
    }

    public void setEmail(String s) {
        if (s != null) {
            s = s.toLowerCase();
        }
        this.myRow.setColumn("email", s);
        this.modified = true;
    }

    public String getNetid() {
        return this.myRow.getStringColumn("netid");
    }

    public void setNetid(String s) {
        this.myRow.setColumn("netid", s);
        this.modified = true;
    }

    public String getFullName() {
        String f = this.myRow.getStringColumn("firstname");
        String l = this.myRow.getStringColumn("lastname");
        if (l == null && f == null) {
            return this.getEmail();
        }
        if (f == null) {
            return l;
        }
        return f + " " + l;
    }

    public String getFirstName() {
        return this.myRow.getStringColumn("firstname");
    }

    public void setFirstName(String firstname) {
        this.myRow.setColumn("firstname", firstname);
        this.modified = true;
    }

    public String getLastName() {
        return this.myRow.getStringColumn("lastname");
    }

    public void setLastName(String lastname) {
        this.myRow.setColumn("lastname", lastname);
        this.modified = true;
    }

    public void setCanLogIn(boolean login) {
        this.myRow.setColumn("can_log_in", login);
        this.modified = true;
    }

    public boolean canLogIn() {
        return this.myRow.getBooleanColumn("can_log_in");
    }

    public void setRequireCertificate(boolean isrequired) {
        this.myRow.setColumn("require_certificate", isrequired);
        this.modified = true;
    }

    public boolean getRequireCertificate() {
        return this.myRow.getBooleanColumn("require_certificate");
    }

    public void setSelfRegistered(boolean sr) {
        this.myRow.setColumn("self_registered", sr);
        this.modified = true;
    }

    public boolean getSelfRegistered() {
        return this.myRow.getBooleanColumn("self_registered");
    }

    public String getMetadata(String field) {
        return this.myRow.getStringColumn(field);
    }

    public void setMetadata(String field, String value) {
        this.myRow.setColumn(field, value);
        this.modifiedMetadata = true;
        this.addDetails(field);
    }

    public void setPassword(String s) {
        String encoded = Utils.getMD5(s);
        this.myRow.setColumn("password", encoded);
        this.modified = true;
    }

    public boolean checkPassword(String attempt) {
        String encoded = Utils.getMD5(attempt);
        return encoded.equals(this.myRow.getStringColumn("password"));
    }

    public void update() throws SQLException, AuthorizeException {
        if (!(this.myContext.ignoreAuthorization() || this.myContext.getCurrentUser() != null && this.getID() == this.myContext.getCurrentUser().getID())) {
            AuthorizeManager.authorizeAction(this.myContext, this, 1);
        }
        DatabaseManager.update(this.myContext, this.myRow);
        log.info((Object)LogManager.getHeader(this.myContext, "update_eperson", "eperson_id=" + this.getID()));
        if (this.modified) {
            this.myContext.addEvent(new Event(2, 7, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.myContext.addEvent(new Event(4, 7, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
    }

    public boolean obsolete_equals(Object other) {
        if (!(other instanceof EPerson)) {
            return false;
        }
        return this.getID() == ((EPerson)other).getID();
    }

    @Override
    public int getType() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getDeleteConstraints() throws SQLException {
        Vector<String> tableList = new Vector<String>();
        TableRowIterator tri = DatabaseManager.query(this.myContext, "SELECT * from item where submitter_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("item");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        tri = DatabaseManager.query(this.myContext, "SELECT * from workflowitem where owner= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("workflowitem");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        tri = DatabaseManager.query(this.myContext, "SELECT * from tasklistitem where eperson_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("tasklistitem");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return tableList;
    }

    @Override
    public String getName() {
        return this.getEmail();
    }
}

