/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends DSpaceObject {
    public static final int ID = 0;
    public static final int NAME = 1;
    private static Logger log = Logger.getLogger(Group.class);
    private Context myContext;
    private TableRow myRow;
    private List<EPerson> epeople = new ArrayList<EPerson>();
    private List<Group> groups = new ArrayList<Group>();
    private boolean epeopleChanged = false;
    private boolean groupsChanged = false;
    private boolean isDataLoaded = false;
    private boolean modifiedMetadata;

    Group(Context context, TableRow row) throws SQLException {
        this.myContext = context;
        this.myRow = row;
        context.cache(this, row.getIntColumn("eperson_group_id"));
        this.modifiedMetadata = false;
        this.clearDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        if (!this.isDataLoaded) {
            try {
                DSpaceObject fromCache;
                TableRow r;
                TableRowIterator tri = DatabaseManager.queryTable(this.myContext, "eperson", "SELECT eperson.* FROM eperson, epersongroup2eperson WHERE epersongroup2eperson.eperson_id=eperson.eperson_id AND epersongroup2eperson.eperson_group_id= ?", this.myRow.getIntColumn("eperson_group_id"));
                try {
                    while (tri.hasNext()) {
                        r = tri.next();
                        fromCache = (EPerson)this.myContext.fromCache(EPerson.class, r.getIntColumn("eperson_id"));
                        if (fromCache != null) {
                            this.epeople.add((EPerson)fromCache);
                            continue;
                        }
                        this.epeople.add(new EPerson(this.myContext, r));
                    }
                }
                finally {
                    if (tri != null) {
                        tri.close();
                    }
                }
                tri = DatabaseManager.queryTable(this.myContext, "epersongroup", "SELECT epersongroup.* FROM epersongroup, group2group WHERE group2group.child_id=epersongroup.eperson_group_id AND group2group.parent_id= ? ", this.myRow.getIntColumn("eperson_group_id"));
                try {
                    while (tri.hasNext()) {
                        r = tri.next();
                        fromCache = (Group)this.myContext.fromCache(Group.class, r.getIntColumn("eperson_group_id"));
                        if (fromCache != null) {
                            this.groups.add((Group)fromCache);
                            continue;
                        }
                        this.groups.add(new Group(this.myContext, r));
                    }
                }
                finally {
                    if (tri != null) {
                        tri.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.isDataLoaded = true;
        }
    }

    public static Group create(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson Group");
        }
        TableRow row = DatabaseManager.create(context, "epersongroup");
        Group g = new Group(context, row);
        log.info((Object)LogManager.getHeader(context, "create_group", "group_id=" + g.getID()));
        context.addEvent(new Event(1, 6, g.getID(), null));
        return g;
    }

    @Override
    public int getID() {
        return this.myRow.getIntColumn("eperson_group_id");
    }

    @Override
    public String getName() {
        return this.myRow.getStringColumn("name");
    }

    public void setName(String name) {
        this.myRow.setColumn("name", name);
        this.modifiedMetadata = true;
        this.addDetails("name");
    }

    public void addMember(EPerson e) {
        this.loadData();
        if (this.isMember(e)) {
            return;
        }
        this.epeople.add(e);
        this.epeopleChanged = true;
        this.myContext.addEvent(new Event(8, 6, this.getID(), 7, e.getID(), e.getEmail()));
    }

    public void addMember(Group g) {
        this.loadData();
        if (this.isMember(g) || this.getID() == g.getID()) {
            return;
        }
        this.groups.add(g);
        this.groupsChanged = true;
        this.myContext.addEvent(new Event(8, 6, this.getID(), 6, g.getID(), g.getName()));
    }

    public void removeMember(EPerson e) {
        this.loadData();
        if (this.epeople.remove(e)) {
            this.epeopleChanged = true;
            this.myContext.addEvent(new Event(16, 6, this.getID(), 7, e.getID(), e.getEmail()));
        }
    }

    public void removeMember(Group g) {
        this.loadData();
        if (this.groups.remove(g)) {
            this.groupsChanged = true;
            this.myContext.addEvent(new Event(16, 6, this.getID(), 6, g.getID(), g.getName()));
        }
    }

    public boolean isMember(EPerson e) {
        if (this.getID() == 0) {
            return true;
        }
        this.loadData();
        return this.epeople.contains(e);
    }

    public boolean isMember(Group g) {
        this.loadData();
        return this.groups.contains(g);
    }

    public static boolean isMember(Context c, int groupid) throws SQLException {
        if (groupid == 0) {
            return true;
        }
        EPerson currentuser = c.getCurrentUser();
        return Group.epersonInGroup(c, groupid, currentuser);
    }

    public static Group[] allMemberGroups(Context c, EPerson e) throws SQLException {
        ArrayList<Group> groupList = new ArrayList<Group>();
        Set<Integer> myGroups = Group.allMemberGroupIDs(c, e);
        Iterator<Integer> i = myGroups.iterator();
        while (i.hasNext()) {
            groupList.add(Group.find(c, i.next()));
        }
        return groupList.toArray(new Group[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> allMemberGroupIDs(Context c, EPerson e) throws SQLException {
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        if (e != null) {
            TableRowIterator tri = DatabaseManager.queryTable(c, "epersongroup2eperson", "SELECT * FROM epersongroup2eperson WHERE eperson_id= ?", e.getID());
            try {
                while (tri.hasNext()) {
                    TableRow row = tri.next();
                    int childID = row.getIntColumn("eperson_group_id");
                    groupIDs.add(new Integer(childID));
                }
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
        }
        if (c.getCurrentUser() != null && c.getCurrentUser().getID() == e.getID()) {
            Group[] specialGroups;
            for (Group special : specialGroups = c.getSpecialGroups()) {
                groupIDs.add(new Integer(special.getID()));
            }
        }
        groupIDs.add(new Integer(0));
        String groupQuery = "";
        Iterator i = groupIDs.iterator();
        Object[] parameters = new Object[groupIDs.size()];
        int idx = 0;
        while (i.hasNext()) {
            int groupID = (Integer)i.next();
            parameters[idx++] = new Integer(groupID);
            groupQuery = groupQuery + "child_id= ? ";
            if (!i.hasNext()) continue;
            groupQuery = groupQuery + " OR ";
        }
        TableRowIterator tri = DatabaseManager.queryTable(c, "group2groupcache", "SELECT * FROM group2groupcache WHERE " + groupQuery, parameters);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int parentID = row.getIntColumn("parent_id");
                groupIDs.add(new Integer(parentID));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return groupIDs;
    }

    public static EPerson[] allMembers(Context c, Group g) throws SQLException {
        ArrayList<EPerson> epersonList = new ArrayList<EPerson>();
        Set<Integer> myEpeople = Group.allMemberIDs(c, g);
        Iterator<Integer> i = myEpeople.iterator();
        while (i.hasNext()) {
            epersonList.add(EPerson.find(c, i.next()));
        }
        return epersonList.toArray(new EPerson[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> allMemberIDs(Context c, Group g) throws SQLException {
        HashSet<Integer> epeopleIDs = new HashSet<Integer>();
        TableRowIterator tri = DatabaseManager.queryTable(c, "group2groupcache", "SELECT * FROM group2groupcache WHERE parent_id= ? ", g.getID());
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int childID = row.getIntColumn("child_id");
                groupIDs.add(new Integer(childID));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Object[] parameters = new Object[groupIDs.size() + 1];
        int idx = 0;
        Iterator i = groupIDs.iterator();
        parameters[idx++] = new Integer(g.getID());
        String epersonQuery = "eperson_group_id= ? ";
        if (i.hasNext()) {
            epersonQuery = epersonQuery + " OR ";
        }
        while (i.hasNext()) {
            int groupID = (Integer)i.next();
            parameters[idx++] = new Integer(groupID);
            epersonQuery = epersonQuery + "eperson_group_id= ? ";
            if (!i.hasNext()) continue;
            epersonQuery = epersonQuery + " OR ";
        }
        tri = DatabaseManager.queryTable(c, "epersongroup2eperson", "SELECT * FROM epersongroup2eperson WHERE " + epersonQuery, parameters);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int epersonID = row.getIntColumn("eperson_id");
                epeopleIDs.add(new Integer(epersonID));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return epeopleIDs;
    }

    private static boolean epersonInGroup(Context c, int groupID, EPerson e) throws SQLException {
        Set<Integer> groupIDs = Group.allMemberGroupIDs(c, e);
        return groupIDs.contains(new Integer(groupID));
    }

    public static Group find(Context context, int id) throws SQLException {
        Group fromCache = (Group)context.fromCache(Group.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "epersongroup", id);
        if (row == null) {
            return null;
        }
        return new Group(context, row);
    }

    public static Group findByName(Context context, String name) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(context, "epersongroup", "name", name);
        if (row == null) {
            return null;
        }
        Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
        if (fromCache != null) {
            return fromCache;
        }
        return new Group(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] findAll(Context context, int sortField) throws SQLException {
        String s;
        switch (sortField) {
            case 0: {
                s = "eperson_group_id";
                break;
            }
            case 1: {
                s = "name";
                break;
            }
            default: {
                s = "name";
            }
        }
        TableRowIterator rows = DatabaseManager.queryTable(context, "epersongroup", "SELECT * FROM epersongroup ORDER BY " + s, new Object[0]);
        try {
            List gRows = rows.toList();
            Group[] groups = new Group[gRows.size()];
            for (int i = 0; i < gRows.size(); ++i) {
                TableRow row = (TableRow)gRows.get(i);
                Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
                groups[i] = fromCache != null ? fromCache : new Group(context, row);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static Group[] search(Context context, String query) throws SQLException {
        return Group.search(context, query, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] search(Context context, String query, int offset, int limit) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT * FROM epersongroup WHERE LOWER(name) LIKE LOWER(?) OR eperson_group_id = ? ORDER BY name ASC ");
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            if (limit > 0 || offset > 0) {
                queryBuf.insert(0, "SELECT /*+ FIRST_ROWS(n) */ rec.*, ROWNUM rnum  FROM (");
                queryBuf.append(") ");
            }
            if (limit > 0) {
                queryBuf.append("rec WHERE rownum<=? ");
                if (offset > 0) {
                    limit += offset;
                }
            }
            if (offset > 0) {
                queryBuf.insert(0, "SELECT * FROM (");
                queryBuf.append(") WHERE rnum>?");
            }
        } else {
            if (limit > 0) {
                queryBuf.append(" LIMIT ? ");
            }
            if (offset > 0) {
                queryBuf.append(" OFFSET ? ");
            }
        }
        String dbquery = queryBuf.toString();
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = new Integer(-1);
        }
        Object[] paramArr = new Object[]{params, int_param};
        if (limit > 0 && offset > 0) {
            paramArr = new Object[]{params, int_param, limit, offset};
        } else if (limit > 0) {
            paramArr = new Object[]{params, int_param, limit};
        } else if (offset > 0) {
            paramArr = new Object[]{params, int_param, offset};
        }
        TableRowIterator rows = DatabaseManager.query(context, dbquery, paramArr);
        try {
            List groupRows = rows.toList();
            Group[] groups = new Group[groupRows.size()];
            for (int i = 0; i < groupRows.size(); ++i) {
                TableRow row = (TableRow)groupRows.get(i);
                Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
                groups[i] = fromCache != null ? fromCache : new Group(context, row);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static int searchResultCount(Context context, String query) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        String dbquery = "SELECT count(*) as gcount FROM epersongroup WHERE LOWER(name) LIKE LOWER(?) OR eperson_group_id = ? ";
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = new Integer(-1);
        }
        TableRow row = DatabaseManager.querySingle(context, dbquery, params, int_param);
        Long count = "oracle".equals(ConfigurationManager.getProperty("db.name")) ? new Long(row.getIntColumn("gcount")) : new Long(row.getLongColumn("gcount"));
        return count.intValue();
    }

    public void delete() throws SQLException {
        this.myContext.addEvent(new Event(32, 6, this.getID(), this.getName()));
        this.myContext.removeCached(this, this.getID());
        AuthorizeManager.removeGroupPolicies(this.myContext, this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM EPersonGroup2EPerson WHERE eperson_group_id= ? ", this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM group2groupcache WHERE parent_id= ? OR child_id= ? ", this.getID(), this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM group2group WHERE parent_id= ? OR child_id= ? ", this.getID(), this.getID());
        this.deleteEpersonGroup2WorkspaceItem();
        DatabaseManager.delete(this.myContext, this.myRow);
        this.epeople.clear();
        log.info((Object)LogManager.getHeader(this.myContext, "delete_group", "group_id=" + this.getID()));
    }

    private void deleteEpersonGroup2WorkspaceItem() throws SQLException {
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM EPersonGroup2WorkspaceItem WHERE eperson_group_id= ? ", this.getID());
    }

    public EPerson[] getMembers() {
        this.loadData();
        EPerson[] myArray = new EPerson[this.epeople.size()];
        myArray = this.epeople.toArray(myArray);
        return myArray;
    }

    public Group[] getMemberGroups() {
        this.loadData();
        Group[] myArray = new Group[this.groups.size()];
        myArray = this.groups.toArray(myArray);
        return myArray;
    }

    public boolean isEmpty() {
        boolean hasMembers;
        this.loadData();
        boolean bl = hasMembers = this.epeople.size() != 0;
        if (hasMembers) {
            return false;
        }
        for (Group subGroup : this.groups) {
            hasMembers = !subGroup.isEmpty();
            if (!hasMembers) continue;
            return false;
        }
        return !hasMembers;
    }

    public void update() throws SQLException, AuthorizeException {
        TableRow mappingRow;
        DatabaseManager.update(this.myContext, this.myRow);
        if (this.modifiedMetadata) {
            this.myContext.addEvent(new Event(4, 6, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
        if (this.epeopleChanged) {
            DatabaseManager.updateQuery(this.myContext, "delete from epersongroup2eperson where eperson_group_id= ? ", this.getID());
            for (EPerson e : this.epeople) {
                mappingRow = DatabaseManager.create(this.myContext, "epersongroup2eperson");
                mappingRow.setColumn("eperson_id", e.getID());
                mappingRow.setColumn("eperson_group_id", this.getID());
                DatabaseManager.update(this.myContext, mappingRow);
            }
            this.epeopleChanged = false;
        }
        if (this.groupsChanged) {
            DatabaseManager.updateQuery(this.myContext, "delete from group2group where parent_id= ? ", this.getID());
            for (Group g : this.groups) {
                mappingRow = DatabaseManager.create(this.myContext, "group2group");
                mappingRow.setColumn("parent_id", this.getID());
                mappingRow.setColumn("child_id", g.getID());
                DatabaseManager.update(this.myContext, mappingRow);
            }
            this.rethinkGroupCache();
            this.groupsChanged = false;
        }
        log.info((Object)LogManager.getHeader(this.myContext, "update_group", "group_id=" + this.getID()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof Group)) {
            return false;
        }
        return this.getID() == ((Group)other).getID();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getHandle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rethinkGroupCache() throws SQLException {
        Set<Integer> children;
        TableRowIterator tri = DatabaseManager.queryTable(this.myContext, "group2group", "SELECT * FROM group2group", new Object[0]);
        HashMap<Integer, Set<Integer>> parents = new HashMap<Integer, Set<Integer>>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Integer parentID = new Integer(row.getIntColumn("parent_id"));
                Integer childID = new Integer(row.getIntColumn("child_id"));
                if (!parents.containsKey(parentID)) {
                    children = new HashSet<Integer>();
                    children.add(childID);
                    parents.put(parentID, children);
                    continue;
                }
                children = (Set)parents.get(parentID);
                children.add(childID);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        for (Integer parentID : parents.keySet()) {
            Set<Integer> myChildren = this.getChildren(parents, parentID);
            for (Integer childID : myChildren) {
                ((Set)parents.get(parentID)).add(childID);
            }
        }
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM group2groupcache WHERE id >= 0", new Object[0]);
        for (Integer parent : parents.keySet()) {
            children = (Set)parents.get(parent);
            for (Integer child : children) {
                TableRow row = DatabaseManager.create(this.myContext, "group2groupcache");
                int parentID = parent;
                int childID = child;
                row.setColumn("parent_id", parentID);
                row.setColumn("child_id", childID);
                DatabaseManager.update(this.myContext, row);
            }
        }
    }

    private Set<Integer> getChildren(Map<Integer, Set<Integer>> parents, Integer parent) {
        HashSet<Integer> myChildren = new HashSet<Integer>();
        if (!parents.containsKey(parent)) {
            return myChildren;
        }
        Set<Integer> children = parents.get(parent);
        for (Integer childID : children) {
            myChildren.add(childID);
            myChildren.addAll(this.getChildren(parents, childID));
        }
        return myChildren;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup() || AuthorizeConfiguration.canCollectionAdminManageSubmitters() || AuthorizeConfiguration.canCollectionAdminManageWorkflows() || AuthorizeConfiguration.canCommunityAdminManageAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters() || AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
            TableRow qResult = DatabaseManager.querySingle(this.myContext, "SELECT collection_id, workflow_step_1, workflow_step_2,  workflow_step_3, submitter, admin FROM collection  WHERE workflow_step_1 = ? OR  workflow_step_2 = ? OR  workflow_step_3 = ? OR  submitter =  ? OR  admin = ?", this.getID(), this.getID(), this.getID(), this.getID(), this.getID());
            if (qResult != null) {
                Collection collection = Collection.find(this.myContext, qResult.getIntColumn("collection_id"));
                if (qResult.getIntColumn("workflow_step_1") == this.getID() || qResult.getIntColumn("workflow_step_2") == this.getID() || qResult.getIntColumn("workflow_step_3") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageWorkflows()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
                        return collection.getParentObject();
                    }
                }
                if (qResult.getIntColumn("submitter") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageSubmitters()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters()) {
                        return collection.getParentObject();
                    }
                }
                if (qResult.getIntColumn("admin") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) {
                        return collection.getParentObject();
                    }
                }
            } else if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup() && (qResult = DatabaseManager.querySingle(this.myContext, "SELECT community_id FROM community WHERE admin = ?", this.getID())) != null) {
                Community community = Community.find(this.myContext, qResult.getIntColumn("community_id"));
                return community;
            }
        }
        return null;
    }
}

