/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class TestConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(TestConsumer.class);
    private static PrintStream out = ConfigurationManager.getBooleanProperty("testConsumer.verbose") ? System.out : null;
    static final DateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS Z");

    public void initialize() throws Exception {
        log.info((Object)"EVENT: called TestConsumer.initialize();");
        if (out != null) {
            out.println("TestConsumer.initialize();");
        }
    }

    public void consume(Context ctx, Event event) throws Exception {
        EPerson ep = ctx.getCurrentUser();
        String user = ep == null ? "(none)" : ep.getEmail();
        String detail = event.getDetail();
        String msg = "EVENT: called TestConsumer.consume(): EventType=" + event.getEventTypeAsString() + ", SubjectType=" + event.getSubjectTypeAsString() + ", SubjectID=" + String.valueOf(event.getSubjectID()) + ", ObjectType=" + event.getObjectTypeAsString() + ", ObjectID=" + String.valueOf(event.getObjectID()) + ", TimeStamp=" + df.format(new Date(event.getTimeStamp())) + ", user=\"" + user + "\"" + ", extraLog=\"" + ctx.getExtraLogInfo() + "\"" + ", dispatcher=" + String.valueOf(event.getDispatcher()) + ", detail=" + (detail == null ? "[null]" : "\"" + detail + "\"") + ", transactionID=" + (event.getTransactionID() == null ? "[null]" : "\"" + event.getTransactionID() + "\"") + ", context=" + ctx.toString();
        log.info((Object)msg);
        if (out != null) {
            out.println("TestConsumer.consume(): " + msg);
        }
    }

    public void end(Context ctx) throws Exception {
        log.info((Object)"EVENT: called TestConsumer.end();");
        if (out != null) {
            out.println("TestConsumer.end();");
        }
    }

    public void finish(Context ctx) throws Exception {
        log.info((Object)"EVENT: called TestConsumer.finish();");
        if (out != null) {
            out.println("TestConsumer.finish();");
        }
    }
}

