/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.util.StreamTable;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class HandlePlugin
implements HandleStorage {
    private static Logger log = Logger.getLogger(HandlePlugin.class);

    public void init(StreamTable st) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called init (not implemented)");
        }
    }

    public void setHaveNA(byte[] theHandle, boolean haveit) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called setHaveNA (not implemented)");
        }
    }

    public void createHandle(byte[] theHandle, HandleValue[] values) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called createHandle (not implemented)");
        }
    }

    public boolean deleteHandle(byte[] theHandle) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called deleteHandle (not implemented)");
        }
        return false;
    }

    public void updateValue(byte[] theHandle, HandleValue[] values) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called updateValue (not implemented)");
        }
    }

    public void deleteAllRecords() throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called deleteAllRecords (not implemented)");
        }
    }

    public void checkpointDatabase() throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called checkpointDatabase (not implemented)");
        }
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called shutdown (not implemented)");
        }
    }

    public void scanHandles(ScanCallback callback) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called scanHandles (not implemented)");
        }
    }

    public void scanNAs(ScanCallback callback) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called scanNAs (not implemented)");
        }
    }

    public byte[][] getRawHandleValues(byte[] theHandle, int[] indexList, byte[][] typeList) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called getRawHandleValues");
        }
        Context context = null;
        try {
            if (theHandle == null) {
                throw new HandleException(1);
            }
            context = new Context();
            String handle = Util.decodeString((byte[])theHandle);
            String url = HandleManager.resolveToURL(context, handle);
            if (url == null) {
                throw new HandleException(9);
            }
            HandleValue value = new HandleValue();
            value.setIndex(100);
            value.setType(Util.encodeString((String)"URL"));
            value.setData(Util.encodeString((String)url));
            value.setTTLType((byte)0);
            value.setTTL(100);
            value.setTimestamp(100);
            value.setReferences(null);
            value.setAdminCanRead(true);
            value.setAdminCanWrite(false);
            value.setAnyoneCanRead(true);
            value.setAnyoneCanWrite(false);
            LinkedList<HandleValue> values = new LinkedList<HandleValue>();
            values.add(value);
            byte[][] rawValues = new byte[values.size()][];
            for (int i = 0; i < values.size(); ++i) {
                HandleValue hvalue = (HandleValue)values.get(i);
                rawValues[i] = new byte[Encoder.calcStorageSize((HandleValue)hvalue)];
                Encoder.encodeHandleValue((byte[])rawValues[i], (int)0, (HandleValue)hvalue);
            }
            byte[][] byArrayArray = rawValues;
            return byArrayArray;
        }
        catch (HandleException he) {
            throw he;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in getRawHandleValues", (Throwable)e);
            }
            throw new HandleException(1);
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public boolean haveNA(byte[] theHandle) throws HandleException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Called haveNA");
        }
        if (ConfigurationManager.getBooleanProperty("handle.plugin.checknameauthority", true)) {
            String expected = "0.NA/" + ConfigurationManager.getProperty("handle.prefix");
            String received = Util.decodeString((byte[])theHandle);
            return expected.equals(received);
        }
        return true;
    }

    public Enumeration getHandlesForNA(byte[] theNAHandle) throws HandleException {
        String naHandle = Util.decodeString((byte[])theNAHandle);
        if (log.isInfoEnabled()) {
            log.info((Object)("Called getHandlesForNA for NA " + naHandle));
        }
        Context context = null;
        try {
            context = new Context();
            List handles = HandleManager.getHandlesForPrefix(context, naHandle);
            LinkedList<byte[]> results = new LinkedList<byte[]>();
            for (String handle : handles) {
                results.add(Util.encodeString((String)handle));
            }
            Enumeration enumeration = Collections.enumeration(results);
            return enumeration;
        }
        catch (SQLException sqle) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in getHandlesForNA", (Throwable)sqle);
            }
            throw new HandleException(1);
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException sqle) {}
            }
        }
    }
}

