/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import ORG.oclc.oai.harvester2.verb.GetRecord;
import ORG.oclc.oai.harvester2.verb.Identify;
import ORG.oclc.oai.harvester2.verb.ListMetadataFormats;
import ORG.oclc.oai.harvester2.verb.ListRecords;
import ORG.oclc.oai.harvester2.verb.ListSets;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestedItem;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAIHarvester {
    private static HarvestScheduler harvester;
    private static Thread mainHarvestThread;
    private static Logger log;
    private static final Namespace ATOM_NS;
    private static final Namespace ORE_NS;
    private static final Namespace OAI_NS;
    public static final String OAI_ADDRESS_ERROR = "invalidAddress";
    public static final String OAI_SET_ERROR = "noSuchSet";
    public static final String OAI_DMD_ERROR = "metadataNotSupported";
    public static final String OAI_ORE_ERROR = "oreNotSupported";
    Collection targetCollection;
    HarvestedCollection harvestRow;
    Context ourContext;
    private Namespace ORESeialNS;
    private String ORESeialKey;
    private Namespace metadataNS;
    private String metadataKey;
    private static DOMBuilder db;
    private Date expirationTime;

    public OAIHarvester(Context c, DSpaceObject dso, HarvestedCollection hc) throws HarvestingException, SQLException {
        if (dso.getType() != 3) {
            throw new HarvestingException("OAIHarvester can only harvest collections");
        }
        this.ourContext = c;
        this.targetCollection = (Collection)dso;
        this.harvestRow = hc;
        if (this.harvestRow == null || !this.harvestRow.isHarvestable()) {
            throw new HarvestingException("Provided collection is not set up for harvesting");
        }
        Namespace ORESerializationNamespace = OAIHarvester.getORENamespace();
        if (ORESerializationNamespace == null) {
            log.error((Object)"No ORE serialization namespace declared; see dspace.cfg option \"harvester.oai.oreSerializationFormat.{ORESeialKey} = {ORESeialNS}\"");
            throw new HarvestingException("No ORE serialization namespace specified");
        }
        this.ORESeialNS = Namespace.getNamespace((String)ORESerializationNamespace.getURI());
        this.ORESeialKey = ORESerializationNamespace.getPrefix();
        this.metadataKey = this.harvestRow.getHarvestMetadataConfig();
        this.metadataNS = OAIHarvester.getDMDNamespace(this.metadataKey);
        if (this.metadataNS == null) {
            log.error((Object)("No matching metadata namespace found for \"" + this.metadataKey + "\", see dspace.cfg option \"harvester.oai.metadataformats.{MetadataKey} = {MetadataNS},{Display Name}\""));
            throw new HarvestingException("Metadata declaration not found");
        }
    }

    private static Namespace getORENamespace() {
        String ORESerializationString = null;
        String ORESeialKey = null;
        String oreString = "harvester.oai.oreSerializationFormat.";
        Enumeration pe = ConfigurationManager.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(oreString)) continue;
            ORESeialKey = key.substring(oreString.length());
            ORESerializationString = ConfigurationManager.getProperty(key);
            Namespace ORENS = Namespace.getNamespace((String)ORESeialKey, (String)ORESerializationString);
            return ORENS;
        }
        return Namespace.getNamespace((String)"ore", (String)ATOM_NS.getURI());
    }

    private static Namespace getDMDNamespace(String metadataKey) {
        String metadataString = null;
        String metaString = "harvester.oai.metadataformats.";
        Enumeration pe = ConfigurationManager.propertyNames();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(metaString) || !key.substring(metaString.length()).equals(metadataKey)) continue;
            metadataString = ConfigurationManager.getProperty(key);
            String namespacePiece = metadataString.indexOf(44) != -1 ? metadataString.substring(0, metadataString.indexOf(44)) : metadataString;
            return Namespace.getNamespace((String)namespacePiece);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHarvest() throws SQLException, IOException, AuthorizeException {
        String oaiSource = this.harvestRow.getOaiSource();
        String oaiSetId = this.harvestRow.getOaiSetId();
        Date lastHarvestDate = this.harvestRow.getHarvestDate();
        String fromDate = null;
        if (lastHarvestDate != null) {
            fromDate = this.processDate(this.harvestRow.getHarvestDate());
        }
        Date startTime = new Date();
        String toDate = this.processDate(startTime, 0);
        try {
            String OREPrefix;
            String descMDPrefix = null;
            try {
                String dateGranularity = this.OAIGetDateGranularity(oaiSource);
                if (fromDate != null) {
                    fromDate = fromDate.substring(0, dateGranularity.length());
                }
                toDate = toDate.substring(0, dateGranularity.length());
                descMDPrefix = OAIHarvester.OAIResolveNamespaceToPrefix(oaiSource, this.metadataNS.getURI());
                OREPrefix = OAIHarvester.OAIResolveNamespaceToPrefix(oaiSource, this.ORESeialNS.getURI());
            }
            catch (FileNotFoundException fe) {
                log.error((Object)"The OAI server did not respond.");
                throw new HarvestingException("The OAI server did not respond.");
            }
            catch (ConnectException fe) {
                log.error((Object)"The OAI server did not respond.");
                throw new HarvestingException("The OAI server did not respond.");
            }
            if (descMDPrefix == null) {
                log.error((Object)"The OAI server does not support this metadata format");
                throw new HarvestingException("The OAI server does not support this metadata format: " + this.metadataNS.getURI());
            }
            if (OREPrefix == null && this.harvestRow.getHarvestType() != 1) {
                throw new HarvestingException("The OAI server does not support ORE dissemination in the configured serialization format: " + this.ORESeialNS.getURI());
            }
            Document oaiResponse = null;
            Element root = null;
            this.harvestRow.setHarvestStatus(1);
            this.harvestRow.setHarvestMessage("Collection is currently being harvested");
            this.harvestRow.setHarvestStartTime(startTime);
            this.harvestRow.update();
            this.ourContext.commit();
            int expirationInterval = ConfigurationManager.getIntProperty("harvester.threadTimeout");
            if (expirationInterval == 0) {
                expirationInterval = 24;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(10, expirationInterval);
            this.expirationTime = calendar.getTime();
            HashSet<String> errorSet = new HashSet<String>();
            Object listRecords = new ListRecords(oaiSource, fromDate, toDate, oaiSetId, descMDPrefix);
            log.debug((Object)("Harvesting request parameters: listRecords " + oaiSource + " " + fromDate + " " + toDate + " " + oaiSetId + " " + descMDPrefix));
            if (listRecords != null) {
                log.info((Object)("HTTP Request: " + listRecords.getRequestURL()));
            }
            while (listRecords != null) {
                String resumptionToken;
                ArrayList records = new ArrayList();
                oaiResponse = db.build(listRecords.getDocument());
                if (listRecords.getErrors() != null && listRecords.getErrors().getLength() > 0) {
                    for (int i = 0; i < listRecords.getErrors().getLength(); ++i) {
                        String errorCode = listRecords.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                        errorSet.add(errorCode);
                    }
                    if (errorSet.contains("noRecordsMatch")) {
                        log.info((Object)"noRecordsMatch: OAI server did not contain any updates");
                        this.harvestRow.setHarvestResult(new Date(), "OAI server did not contain any updates");
                        this.harvestRow.setHarvestStatus(0);
                        this.harvestRow.update();
                        return;
                    }
                    throw new HarvestingException(((Object)errorSet).toString());
                }
                root = oaiResponse.getRootElement();
                records.addAll(root.getChild("ListRecords", OAI_NS).getChildren("record", OAI_NS));
                if (records != null && records.size() > 0) {
                    log.info((Object)("Found " + records.size() + " records to process"));
                    for (Element record : records) {
                        if (HarvestScheduler.interrupt == 2) {
                            throw new HarvestingException("Harvest process for " + this.targetCollection.getID() + " interrupted by stopping the scheduler.");
                        }
                        if (this.expirationTime.before(new Date())) {
                            throw new HarvestingException("runHarvest method timed out for collection " + this.targetCollection.getID());
                        }
                        this.processRecord(record, OREPrefix);
                        this.ourContext.commit();
                    }
                }
                listRecords = (resumptionToken = listRecords.getResumptionToken()) == null || resumptionToken.length() == 0 ? null : new ListRecords(oaiSource, resumptionToken);
                this.targetCollection.update();
                this.ourContext.commit();
            }
        }
        catch (HarvestingException hex) {
            log.error((Object)("Harvesting error occured while processing an OAI record: " + hex.getMessage()));
            this.harvestRow.setHarvestMessage("Error occured while processing an OAI record");
            if (this.harvestRow.getHarvestMessage().contains("Error")) {
                this.alertAdmin(3, hex);
            }
            this.harvestRow.setHarvestStatus(3);
            return;
        }
        catch (Exception ex) {
            this.harvestRow.setHarvestMessage("Unknown error occured while generating an OAI response");
            this.harvestRow.setHarvestStatus(-1);
            this.alertAdmin(-1, ex);
            log.error((Object)("Error occured while generating an OAI response: " + ex.getMessage() + " " + ex.getCause()));
            ex.printStackTrace();
            return;
        }
        finally {
            this.harvestRow.update();
            this.targetCollection.update();
            this.ourContext.commit();
            this.ourContext.restoreAuthSystemState();
        }
        Date finishTime = new Date();
        long timeTaken = finishTime.getTime() - startTime.getTime();
        this.harvestRow.setHarvestResult(startTime, "Harvest from " + oaiSource + " sucessful");
        this.harvestRow.setHarvestStatus(0);
        log.info((Object)("Harvest from " + oaiSource + " sucessful. The process took " + timeTaken + " milliseconds."));
        this.harvestRow.update();
        this.ourContext.commit();
    }

    private void processRecord(Element record, String OREPrefix) throws SQLException, AuthorizeException, IOException, CrosswalkException, HarvestingException, ParserConfigurationException, SAXException, TransformerException {
        HarvestedItem hi;
        WorkspaceItem wi = null;
        Date timeStart = new Date();
        String itemOaiID = record.getChild("header", OAI_NS).getChild("identifier", OAI_NS).getText();
        Element header = record.getChild("header", OAI_NS);
        Item item = HarvestedItem.getItemByOAIId(this.ourContext, itemOaiID, this.targetCollection.getID());
        if (header.getAttribute("status") != null && header.getAttribute("status").getValue().equals("deleted")) {
            log.info((Object)("Item " + itemOaiID + " has been marked as deleted on the OAI server."));
            if (item != null) {
                this.targetCollection.removeItem(item);
            }
            this.ourContext.restoreAuthSystemState();
            return;
        }
        List descMD = record.getChild("metadata", OAI_NS).getChildren();
        IngestionCrosswalk MDxwalk = (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, this.metadataKey);
        IngestionCrosswalk ORExwalk = null;
        Element oreREM = null;
        if (this.harvestRow.getHarvestType() > 1) {
            oreREM = this.getMDrecord(this.harvestRow.getOaiSource(), itemOaiID, OREPrefix).get(0);
            ORExwalk = (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, this.ORESeialKey);
        }
        this.ourContext.turnOffAuthorisationSystem();
        if (item != null) {
            log.debug((Object)("Item " + item.getHandle() + " was found locally. Using it to harvest " + itemOaiID + "."));
            hi = HarvestedItem.find(this.ourContext, item.getID());
            Date OAIDatestamp = Utils.parseISO8601Date(header.getChildText("datestamp", OAI_NS));
            Date itemLastHarvest = hi.getHarvestDate();
            if (itemLastHarvest != null && OAIDatestamp.before(itemLastHarvest)) {
                log.info((Object)("Item " + item.getHandle() + " was harvested more recently than the last update time reporetd by the OAI server; skipping."));
                return;
            }
            item.clearMetadata("*", "*", "*", "*");
            if (descMD.size() == 1) {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, (Element)descMD.get(0));
            } else {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, descMD);
            }
            if (this.harvestRow.getHarvestType() == 3) {
                Bundle[] allBundles;
                log.info((Object)("Running ORE ingest on: " + item.getHandle()));
                for (Bundle bundle : allBundles = item.getBundles()) {
                    item.removeBundle(bundle);
                }
                ORExwalk.ingest(this.ourContext, (DSpaceObject)item, oreREM);
            }
            this.scrubMetadata(item);
        } else {
            DSpaceObject dso;
            wi = WorkspaceItem.create(this.ourContext, this.targetCollection, false);
            item = wi.getItem();
            hi = HarvestedItem.create(this.ourContext, item.getID(), itemOaiID);
            if (descMD.size() == 1) {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, (Element)descMD.get(0));
            } else {
                MDxwalk.ingest(this.ourContext, (DSpaceObject)item, descMD);
            }
            if (this.harvestRow.getHarvestType() == 3) {
                ORExwalk.ingest(this.ourContext, (DSpaceObject)item, oreREM);
            }
            this.scrubMetadata(item);
            String handle = this.extractHandle(item);
            if (handle != null && (dso = HandleManager.resolveToObject(this.ourContext, handle)) != null) {
                throw new HarvestingException("Handle collision: attempted to re-assign handle '" + handle + "' to an incoming harvested item '" + hi.getOaiID() + "'.");
            }
            try {
                item = InstallItem.installItem(this.ourContext, wi, handle);
            }
            catch (SQLException se) {
                wi.deleteWrapper();
                throw se;
            }
            catch (IOException ioe) {
                wi.deleteWrapper();
                throw ioe;
            }
            catch (AuthorizeException ae) {
                wi.deleteWrapper();
                throw ae;
            }
        }
        if (this.harvestRow.getHarvestType() == 2 || this.harvestRow.getHarvestType() == 3) {
            Bundle OREBundle = item.createBundle("ORE");
            XMLOutputter outputter = new XMLOutputter();
            String OREString = outputter.outputString(oreREM);
            ByteArrayInputStream OREStream = new ByteArrayInputStream(OREString.getBytes());
            Bitstream OREBitstream = OREBundle.createBitstream(OREStream);
            OREBitstream.setName("ORE.xml");
            BitstreamFormat bf = FormatIdentifier.guessFormat(this.ourContext, OREBitstream);
            OREBitstream.setFormat(bf);
            OREBitstream.update();
            OREBundle.addBitstream(OREBitstream);
            OREBundle.update();
        }
        hi.setHarvestDate(new Date());
        item.update();
        hi.update();
        long timeTaken = new Date().getTime() - timeStart.getTime();
        log.info((Object)("Item " + item.getHandle() + "(" + item.getID() + ")" + " has been ingested. The whole process took: " + timeTaken + " ms. "));
        this.ourContext.restoreAuthSystemState();
    }

    private String extractHandle(Item item) {
        DCValue[] values;
        String rejectedHandlePrefixString;
        String acceptedHandleServersString = ConfigurationManager.getProperty("harvester.acceptedHandleServer");
        if (acceptedHandleServersString == null) {
            acceptedHandleServersString = "hdl.handle.net";
        }
        if ((rejectedHandlePrefixString = ConfigurationManager.getProperty("harvester.rejectedHandlePrefix")) == null) {
            rejectedHandlePrefixString = "123456789";
        }
        if ((values = item.getMetadata("dc", "identifier", "*", "*")).length > 0 && !acceptedHandleServersString.equals("")) {
            String[] acceptedHandleServers = acceptedHandleServersString.split(",");
            String[] rejectedHandlePrefixes = rejectedHandlePrefixString.split(",");
            for (DCValue value : values) {
                String[] urlPieces = value.value.split("/");
                if (urlPieces.length != 5) continue;
                for (String server : acceptedHandleServers) {
                    if (!urlPieces[2].equals(server)) continue;
                    for (String prefix : rejectedHandlePrefixes) {
                        if (urlPieces[3].equals(prefix)) continue;
                        return urlPieces[3] + "/" + urlPieces[4];
                    }
                }
            }
        }
        return null;
    }

    private void scrubMetadata(Item item) throws SQLException, HarvestingException, AuthorizeException, IOException {
        DCValue[] values;
        String fieldChoice;
        String schemaChoice = ConfigurationManager.getProperty("harvester.unknownSchema");
        if (schemaChoice == null) {
            schemaChoice = "fail";
        }
        if ((fieldChoice = ConfigurationManager.getProperty("harvester.unknownField")) == null) {
            fieldChoice = "fail";
        }
        ArrayList<String> clearList = new ArrayList<String>();
        for (DCValue value : values = item.getMetadata("*", "*", "*", "*")) {
            MetadataField mdField;
            MetadataSchema mdSchema = MetadataSchema.find(this.ourContext, value.schema);
            if (mdSchema == null && !clearList.contains(value.schema)) {
                if (schemaChoice.equals("add")) {
                    mdSchema = new MetadataSchema(value.schema, String.valueOf(new Date().getTime()));
                    try {
                        mdSchema.create(this.ourContext);
                        mdSchema.setName(value.schema);
                        mdSchema.setNamespace("unknown" + mdSchema.getSchemaID());
                        mdSchema.update(this.ourContext);
                    }
                    catch (NonUniqueMetadataException e) {
                        e.printStackTrace();
                    }
                    clearList.add(value.schema);
                } else {
                    if (schemaChoice.equals("ignore")) {
                        item.clearMetadata(value.schema, "*", "*", "*");
                        continue;
                    }
                    throw new HarvestingException("The '" + value.schema + "' schema has not been defined in this DSpace instance. ");
                }
            }
            if ((mdField = MetadataField.findByElement(this.ourContext, mdSchema.getSchemaID(), value.element, value.qualifier)) != null) continue;
            if (fieldChoice.equals("add")) {
                mdField = new MetadataField(mdSchema, value.element, value.qualifier, null);
                try {
                    mdField.create(this.ourContext);
                    mdField.update(this.ourContext);
                }
                catch (NonUniqueMetadataException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (fieldChoice.equals("ignore")) {
                item.clearMetadata(value.schema, value.element, value.qualifier, "*");
                continue;
            }
            throw new HarvestingException("The '" + value.element + "." + value.qualifier + "' element has not been defined in this DSpace instance. ");
        }
    }

    private String processDate(Date date) {
        Integer timePad = ConfigurationManager.getIntProperty("harvester.timePadding");
        if (timePad == 0) {
            timePad = 120;
        }
        return this.processDate(date, timePad);
    }

    private String processDate(Date date, int secondsPad) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, -1 * secondsPad);
        date = calendar.getTime();
        return formatter.format(date);
    }

    private String OAIGetDateGranularity(String oaiSource) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        Identify iden = new Identify(oaiSource);
        return iden.getDocument().getElementsByTagNameNS(OAI_NS.getURI(), "granularity").item(0).getTextContent();
    }

    public static String OAIResolveNamespaceToPrefix(String oaiSource, String MDNamespace) throws IOException, ParserConfigurationException, SAXException, TransformerException, ConnectException {
        String metaPrefix = null;
        ListMetadataFormats lmf = new ListMetadataFormats(oaiSource);
        if (lmf != null) {
            Document lmfResponse = db.build(lmf.getDocument());
            List mdFormats = lmfResponse.getRootElement().getChild("ListMetadataFormats", OAI_NS).getChildren("metadataFormat", OAI_NS);
            for (Element mdFormat : mdFormats) {
                if (!MDNamespace.equals(mdFormat.getChildText("metadataNamespace", OAI_NS))) continue;
                metaPrefix = mdFormat.getChildText("metadataPrefix", OAI_NS);
                break;
            }
        }
        return metaPrefix;
    }

    private void alertAdmin(int status, Exception ex) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (recipient != null) {
                String stackTrace;
                Email email = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "harvesting_error"));
                email.addRecipient(recipient);
                email.addArgument(this.targetCollection.getID());
                email.addArgument(new Date());
                email.addArgument(status);
                email.addArgument(ex.getMessage());
                if (ex != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    private List<Element> getMDrecord(String oaiSource, String itemOaiId, String metadataPrefix) throws IOException, ParserConfigurationException, SAXException, TransformerException, HarvestingException {
        GetRecord getRecord = new GetRecord(oaiSource, itemOaiId, metadataPrefix);
        HashSet<String> errorSet = new HashSet<String>();
        if (getRecord != null && getRecord.getErrors() != null && getRecord.getErrors().getLength() > 0) {
            for (int i = 0; i < getRecord.getErrors().getLength(); ++i) {
                String errorCode = getRecord.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                errorSet.add(errorCode);
            }
            throw new HarvestingException("OAI server returned the following errors during getDescMD execution: " + ((Object)errorSet).toString());
        }
        Document record = db.build(getRecord.getDocument());
        Element root = record.getRootElement();
        return root.getChild("GetRecord", OAI_NS).getChild("record", OAI_NS).getChild("metadata", OAI_NS).getChildren();
    }

    public List<String> verifyOAIharvester() {
        String oaiSource = this.harvestRow.getOaiSource();
        String oaiSetId = this.harvestRow.getOaiSetId();
        String metaPrefix = this.harvestRow.getHarvestMetadataConfig();
        return OAIHarvester.verifyOAIharvester(oaiSource, oaiSetId, metaPrefix, true);
    }

    public static List<String> verifyOAIharvester(String oaiSource, String oaiSetId, String metaPrefix, boolean testORE) {
        ArrayList<String> errorSet = new ArrayList<String>();
        Namespace ORE_NS = OAIHarvester.getORENamespace();
        String OREOAIPrefix = null;
        Namespace DMD_NS = OAIHarvester.getDMDNamespace(metaPrefix);
        String DMDOAIPrefix = null;
        try {
            Identify idenTest = new Identify(oaiSource);
        }
        catch (Exception ex) {
            errorSet.add("invalidAddress: OAI server could not be reached.");
            return errorSet;
        }
        try {
            OREOAIPrefix = OAIHarvester.OAIResolveNamespaceToPrefix(oaiSource, ORE_NS.getURI());
            DMDOAIPrefix = OAIHarvester.OAIResolveNamespaceToPrefix(oaiSource, DMD_NS.getURI());
        }
        catch (Exception ex) {
            errorSet.add("invalidAddress: OAI did not respond to ListMetadataFormats query  (" + ORE_NS.getPrefix() + ":" + OREOAIPrefix + " ; " + DMD_NS.getPrefix() + ":" + DMDOAIPrefix + ")");
            return errorSet;
        }
        if (testORE && OREOAIPrefix == null) {
            errorSet.add("oreNotSupported: The OAI server does not support ORE dissemination");
        }
        if (DMDOAIPrefix == null) {
            errorSet.add("metadataNotSupported: The OAI server does not support dissemination in this format");
        }
        boolean foundSet = false;
        try {
            ListSets ls = new ListSets(oaiSource);
            if (ls.getErrors() != null && ls.getErrors().getLength() > 0) {
                for (int i = 0; i < ls.getErrors().getLength(); ++i) {
                    String errorCode = ls.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                    errorSet.add(errorCode);
                }
            } else {
                Document reply = db.build(ls.getDocument());
                Element root = reply.getRootElement();
                List sets = root.getChild("ListSets", OAI_NS).getChildren("set", OAI_NS);
                for (Element set : sets) {
                    String setSpec = set.getChildText("setSpec", OAI_NS);
                    if (!setSpec.equals(oaiSetId)) continue;
                    foundSet = true;
                    break;
                }
                if (!foundSet) {
                    errorSet.add("noSuchSet: The OAI server does not have a set with the specified setSpec");
                }
            }
        }
        catch (Exception ex) {
            errorSet.add("invalidAddress: OAI server could not be reached");
            return errorSet;
        }
        return errorSet;
    }

    public static void startNewScheduler() throws SQLException, AuthorizeException {
        Context c = new Context();
        HarvestedCollection.exists(c);
        c.complete();
        if (mainHarvestThread != null && harvester != null) {
            OAIHarvester.stopScheduler();
        }
        harvester = new HarvestScheduler();
        HarvestScheduler.interrupt = 0;
        mainHarvestThread = new Thread(harvester);
        mainHarvestThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopScheduler() throws SQLException, AuthorizeException {
        Object object = HarvestScheduler.lock;
        synchronized (object) {
            HarvestScheduler.interrupt = 2;
            HarvestScheduler.lock.notify();
        }
        mainHarvestThread = null;
        harvester = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseScheduler() throws SQLException, AuthorizeException {
        Object object = HarvestScheduler.lock;
        synchronized (object) {
            HarvestScheduler.interrupt = 1;
            HarvestScheduler.lock.notify();
        }
    }

    public static void resumeScheduler() throws SQLException, AuthorizeException {
        HarvestScheduler.interrupt = 3;
    }

    public static void resetScheduler() throws SQLException, AuthorizeException, IOException {
        Context context = new Context();
        List<Integer> cids = HarvestedCollection.findAll(context);
        for (Integer cid : cids) {
            HarvestedCollection hc = HarvestedCollection.find(context, cid);
            hc.setHarvestStartTime(null);
            hc.setHarvestStatus(0);
            hc.update();
        }
        context.commit();
    }

    static {
        log = Logger.getLogger(OAIHarvester.class);
        ATOM_NS = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
        ORE_NS = Namespace.getNamespace((String)"http://www.openarchives.org/ore/terms/");
        OAI_NS = Namespace.getNamespace((String)"http://www.openarchives.org/OAI/2.0/");
        db = new DOMBuilder();
    }

    private static class HarvestThread
    extends Thread {
        Context context;
        HarvestedCollection hc;

        HarvestThread(Context context, HarvestedCollection hc) throws SQLException {
            this.context = context;
            this.hc = hc;
        }

        public void run() {
            log.info((Object)("Thread for collection " + this.hc.getCollectionId() + " starts."));
            this.runHarvest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runHarvest() {
            Collection dso = null;
            try {
                dso = Collection.find(this.context, this.hc.getCollectionId());
                OAIHarvester harvester = new OAIHarvester(this.context, dso, this.hc);
                harvester.runHarvest();
            }
            catch (Exception ex) {
                log.error((Object)("General exception in thread: " + this.toString()));
                log.error((Object)(ex.getMessage() + " " + ex.getCause()));
                this.hc.setHarvestMessage("Error occured while generating an OAI response");
                this.hc.setHarvestStatus(-1);
            }
            catch (Throwable t) {
                log.error((Object)("Runtime exception in thread: " + this.toString()));
                log.error((Object)(t.getMessage() + " " + t.getCause()));
                this.hc.setHarvestMessage("Runtime error occured while generating an OAI response");
                this.hc.setHarvestStatus(-1);
            }
            finally {
                try {
                    this.hc.update();
                    this.context.restoreAuthSystemState();
                    this.context.complete();
                }
                catch (Throwable t) {
                    log.error((Object)("Unexpected exception while recovering from a harvesting error: " + t.getMessage()));
                    t.printStackTrace();
                    this.context.abort();
                }
                Integer t = HarvestScheduler.activeThreads;
                synchronized (t) {
                    Integer n = HarvestScheduler.activeThreads;
                    Integer n2 = HarvestScheduler.activeThreads = Integer.valueOf(HarvestScheduler.activeThreads - 1);
                }
            }
            log.info((Object)("Thread for collection " + this.hc.getCollectionId() + " completes."));
        }
    }

    public static class HarvestScheduler
    implements Runnable {
        static EPerson harvestAdmin;
        static Context mainContext;
        public static Object lock;
        private static Stack<HarvestThread> harvestThreads;
        private static Integer maxActiveThreads;
        protected static volatile Integer activeThreads;
        public static final int HARVESTER_STATUS_RUNNING = 1;
        public static final int HARVESTER_STATUS_SLEEPING = 2;
        public static final int HARVESTER_STATUS_PAUSED = 3;
        public static final int HARVESTER_STATUS_STOPPED = 4;
        public static final int HARVESTER_INTERRUPT_NONE = 0;
        public static final int HARVESTER_INTERRUPT_PAUSE = 1;
        public static final int HARVESTER_INTERRUPT_STOP = 2;
        public static final int HARVESTER_INTERRUPT_RESUME = 3;
        public static final int HARVESTER_INTERRUPT_INSERT_THREAD = 4;
        public static final int HARVESTER_INTERRUPT_KILL_THREAD = 5;
        public static Integer status;
        public static Integer interrupt;
        public static Integer interruptValue;
        private static long minHeartbeat;
        private static long maxHeartbeat;

        public static String getStatus() {
            switch (status) {
                case 1: {
                    switch (interrupt) {
                        case 1: {
                            return "The scheduler is finishing active harvests before pausing. ";
                        }
                        case 2: {
                            return "The scheduler is shutting down. ";
                        }
                    }
                    return "The scheduler is actively harvesting collections. ";
                }
                case 2: {
                    return "The scheduler is waiting for collections to harvest. ";
                }
                case 3: {
                    return "The scheduler is paused. ";
                }
            }
            return "Automatic harvesting is not active. ";
        }

        public HarvestScheduler() throws SQLException, AuthorizeException {
            mainContext = new Context();
            String harvestAdminParam = ConfigurationManager.getProperty("harvester.eperson");
            harvestAdmin = null;
            if (harvestAdminParam != null && harvestAdminParam.length() > 0) {
                harvestAdmin = EPerson.findByEmail(mainContext, harvestAdminParam);
            }
            harvestThreads = new Stack();
            maxActiveThreads = ConfigurationManager.getIntProperty("harvester.maxThreads");
            if (maxActiveThreads == 0) {
                maxActiveThreads = 3;
            }
            if ((minHeartbeat = (long)(ConfigurationManager.getIntProperty("harvester.minHeartbeat") * 1000)) == 0L) {
                minHeartbeat = 30000L;
            }
            if ((maxHeartbeat = (long)(ConfigurationManager.getIntProperty("harvester.maxHeartbeat") * 1000)) == 0L) {
                maxHeartbeat = 3600000L;
            }
        }

        public void run() {
            this.scheduleLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleLoop() {
            long i = 0L;
            while (true) {
                try {
                    Integer n = interrupt;
                    synchronized (n) {
                        switch (interrupt) {
                            case 0: {
                                break;
                            }
                            case 4: {
                                interrupt = 0;
                                HarvestScheduler.addThread(interruptValue);
                                interruptValue = 0;
                                break;
                            }
                            case 1: {
                                interrupt = 0;
                                Integer n2 = status;
                                synchronized (n2) {
                                    status = 3;
                                }
                                while (interrupt != 3 && interrupt != 2) {
                                    Thread.sleep(1000L);
                                }
                                if (interrupt != 2) break;
                            }
                            case 2: {
                                interrupt = 0;
                                status = 4;
                                return;
                            }
                        }
                    }
                    status = 1;
                    mainContext = new Context();
                    List<Integer> cids = HarvestedCollection.findReady(mainContext);
                    log.info((Object)("Collections ready for immediate harvest: " + cids.toString()));
                    for (Integer cid : cids) {
                        HarvestScheduler.addThread(cid);
                    }
                    while (!harvestThreads.isEmpty()) {
                        Integer i$ = activeThreads;
                        synchronized (i$) {
                            Integer cid;
                            cid = activeThreads;
                            Integer n3 = activeThreads = Integer.valueOf(activeThreads + 1);
                        }
                        Thread activeThread = new Thread(harvestThreads.pop());
                        activeThread.start();
                        log.info((Object)("Thread started: " + activeThread.toString()));
                        while (activeThreads >= maxActiveThreads) {
                            Thread.sleep(1000L);
                        }
                    }
                    while (activeThreads != 0) {
                        Thread.sleep(1000L);
                    }
                    try {
                        mainContext.commit();
                        mainContext.complete();
                        log.info((Object)("Done with iteration " + i));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        mainContext.abort();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception on iteration: " + i));
                    e.printStackTrace();
                }
                try {
                    Context tempContext = new Context();
                    int nextCollectionId = HarvestedCollection.findOldestHarvest(tempContext);
                    HarvestedCollection hc = HarvestedCollection.find(tempContext, nextCollectionId);
                    int harvestInterval = ConfigurationManager.getIntProperty("harvester.harvestFrequency");
                    if (harvestInterval == 0) {
                        harvestInterval = 720;
                    }
                    long nextHarvest = 0L;
                    if (hc != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(hc.getHarvestDate());
                        calendar.add(12, harvestInterval);
                        Date nextTime = calendar.getTime();
                        nextHarvest = nextTime.getTime() + -new Date().getTime();
                    }
                    long upperBound = Math.min(nextHarvest, maxHeartbeat);
                    long delay = Math.max(upperBound, minHeartbeat) + 1000L;
                    tempContext.complete();
                    status = 2;
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(delay);
                    }
                }
                catch (InterruptedException ie) {
                    log.warn((Object)("Interrupt: " + ie.getMessage()));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        public static void addThread(int collecionID) throws SQLException, IOException, AuthorizeException {
            log.debug((Object)("****** Entered the addThread method. Active threads: " + harvestThreads.toString()));
            Context subContext = new Context();
            HarvestedCollection hc = HarvestedCollection.find(subContext, collecionID);
            hc.setHarvestStatus(2);
            hc.update();
            subContext.commit();
            HarvestThread ht = new HarvestThread(subContext, hc);
            harvestThreads.push(ht);
            log.debug((Object)("****** Queued up a thread. Active threads: " + harvestThreads.toString()));
            log.info((Object)("Thread queued up: " + ht.toString()));
        }

        static {
            lock = new Object();
            activeThreads = 0;
            status = 4;
            interrupt = 0;
            interruptValue = 0;
        }
    }

    public class HarvestingException
    extends Exception {
        public HarvestingException() {
        }

        public HarvestingException(String message, Throwable t) {
            super(message, t);
        }

        public HarvestingException(String message) {
            super(message);
        }

        public HarvestingException(Throwable t) {
            super(t);
        }
    }
}

