/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSpaceCSV {
    private ArrayList<String> headings;
    private ArrayList<DSpaceCSVLine> lines;
    private int counter;
    protected static String valueSeparator;
    protected static String escpaedValueSeparator;
    protected static String fieldSeparator;
    protected static String escapedFieldSeparator;
    private boolean exportAll;
    private Hashtable ignore;

    public DSpaceCSV(boolean exportAll) {
        this.init();
        this.exportAll = exportAll;
    }

    public DSpaceCSV(File f) throws Exception {
        String line;
        String[] headingElements;
        this.init();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
        String head = input.readLine();
        for (String element : headingElements = head.split(escapedFieldSeparator)) {
            if (element.startsWith("\"") && element.endsWith("\"")) {
                element = element.substring(1, element.length() - 1);
            }
            if ("id".equals(element)) continue;
            this.headings.add(element);
        }
        while ((line = input.readLine()) != null) {
            while ((" " + line + " ").split("\"").length % 2 == 0) {
                line = line + "\n" + input.readLine();
            }
            this.addItem(line);
        }
    }

    private void init() {
        String[] toIgnoreArray;
        this.setValueSeparator();
        this.setFieldSeparator();
        this.headings = new ArrayList();
        this.lines = new ArrayList();
        this.counter = 0;
        this.ignore = new Hashtable();
        String toIgnore = ConfigurationManager.getProperty("bulkedit.ignore-on-export");
        if (toIgnore == null || "".equals(toIgnore.trim())) {
            toIgnore = "dc.date.accession, dc.date.available, dc.description.provenance";
        }
        for (String toIgnoreString : toIgnoreArray = toIgnore.split(",")) {
            if ("".equals(toIgnoreString.trim())) continue;
            this.ignore.put(toIgnoreString.trim(), toIgnoreString.trim());
        }
    }

    private void setValueSeparator() {
        valueSeparator = ConfigurationManager.getProperty("bulkedit.valueseparator");
        valueSeparator = valueSeparator != null && !"".equals(valueSeparator.trim()) ? valueSeparator.trim() : "||";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(valueSeparator);
        escpaedValueSeparator = match.replaceAll("\\\\$1");
    }

    private void setFieldSeparator() {
        fieldSeparator = ConfigurationManager.getProperty("bulkedit.fieldseparator");
        fieldSeparator = fieldSeparator != null && !"".equals(fieldSeparator.trim()) ? ("tab".equals(fieldSeparator = fieldSeparator.trim()) ? "\t" : ("semicolon".equals(fieldSeparator) ? ";" : ("hash".equals(fieldSeparator) ? "#" : fieldSeparator.trim()))) : ",";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(fieldSeparator);
        escapedFieldSeparator = match.replaceAll("\\\\$1");
    }

    public void addItem(Item i) throws Exception {
        DCValue[] md;
        Collection[] collections;
        DSpaceCSVLine line = new DSpaceCSVLine(i.getID());
        for (Collection c : collections = i.getCollections()) {
            line.add("collection", c.getHandle());
        }
        for (DCValue value : md = i.getMetadata("*", "*", "*", "*")) {
            String key = value.schema + "." + value.element;
            if (value.qualifier != null) {
                key = key + "." + value.qualifier;
            }
            if (value.language != null) {
                key = key + "[" + value.language + "]";
            }
            if (!this.exportAll && !this.okToExport(value)) continue;
            line.add(key, value.value);
            if (this.headings.contains(key)) continue;
            this.headings.add(key);
        }
        this.lines.add(line);
        ++this.counter;
    }

    public void addItem(String line) throws Exception {
        DSpaceCSVLine csvLine;
        boolean last = false;
        if (line.endsWith(fieldSeparator)) {
            last = true;
            line = line + " ";
        }
        String[] parts = line.split(escapedFieldSeparator);
        ArrayList<String> bits = new ArrayList<String>();
        bits.addAll(Arrays.asList(parts));
        boolean alldone = false;
        while (!alldone) {
            boolean found = false;
            int i = 0;
            for (String part : bits) {
                int bitcounter = part.length() - part.replaceAll("\"", "").length();
                if (part.startsWith("\"") && (!part.endsWith("\"") || bitcounter % 2 == 1)) {
                    found = true;
                    String add = (String)bits.get(i) + fieldSeparator + (String)bits.get(i + 1);
                    bits.remove(i);
                    bits.add(i, add);
                    bits.remove(i + 1);
                    break;
                }
                ++i;
            }
            alldone = !found;
        }
        int i = 0;
        for (String part : bits) {
            if (part.startsWith("\"") && part.endsWith("\"")) {
                part = part.substring(1, part.length() - 1);
                bits.set(i, part);
            }
            ++i;
        }
        i = 0;
        for (String part : bits) {
            if (part.contains("\"\"")) {
                part = part.replaceAll("\"\"", "\"");
                bits.set(i, part);
            }
            ++i;
        }
        String id = parts[0].replaceAll("\"", "");
        if ("+".equals(id)) {
            csvLine = new DSpaceCSVLine();
        } else {
            try {
                csvLine = new DSpaceCSVLine(Integer.parseInt(id));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid item identifier: " + id);
                System.err.println("Please check your CSV file for informaton. Item id must be numeric, or a '+' to add a new item");
                throw nfe;
            }
        }
        i = 0;
        for (String part : bits) {
            if (i > 0) {
                String[] elements;
                if (last && i == this.headings.size()) {
                    part = "";
                }
                csvLine.add(this.headings.get(i - 1), null);
                for (String element : elements = part.split(escpaedValueSeparator)) {
                    if (element == null || "".equals(element)) continue;
                    csvLine.add(this.headings.get(i - 1), element);
                }
            }
            ++i;
        }
        this.lines.add(csvLine);
        ++this.counter;
    }

    public ArrayList<DSpaceCSVLine> getCSVLines() {
        return this.lines;
    }

    public String[] getCSVLinesAsStringArray() {
        String[] csvLines = new String[this.counter + 1];
        csvLines[0] = "id" + fieldSeparator + "collection";
        Collections.sort(this.headings);
        for (String value : this.headings) {
            csvLines[0] = csvLines[0] + fieldSeparator + value;
        }
        Iterator<DSpaceCSVLine> i = this.lines.iterator();
        int c = 1;
        while (i.hasNext()) {
            csvLines[c++] = i.next().toCSV(this.headings);
        }
        return csvLines;
    }

    public void save(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
        for (String csvLine : this.getCSVLinesAsStringArray()) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
    }

    private boolean okToExport(DCValue md) {
        if (!"dc".equals(md.schema)) {
            return true;
        }
        String key = md.schema + "." + md.element;
        if (md.qualifier != null) {
            key = key + "." + md.qualifier;
        }
        return this.ignore.get(key) == null;
    }

    public String toString() {
        String[] lines;
        StringBuffer csvLines = new StringBuffer();
        for (String line : lines = this.getCSVLinesAsStringArray()) {
            csvLines.append(line).append("\n");
        }
        return csvLines.toString();
    }

    public static void main(String[] args) throws Exception {
        String[] lines;
        String[] csv = new String[]{"id,\"dc.title\",dc.contributor.author,dc.description.abstract", "1,Easy line,\"Lewis, Stuart\",A nice short abstract", "2,Two authors,\"Lewis, Stuart||Bloggs, Joe\",Two people wrote this item", "3,Three authors,\"Lewis, Stuart||Bloggs, Joe||Loaf, Meat\",Three people wrote this item", "4,\"Two line\ntitle\",\"Lewis, Stuart\",abstract", "5,\"\"\"Embedded quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\"", "6,\"\"\"Unbalanced embedded\"\" quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\""};
        String filename = "test.csv";
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
        for (String csvLine : csv) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
        System.gc();
        DSpaceCSV dcsv = new DSpaceCSV(new File(filename));
        for (String line : lines = dcsv.getCSVLinesAsStringArray()) {
            System.out.println(line);
        }
        File toDelete = new File(filename);
        toDelete.delete();
    }
}

