/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Authentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(X509Authentication.class);
    private static PublicKey caPublicKey = null;
    private static KeyStore caCertKeyStore = null;
    private static String loginPageTitle = null;
    private static String loginPageURL = null;

    private static String getEmail(X509Certificate certificate) throws SQLException {
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            return null;
        }
        String dn = principal.getName();
        if (dn == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            int len = "emailaddress=".length();
            token = tokenizer.nextToken();
            if (!token.toLowerCase().startsWith("emailaddress=")) continue;
            if (token.length() <= len) {
                return null;
            }
            return token.substring(len).toLowerCase();
        }
        return null;
    }

    private static boolean isValid(Context context, X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        try {
            certificate.checkValidity();
        }
        catch (CertificateException e) {
            log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate is EXPIRED or PREMATURE: " + e.toString()));
            return false;
        }
        if (caPublicKey != null) {
            try {
                certificate.verify(caPublicKey);
                return true;
            }
            catch (GeneralSecurityException e) {
                log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        if (caCertKeyStore != null) {
            try {
                Enumeration<String> ke = caCertKeyStore.aliases();
                while (ke.hasMoreElements()) {
                    String alias = ke.nextElement();
                    if (!caCertKeyStore.isCertificateEntry(alias)) continue;
                    Certificate ca = caCertKeyStore.getCertificate(alias);
                    try {
                        certificate.verify(ca.getPublicKey());
                        return true;
                    }
                    catch (CertificateException ce) {
                    }
                }
                log.info((Object)LogManager.getHeader(context, "authentication", "Keystore method FAILED SIGNATURE check on client cert."));
            }
            catch (GeneralSecurityException e) {
                log.info((Object)LogManager.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return ConfigurationManager.getBooleanProperty("authentication.x509.autoregister");
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    private List<String> getX509Groups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        String x509GroupConfig = null;
        x509GroupConfig = ConfigurationManager.getProperty("authentication.x509.groups");
        if (null != x509GroupConfig && !x509GroupConfig.equals("")) {
            String[] groups = x509GroupConfig.split("\\s*,\\s*");
            for (int i = 0; i < groups.length; ++i) {
                groupNames.add(groups[i].trim());
            }
        }
        return groupNames;
    }

    private void setSpecialGroupsFlag(HttpServletRequest request, String email) {
        String emailDomain = null;
        emailDomain = (String)request.getAttribute("authentication.x509.emaildomain");
        HttpSession session = request.getSession(true);
        if (null != emailDomain && !emailDomain.equals("")) {
            if (email.substring(email.length() - emailDomain.length()).equals(emailDomain)) {
                session.setAttribute("x509Auth", (Object)new Boolean(true));
            }
        } else {
            session.setAttribute("x509Auth", (Object)new Boolean(true));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        if (request == null) {
            return new int[0];
        }
        Boolean authenticated = false;
        HttpSession session = request.getSession(false);
        authenticated = (Boolean)session.getAttribute("x509Auth");
        authenticated = null == authenticated ? false : authenticated;
        if (authenticated.booleanValue()) {
            void var8_10;
            List<Object> groupNames = new ArrayList();
            ArrayList<Integer> groupIDs = new ArrayList<Integer>();
            groupNames = this.getX509Groups();
            for (String string : groupNames) {
                if (string == null) continue;
                Group group = Group.findByName(context, string);
                if (group != null) {
                    groupIDs.add(new Integer(group.getID()));
                    continue;
                }
                log.warn((Object)LogManager.getHeader(context, "configuration_error", "unknown_group=" + string));
            }
            int[] results = new int[groupIDs.size()];
            boolean bl = false;
            while (var8_10 < groupIDs.size()) {
                results[var8_10] = (Integer)groupIDs.get((int)var8_10);
                ++var8_10;
            }
            if (log.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < results.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(results[i]);
                }
                log.debug((Object)LogManager.getHeader(context, "authenticated", "special_groups=" + stringBuffer.toString()));
            }
            return results;
        }
        return new int[0];
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        X509Certificate[] certs = null;
        if (request != null) {
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length == 0) {
            return 5;
        }
        try {
            if (!X509Authentication.isValid(context, certs[0])) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=x509certificate, status=BAD_CREDENTIALS (not valid)"));
                return 2;
            }
            String email = X509Authentication.getEmail(certs[0]);
            EPerson eperson = null;
            if (email != null) {
                eperson = EPerson.findByEmail(context, email);
            }
            if (eperson == null) {
                if (email != null && this.canSelfRegister(context, request, null)) {
                    log.info((Object)LogManager.getHeader(context, "autoregister", "from=x.509, email=" + email));
                    context.setIgnoreAuthorization(true);
                    eperson = EPerson.create(context);
                    eperson.setEmail(email);
                    eperson.setCanLogIn(true);
                    AuthenticationManager.initEPerson(context, request, eperson);
                    eperson.update();
                    context.commit();
                    context.setIgnoreAuthorization(false);
                    context.setCurrentUser(eperson);
                    this.setSpecialGroupsFlag(request, email);
                    return 1;
                }
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=cert_but_no_record, cannot auto-register"));
                return 4;
            }
            if (!eperson.canLogIn()) {
                log.warn((Object)LogManager.getHeader(context, "authenticate", "type=x509certificate, email=" + email + ", canLogIn=false, rejecting."));
                return 5;
            }
            log.info((Object)LogManager.getHeader(context, "login", "type=x509certificate"));
            context.setCurrentUser(eperson);
            this.setSpecialGroupsFlag(request, email);
            return 1;
        }
        catch (AuthorizeException ce) {
            log.warn((Object)LogManager.getHeader(context, "authorize_exception", ""), (Throwable)ce);
            return 5;
        }
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return loginPageURL;
    }

    @Override
    public String loginPageTitle(Context context) {
        return loginPageTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        loginPageTitle = ConfigurationManager.getProperty("authentication.x509.chooser.title.key");
        loginPageURL = ConfigurationManager.getProperty("authentication.x509.chooser.uri");
        String keystorePath = ConfigurationManager.getProperty("authentication.x509.keystore.path");
        String keystorePassword = ConfigurationManager.getProperty("authentication.x509.keystore.password");
        String caCertPath = ConfigurationManager.getProperty("authentication.x509.ca.cert");
        if (caCertPath == null) {
            caCertPath = ConfigurationManager.getProperty("webui.cert.ca");
        }
        if (keystorePath != null) {
            FileInputStream fis = null;
            if (keystorePassword == null) {
                keystorePassword = "";
            }
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                fis = new FileInputStream(keystorePath);
                ks.load(fis, keystorePassword.toCharArray());
                caCertKeyStore = ks;
            }
            catch (IOException e) {
                log.error((Object)("X509Authentication: Failed to load CA keystore, file=" + keystorePath + ", error=" + e.toString()));
            }
            catch (GeneralSecurityException e) {
                log.error((Object)("X509Authentication: Failed to extract CA keystore, file=" + keystorePath + ", error=" + e.toString()));
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (caCertPath != null) {
            InputStream is = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(caCertPath);
                is = new BufferedInputStream(fis);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                if (cert != null) {
                    caPublicKey = cert.getPublicKey();
                }
            }
            catch (IOException e) {
                log.error((Object)("X509Authentication: Failed to load CA cert, file=" + caCertPath + ", error=" + e.toString()));
            }
            catch (CertificateException e) {
                log.error((Object)("X509Authentication: Failed to extract CA cert, file=" + caCertPath + ", error=" + e.toString()));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }
}

