/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.BulkEditChange;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataImport {
    Context c;
    ArrayList<DSpaceCSVLine> toImport;
    private static Logger log = Logger.getLogger(MetadataImport.class);

    public MetadataImport(Context c, ArrayList<DSpaceCSVLine> toImport) {
        this.c = c;
        this.toImport = toImport;
    }

    public ArrayList<BulkEditChange> runImport(boolean change, boolean useWorkflow, boolean workflowNotify, boolean useTemplate) throws MetadataImportException {
        ArrayList<BulkEditChange> changes = new ArrayList<BulkEditChange>();
        try {
            for (DSpaceCSVLine line : this.toImport) {
                Collection collection;
                ArrayList<String> collections;
                BulkEditChange whatHasChanged;
                int id = line.getID();
                if (id != -1) {
                    Item item = Item.find(this.c, id);
                    whatHasChanged = new BulkEditChange(item);
                    collections = line.get("collection");
                    if (collections != null) {
                        if (collections.size() == 0) {
                            throw new MetadataImportException("Missing collection from item " + item.getHandle());
                        }
                        Collection[] actualCollections = item.getCollections();
                        this.compare(item, collections, actualCollections, whatHasChanged, change);
                    }
                    Enumeration<String> e = line.keys();
                    while (e.hasMoreElements()) {
                        String md = e.nextElement();
                        if ("id".equals(md)) continue;
                        String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                        this.compare(item, fromCSV, change, md, whatHasChanged);
                    }
                    if (!whatHasChanged.hasChanges()) continue;
                    changes.add(whatHasChanged);
                    continue;
                }
                if (this.c.getCurrentUser() == null) {
                    throw new MetadataImportException("When adding new items, a user must be specified with the -e option");
                }
                Enumeration<String> e = line.keys();
                whatHasChanged = new BulkEditChange();
                while (e.hasMoreElements()) {
                    String md = e.nextElement();
                    if ("id".equals(md)) continue;
                    String[] fromCSV = line.get(md).toArray(new String[line.get(md).size()]);
                    this.add(fromCSV, md, whatHasChanged);
                }
                collections = line.get("collection");
                if (collections == null) {
                    throw new MetadataImportException("New items must have a 'collection' assigned in the form of a handle");
                }
                ArrayList<Collection> check = new ArrayList<Collection>();
                for (String handle : collections) {
                    try {
                        collection = (Collection)HandleManager.resolveToObject(this.c, handle);
                        if (collection == null) {
                            throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items");
                        }
                        if (check.contains(collection)) {
                            throw new MetadataImportException("Duplicate collection assignment detected in new item! " + handle);
                        }
                        check.add(collection);
                    }
                    catch (Exception ex) {
                        throw new MetadataImportException("'" + handle + "' is not a Collection! You must specify a valid collection for new items");
                    }
                }
                for (String handle : collections) {
                    Collection extra = (Collection)HandleManager.resolveToObject(this.c, handle);
                    whatHasChanged.registerNewOwningCollection(extra);
                }
                if (change) {
                    String collectionHandle = line.get("collection").get(0);
                    collection = (Collection)HandleManager.resolveToObject(this.c, collectionHandle);
                    WorkspaceItem wsItem = WorkspaceItem.create(this.c, collection, useTemplate);
                    Item item = wsItem.getItem();
                    for (DCValue dcv : whatHasChanged.getAdds()) {
                        item.addMetadata(dcv.schema, dcv.element, dcv.qualifier, dcv.language, dcv.value);
                    }
                    if (useWorkflow && workflowNotify) {
                        WorkflowManager.start(this.c, wsItem);
                    } else if (useWorkflow) {
                        WorkflowManager.startWithoutNotify(this.c, wsItem);
                    } else {
                        InstallItem.installItem(this.c, wsItem);
                    }
                    if (line.get("collection").size() > 0) {
                        for (int i = 1; i < collections.size(); ++i) {
                            String handle = collections.get(i);
                            Collection extra = (Collection)HandleManager.resolveToObject(this.c, handle);
                            extra.addItem(item);
                        }
                    }
                    this.c.commit();
                    whatHasChanged.setItem(item);
                }
                changes.add(whatHasChanged);
            }
        }
        catch (MetadataImportException mie) {
            throw mie;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changes;
    }

    private void compare(Item item, String[] fromCSV, boolean change, String md, BulkEditChange changes) throws SQLException, AuthorizeException {
        DCValue dcv;
        String[] bits;
        if ("collection".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf("["));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf("["));
        }
        DCValue[] current = item.getMetadata(schema, element, qualifier, language);
        String[] dcvalues = new String[current.length];
        int i = 0;
        for (DCValue dCValue : current) {
            dcvalues[i] = dCValue.value;
            ++i;
        }
        for (String string : dcvalues) {
            dcv = new DCValue();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            dcv.language = language;
            dcv.value = string;
            if (string != null && !"".equals(string) && !this.contains(string, fromCSV)) {
                changes.registerRemove(dcv);
                continue;
            }
            changes.registerConstant(dcv);
        }
        for (String string : fromCSV) {
            dcv = new DCValue();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            dcv.language = language;
            dcv.value = string;
            if (string == null || "".equals(string) || this.contains(string, dcvalues)) continue;
            changes.registerAdd(dcv);
        }
        if (change && (changes.getAdds().size() > 0 || changes.getRemoves().size() > 0)) {
            ArrayList<DCValue> list = changes.getComplete();
            ArrayList<String> values = new ArrayList<String>();
            for (DCValue dCValue : list) {
                if (qualifier == null && language == null) {
                    if (!schema.equals(dCValue.schema) || !element.equals(dCValue.element) || dCValue.qualifier != null || dCValue.language != null) continue;
                    values.add(dCValue.value);
                    continue;
                }
                if (qualifier == null) {
                    if (!schema.equals(dCValue.schema) || !element.equals(dCValue.element) || !language.equals(dCValue.language) || dCValue.qualifier != null) continue;
                    values.add(dCValue.value);
                    continue;
                }
                if (language == null) {
                    if (!schema.equals(dCValue.schema) || !element.equals(dCValue.element) || !qualifier.equals(dCValue.qualifier) || dCValue.language != null) continue;
                    values.add(dCValue.value);
                    continue;
                }
                if (!schema.equals(dCValue.schema) || !element.equals(dCValue.element) || !qualifier.equals(dCValue.qualifier) || !language.equals(dCValue.language)) continue;
                values.add(dCValue.value);
            }
            item.clearMetadata(schema, element, qualifier, language);
            String[] theValues = values.toArray(new String[values.size()]);
            item.addMetadata(schema, element, qualifier, language, theValues);
            item.update();
        }
    }

    private void compare(Item item, ArrayList<String> collections, Collection[] actualCollections, BulkEditChange bechange, boolean change) throws SQLException, AuthorizeException, IOException, MetadataImportException {
        for (String csvcollection : collections) {
            boolean found = false;
            for (Collection collection : actualCollections) {
                if (!csvcollection.equals(collection.getHandle())) continue;
                found = true;
            }
            if (found) continue;
            DSpaceObject dso = HandleManager.resolveToObject(this.c, csvcollection);
            if (dso == null || dso.getType() != 3) {
                throw new MetadataImportException("Collection defined for item " + item.getID() + " (" + item.getHandle() + ") is not a collection");
            }
            Collection col = (Collection)dso;
            bechange.registerNewOwningCollection(col);
            if (!change) continue;
            col.addItem(item);
        }
        for (Collection collection : actualCollections) {
            boolean found = false;
            for (String csvcollection : collections) {
                if (!collection.getHandle().equals(csvcollection)) continue;
                found = true;
            }
            if (found) continue;
            bechange.registerOldOwningCollection(collection);
            if (!change) continue;
            if (item.getCollections().length > 1) {
                collection.removeItem(item);
                continue;
            }
            throw new MetadataImportException("Not removing item " + item.getHandle() + " from collection " + collection.getHandle() + " as it would leave it oprhaned!");
        }
        if (change && !collections.get(0).equals(item.getOwningCollection().getHandle())) {
            Collection owner = (Collection)HandleManager.resolveToObject(this.c, collections.get(0));
            item.setOwningCollection(Collection.find(this.c, owner.getID()));
            item.update();
        }
    }

    private void add(String[] fromCSV, String md, BulkEditChange changes) throws SQLException, AuthorizeException {
        String[] bits;
        if ("collection".equals(md)) {
            return;
        }
        String language = null;
        if (md.contains("[")) {
            bits = md.split("\\[");
            language = bits[1].substring(0, bits[1].length() - 1);
        }
        bits = md.split("\\.");
        String schema = bits[0];
        String element = bits[1];
        if (element.contains("[")) {
            element = element.substring(0, element.indexOf("["));
        }
        String qualifier = null;
        if (bits.length > 2 && (qualifier = bits[2]).contains("[")) {
            qualifier = qualifier.substring(0, qualifier.indexOf("["));
        }
        for (String value : fromCSV) {
            DCValue dcv = new DCValue();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            dcv.language = language;
            dcv.value = value;
            if (value == null || "".equals(value)) continue;
            changes.registerAdd(dcv);
        }
    }

    private boolean contains(String needle, String[] haystack) {
        for (String examine : haystack) {
            if (!this.clean(examine).equals(this.clean(needle))) continue;
            return true;
        }
        return false;
    }

    private String clean(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\r\n", "").replaceAll("\n", "").trim();
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetatadataImport\n", options);
        System.out.println("\nmetadataimport: MetadataImport -f filename");
        System.exit(exitCode);
    }

    private static int displayChanges(ArrayList<BulkEditChange> changes, boolean changed) {
        int changeCounter = 0;
        for (BulkEditChange change : changes) {
            String md;
            String cName;
            String cHandle;
            ArrayList<DCValue> adds = change.getAdds();
            ArrayList<DCValue> removes = change.getRemoves();
            ArrayList<Collection> newCollections = change.getNewOwningCollections();
            ArrayList<Collection> oldCollections = change.getOldOwningCollections();
            if (adds.size() > 0 || removes.size() > 0 || newCollections.size() > 0 || oldCollections.size() > 0) {
                Item i = change.getItem();
                System.out.println("-----------------------------------------------------------");
                if (!change.isNewItem()) {
                    System.out.println("Changes for item: " + i.getID() + " (" + i.getHandle() + ")");
                } else {
                    System.out.print("New item: ");
                    if (i != null) {
                        if (i.getHandle() != null) {
                            System.out.print(i.getID() + " (" + i.getHandle() + ")");
                        } else {
                            System.out.print(i.getID() + " (in workflow)");
                        }
                    }
                    System.out.println();
                }
                ++changeCounter;
            }
            for (Collection c : newCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Add to collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Added to collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (Collection c : oldCollections) {
                cHandle = c.getHandle();
                cName = c.getName();
                if (!changed) {
                    System.out.print(" + Remove from collection (" + cHandle + "): ");
                } else {
                    System.out.print(" + Removed from collection  (" + cHandle + "): ");
                }
                System.out.println(cName);
            }
            for (DCValue dcv : adds) {
                md = dcv.schema + "." + dcv.element;
                if (dcv.qualifier != null) {
                    md = md + "." + dcv.qualifier;
                }
                if (dcv.language != null) {
                    md = md + "[" + dcv.language + "]";
                }
                if (!changed) {
                    System.out.print(" + Add    (" + md + "): ");
                } else {
                    System.out.print(" + Added   (" + md + "): ");
                }
                System.out.println(dcv.value);
            }
            for (DCValue dcv : removes) {
                md = dcv.schema + "." + dcv.element;
                if (dcv.qualifier != null) {
                    md = md + "." + dcv.qualifier;
                }
                if (dcv.language != null) {
                    md = md + "[" + dcv.language + "]";
                }
                if (!changed) {
                    System.out.println(" - Remove (" + md + "): " + dcv.value);
                    continue;
                }
                System.out.println(" - Removed (" + md + "): " + dcv.value);
            }
        }
        return changeCounter;
    }

    public static void main(String[] argv) {
        ArrayList<BulkEditChange> changes;
        MetadataImport importer;
        boolean change;
        Context c;
        boolean workflowNotify;
        boolean useWorkflow;
        boolean useTemplate;
        block31: {
            DSpaceCSV csv;
            CommandLine line;
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("f", "file", true, "source file");
            options.addOption("e", "email", true, "email address or user id of user (required if adding new items)");
            options.addOption("s", "silent", false, "silent operation - doesn't request confirmation of changes USE WITH CAUTION");
            options.addOption("w", "workflow", false, "workflow - when adding new items, use collection workflow");
            options.addOption("n", "notify", false, "notify - when adding new items using a workflow, send notification emails");
            options.addOption("t", "template", false, "template - when adding new items, use the collection template (if it exists)");
            options.addOption("h", "help", false, "help");
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException pe) {
                System.err.println("Error parsing command line arguments: " + pe.getMessage());
                System.exit(1);
                return;
            }
            if (line.hasOption('h')) {
                MetadataImport.printHelp(options, 0);
            }
            if (!line.hasOption('f')) {
                System.err.println("Required parameter -f missing!");
                MetadataImport.printHelp(options, 1);
            }
            String filename = line.getOptionValue('f');
            useTemplate = false;
            if (line.hasOption('t')) {
                useTemplate = true;
            }
            useWorkflow = false;
            workflowNotify = false;
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    workflowNotify = true;
                }
            } else if (line.hasOption('n')) {
                System.err.println("Invalid option 'n': (notify) can only be specified with the 'w' (workflow) option.");
                System.exit(1);
            }
            try {
                c = new Context();
                c.turnOffAuthorisationSystem();
            }
            catch (Exception e) {
                System.err.println("Unable to create a new DSpace Context: " + e.getMessage());
                System.exit(1);
                return;
            }
            try {
                if (line.hasOption('e')) {
                    String e = line.getOptionValue('e');
                    EPerson eperson = e.indexOf(64) != -1 ? EPerson.findByEmail(c, e) : EPerson.find(c, Integer.parseInt(e));
                    if (eperson == null) {
                        System.out.println("Error, eperson cannot be found: " + e);
                        System.exit(1);
                    }
                    c.setCurrentUser(eperson);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to find DSpace user: " + e.getMessage());
                System.exit(1);
                return;
            }
            change = false;
            try {
                csv = new DSpaceCSV(new File(filename));
            }
            catch (Exception e) {
                System.err.println("Error reading file: " + e.getMessage());
                System.exit(1);
                return;
            }
            importer = new MetadataImport(c, csv.getCSVLines());
            if (!line.hasOption('s')) {
                try {
                    changes = importer.runImport(false, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                int changeCounter = MetadataImport.displayChanges(changes, false);
                if (changeCounter > 0) {
                    try {
                        System.out.println("\n" + changeCounter + " item(s) will be changed\n");
                        System.out.print("Do you want to make these changes? [y/n] ");
                        String yn = new BufferedReader(new InputStreamReader(System.in)).readLine();
                        if ("y".equalsIgnoreCase(yn)) {
                            change = true;
                            break block31;
                        }
                        System.out.println("No data has been changed.");
                    }
                    catch (IOException ioe) {
                        System.err.println("Error: " + ioe.getMessage());
                        System.err.println("No changes have been made");
                        System.exit(1);
                    }
                } else {
                    System.out.println("There were no changes detected");
                }
            } else {
                change = true;
            }
        }
        try {
            if (change) {
                try {
                    changes = importer.runImport(true, useWorkflow, workflowNotify, useTemplate);
                }
                catch (MetadataImportException mie) {
                    System.err.println("Error: " + mie.getMessage());
                    System.exit(1);
                    return;
                }
                MetadataImport.displayChanges(changes, true);
                c.commit();
            }
            c.restoreAuthSystemState();
            c.complete();
        }
        catch (Exception e) {
            c.abort();
            System.err.println("Error commiting changes to database: " + e.getMessage());
            System.err.println("Aborting most recent changes.");
            System.exit(1);
        }
    }
}

