/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class LDAPHierarchicalAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(LDAPHierarchicalAuthentication.class);

    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return ConfigurationManager.getBooleanProperty("webui.ldap.autoregister");
    }

    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    public boolean isImplicit() {
        return false;
    }

    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            String groupName;
            if (!context.getCurrentUser().getNetid().equals("") && (groupName = ConfigurationManager.getProperty("ldap.login.specialgroup")) != null && !groupName.trim().equals("")) {
                Group ldapGroup = Group.findByName(context, groupName);
                if (ldapGroup == null) {
                    log.warn((Object)LogManager.getHeader(context, "ldap_specialgroup", "Group defined in ldap.login.specialgroup does not exist"));
                    return new int[0];
                }
                return new int[]{ldapGroup.getID()};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authenticate(Context context, String netid, String password, String realm, HttpServletRequest request) throws SQLException {
        log.info((Object)LogManager.getHeader(context, "auth", "attempting trivial auth of user=" + netid));
        if (netid == null || password == null) {
            return 5;
        }
        EPerson eperson = null;
        try {
            eperson = EPerson.findByNetid(context, netid.toLowerCase());
        }
        catch (SQLException e) {
            // empty catch block
        }
        SpeakerToLDAP ldap = new SpeakerToLDAP(log);
        String adminUser = ConfigurationManager.getProperty("ldap.search.user");
        String adminPassword = ConfigurationManager.getProperty("ldap.search.password");
        String dn = ldap.getDNOfUser(adminUser, adminPassword, context, netid);
        if (dn == null || dn.trim().equals("")) {
            log.info((Object)LogManager.getHeader(context, "failed_login", "no DN found for user " + netid));
            return 2;
        }
        if (eperson != null) {
            if (eperson.getRequireCertificate()) {
                return 3;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            if (ldap.ldapAuthenticate(dn, password, context)) {
                context.setCurrentUser(eperson);
                log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap"));
                return 1;
            }
            return 2;
        }
        if (ldap.ldapAuthenticate(dn, password, context)) {
            log.info((Object)LogManager.getHeader(context, "autoregister", "netid=" + netid));
            if (ldap.ldapEmail != null && !ldap.ldapEmail.equals("")) {
                try {
                    eperson = EPerson.findByEmail(context, ldap.ldapEmail);
                    if (eperson != null) {
                        log.info((Object)LogManager.getHeader(context, "type=ldap-login", "type=ldap_but_already_email"));
                        context.setIgnoreAuthorization(true);
                        eperson.setNetid(netid.toLowerCase());
                        eperson.update();
                        context.commit();
                        context.setIgnoreAuthorization(false);
                        context.setCurrentUser(eperson);
                        int n = 1;
                        return n;
                    }
                    if (this.canSelfRegister(context, request, netid)) {
                        try {
                            context.setIgnoreAuthorization(true);
                            eperson = EPerson.create(context);
                            if (ldap.ldapEmail != null && !ldap.ldapEmail.equals("")) {
                                eperson.setEmail(ldap.ldapEmail);
                            } else {
                                eperson.setEmail(netid + ConfigurationManager.getProperty("ldap.netid_email_domain"));
                            }
                            if (ldap.ldapGivenName != null && !ldap.ldapGivenName.equals("")) {
                                eperson.setFirstName(ldap.ldapGivenName);
                            }
                            if (ldap.ldapSurname != null && !ldap.ldapSurname.equals("")) {
                                eperson.setLastName(ldap.ldapSurname);
                            }
                            if (ldap.ldapPhone != null && !ldap.ldapPhone.equals("")) {
                                eperson.setMetadata("phone", ldap.ldapPhone);
                            }
                            eperson.setNetid(netid.toLowerCase());
                            eperson.setCanLogIn(true);
                            AuthenticationManager.initEPerson(context, request, eperson);
                            eperson.update();
                            context.commit();
                            context.setCurrentUser(eperson);
                        }
                        catch (AuthorizeException e) {
                            int n = 4;
                            return n;
                        }
                        finally {
                            context.setIgnoreAuthorization(false);
                        }
                        log.info((Object)LogManager.getHeader(context, "authenticate", "type=ldap-login, created ePerson"));
                        int e = 1;
                        return e;
                    }
                    log.info((Object)LogManager.getHeader(context, "failed_login", "type=ldap_but_no_record"));
                    int e = 4;
                    return e;
                }
                catch (AuthorizeException e) {
                    eperson = null;
                }
                finally {
                    context.setIgnoreAuthorization(false);
                }
            }
        }
        return 5;
    }

    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return response.encodeRedirectURL(request.getContextPath() + "/ldap-login");
    }

    public String loginPageTitle(Context context) {
        return "org.dspace.eperson.LDAPAuthentication.title";
    }

    public class SpeakerToLDAP {
        private Logger log = null;
        protected String ldapEmail = null;
        protected String ldapGivenName = null;
        protected String ldapSurname = null;
        protected String ldapPhone = null;
        String ldap_provider_url = ConfigurationManager.getProperty("ldap.provider_url");
        String ldap_id_field = ConfigurationManager.getProperty("ldap.id_field");
        String ldap_search_context = ConfigurationManager.getProperty("ldap.search_context");
        String ldap_object_context = ConfigurationManager.getProperty("ldap.object_context");
        String ldap_search_scope = ConfigurationManager.getProperty("ldap.search_scope");
        String ldap_email_field = ConfigurationManager.getProperty("ldap.email_field");
        String ldap_givenname_field = ConfigurationManager.getProperty("ldap.givenname_field");
        String ldap_surname_field = ConfigurationManager.getProperty("ldap.surname_field");
        String ldap_phone_field = ConfigurationManager.getProperty("ldap.phone_field");

        SpeakerToLDAP(Logger thelog) {
            this.log = thelog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDNOfUser(String adminUser, String adminPassword, Context context, String netid) {
            int ldap_search_scope_value;
            block27: {
                ldap_search_scope_value = 0;
                try {
                    ldap_search_scope_value = Integer.parseInt(this.ldap_search_scope.trim());
                }
                catch (NumberFormatException e) {
                    if (this.ldap_search_scope == null) break block27;
                    this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "invalid search scope: " + this.ldap_search_scope));
                }
            }
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldap_provider_url);
            if (adminUser != null && !adminUser.trim().equals("") && adminPassword != null && !adminPassword.trim().equals("")) {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", adminUser);
                env.put("java.naming.security.credentials", adminPassword);
            } else {
                env.put("java.naming.security.authentication", "none");
            }
            InitialDirContext ctx = null;
            try {
                ctx = new InitialDirContext(env);
                BasicAttributes matchAttrs = new BasicAttributes(true);
                matchAttrs.put(new BasicAttribute(this.ldap_id_field, netid));
                try {
                    String resultDN;
                    SearchControls ctrls = new SearchControls();
                    ctrls.setSearchScope(ldap_search_scope_value);
                    NamingEnumeration<SearchResult> answer = ctx.search(this.ldap_provider_url + this.ldap_search_context, "(&({0}={1}))", new Object[]{this.ldap_id_field, netid}, ctrls);
                    do {
                        Attribute att;
                        if (!answer.hasMoreElements()) return null;
                        SearchResult sr = answer.next();
                        resultDN = StringUtils.isEmpty((String)this.ldap_search_context) ? sr.getName() : sr.getName() + "," + this.ldap_search_context;
                        String[] attlist = new String[]{this.ldap_email_field, this.ldap_givenname_field, this.ldap_surname_field, this.ldap_phone_field};
                        Attributes atts = sr.getAttributes();
                        if (attlist[0] != null && (att = atts.get(attlist[0])) != null) {
                            this.ldapEmail = (String)att.get();
                        }
                        if (attlist[1] != null && (att = atts.get(attlist[1])) != null) {
                            this.ldapGivenName = (String)att.get();
                        }
                        if (attlist[2] != null && (att = atts.get(attlist[2])) != null) {
                            this.ldapSurname = (String)att.get();
                        }
                        if (attlist[3] == null || (att = atts.get(attlist[3])) == null) continue;
                        this.ldapPhone = (String)att.get();
                    } while (answer.hasMoreElements());
                    this.log.debug((Object)LogManager.getHeader(context, "got DN", resultDN));
                    String string = resultDN;
                    return string;
                }
                catch (NamingException e) {
                    this.log.warn((Object)LogManager.getHeader(context, "ldap_attribute_lookup", "type=failed_search " + e));
                    return null;
                }
            }
            catch (NamingException e) {
                this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "type=failed_auth " + e));
                try {
                    if (ctx == null) return null;
                    ctx.close();
                    return null;
                }
                catch (NamingException e2) {
                    return null;
                }
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean ldapAuthenticate(String netid, String password, Context context) {
            if (password.equals("")) return false;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldap_provider_url);
            env.put("java.naming.security.authentication", "Simple");
            env.put("java.naming.security.principal", netid);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.authoritative", "true");
            env.put("java.naming.referral", "follow");
            InitialDirContext ctx = null;
            try {
                ctx = new InitialDirContext(env);
                return true;
            }
            catch (NamingException e) {
                this.log.warn((Object)LogManager.getHeader(context, "ldap_authentication", "type=failed_auth " + e));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException e) {}
            }
        }
    }
}

