/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeManager {
    public static void authorizeAnyOf(Context c, DSpaceObject o, int[] actions) throws AuthorizeException, SQLException {
        AuthorizeException ex = null;
        for (int i = 0; i < actions.length; ++i) {
            try {
                AuthorizeManager.authorizeAction(c, o, actions[i]);
                return;
            }
            catch (AuthorizeException e) {
                if (ex != null) continue;
                ex = e;
                continue;
            }
        }
        throw ex;
    }

    public static void authorizeAction(Context c, DSpaceObject o, int action) throws AuthorizeException, SQLException {
        AuthorizeManager.authorizeAction(c, o, action, true);
    }

    public static void authorizeAction(Context c, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        if (o == null) {
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            EPerson e = c.getCurrentUser();
            int userid = e == null ? 0 : e.getID();
            throw new AuthorizeException("Authorization attempted on null DSpace object " + actionText + " by user " + userid);
        }
        if (!AuthorizeManager.authorize(c, o, action, c.getCurrentUser(), useInheritance)) {
            int otype = o.getType();
            int oid = o.getID();
            EPerson e = c.getCurrentUser();
            int userid = e == null ? 0 : e.getID();
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            throw new AuthorizeException("Authorization denied for action " + actionText + " on " + Constants.typeText[otype] + ":" + oid + " by user " + userid, o, action);
        }
    }

    public static boolean authorizeActionBoolean(Context c, DSpaceObject o, int a) throws SQLException {
        return AuthorizeManager.authorizeActionBoolean(c, o, a, true);
    }

    public static boolean authorizeActionBoolean(Context c, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            AuthorizeManager.authorizeAction(c, o, a, useInheritance);
        }
        catch (AuthorizeException e) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    private static boolean authorize(Context c, DSpaceObject o, int action, EPerson e, boolean useInheritance) throws SQLException {
        int userid;
        if (o == null) {
            return false;
        }
        if (c.ignoreAuthorization()) {
            return true;
        }
        if (e == null) {
            userid = 0;
        } else {
            DSpaceObject testObject;
            userid = e.getID();
            DSpaceObject dSpaceObject = testObject = useInheritance ? o.getAdminObject(action) : null;
            if (AuthorizeManager.isAdmin(c, testObject)) {
                return true;
            }
        }
        for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(c, o, action)) {
            if (!rp.isDateValid()) continue;
            if (rp.getEPersonID() != -1 && rp.getEPersonID() == userid) {
                return true;
            }
            if (rp.getGroupID() == -1 || !Group.isMember(c, rp.getGroupID())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdmin(Context c, DSpaceObject o) throws SQLException {
        if (AuthorizeManager.isAdmin(c)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(c, o, 11);
        int userid = c.getCurrentUser().getID();
        for (ResourcePolicy rp : policies) {
            if (!rp.isDateValid()) continue;
            if (rp.getEPersonID() != -1 && rp.getEPersonID() == userid) {
                return true;
            }
            if (rp.getGroupID() == -1 || !Group.isMember(c, rp.getGroupID())) continue;
            return true;
        }
        DSpaceObject parent = o.getParentObject();
        if (parent != null) {
            return AuthorizeManager.isAdmin(c, parent);
        }
        return false;
    }

    public static boolean isAdmin(Context c) throws SQLException {
        if (c.ignoreAuthorization()) {
            return true;
        }
        EPerson e = c.getCurrentUser();
        if (e == null) {
            return false;
        }
        return Group.isMember(c, 1);
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, EPerson e) throws SQLException, AuthorizeException {
        ResourcePolicy rp = ResourcePolicy.create(c);
        rp.setResource(o);
        rp.setAction(actionID);
        rp.setEPerson(e);
        rp.update();
    }

    public static void addPolicy(Context c, DSpaceObject o, int actionID, Group g) throws SQLException, AuthorizeException {
        ResourcePolicy rp = ResourcePolicy.create(c);
        rp.setResource(o);
        rp.setAction(actionID);
        rp.setGroup(g);
        rp.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPolicies(Context c, DSpaceObject o) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? ", o.getType(), o.getID());
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPoliciesForGroup(Context c, Group g) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE epersongroup_id= ? ", g.getID());
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourcePolicy> getPoliciesActionFilter(Context c, DSpaceObject o, int actionID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", o.getType(), o.getID(), actionID);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                if (cachepolicy != null) {
                    policies.add(cachepolicy);
                    continue;
                }
                policies.add(new ResourcePolicy(c, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return policies;
    }

    public static void inheritPolicies(Context c, DSpaceObject src, DSpaceObject dest) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = AuthorizeManager.getPolicies(c, src);
        ArrayList<ResourcePolicy> nonAdminPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : policies) {
            if (rp.getAction() == 11) continue;
            nonAdminPolicies.add(rp);
        }
        AuthorizeManager.addPolicies(c, nonAdminPolicies, dest);
    }

    public static void addPolicies(Context c, List<ResourcePolicy> policies, DSpaceObject dest) throws SQLException, AuthorizeException {
        for (ResourcePolicy srp : policies) {
            ResourcePolicy drp = ResourcePolicy.create(c);
            drp.setResource(dest);
            drp.setAction(srp.getAction());
            drp.setEPerson(srp.getEPerson());
            drp.setGroup(srp.getGroup());
            drp.setStartDate(srp.getStartDate());
            drp.setEndDate(srp.getEndDate());
            drp.update();
        }
    }

    public static void removeAllPolicies(Context c, DSpaceObject o) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? ", o.getType(), o.getID());
    }

    public static void removePoliciesActionFilter(Context context, DSpaceObject dso, int actionID) throws SQLException {
        if (actionID == -1) {
            AuthorizeManager.removeAllPolicies(context, dso);
        } else {
            DatabaseManager.updateQuery(context, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", dso.getType(), dso.getID(), actionID);
        }
    }

    public static void removeGroupPolicies(Context c, int groupID) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE epersongroup_id= ? ", groupID);
    }

    public static void removeGroupPolicies(Context c, DSpaceObject o, Group g) throws SQLException {
        DatabaseManager.updateQuery(c, "DELETE FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND epersongroup_id= ? ", o.getType(), o.getID(), g.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] getAuthorizedGroups(Context c, DSpaceObject o, int actionID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "resourcepolicy", "SELECT * FROM resourcepolicy WHERE resource_type_id= ? AND resource_id= ? AND action_id= ? ", o.getType(), o.getID(), actionID);
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                ResourcePolicy cachepolicy = (ResourcePolicy)c.fromCache(ResourcePolicy.class, row.getIntColumn("policy_id"));
                ResourcePolicy myPolicy = null;
                myPolicy = cachepolicy != null ? cachepolicy : new ResourcePolicy(c, row);
                Group myGroup = myPolicy.getGroup();
                if (myGroup == null) continue;
                groups.add(myGroup);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Group[] groupArray = new Group[groups.size()];
        groupArray = groups.toArray(groupArray);
        return groupArray;
    }
}

