/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.util.Date;
import org.dspace.checker.DSpaceBitstreamInfo;

public final class BitstreamInfo {
    private boolean deleted;
    private DSpaceBitstreamInfo dspaceBitstream;
    private boolean infoFound;
    private boolean bitstreamFound;
    private String calculatedChecksum;
    private boolean toBeProcessed;
    private String checksumCheckResult;
    private Date processStartDate;
    private Date processEndDate;

    private BitstreamInfo() {
    }

    public BitstreamInfo(int bid) {
        this.deleted = false;
        this.dspaceBitstream = new DSpaceBitstreamInfo(bid);
        this.infoFound = true;
        this.bitstreamFound = false;
        this.calculatedChecksum = null;
        this.processEndDate = null;
        this.toBeProcessed = false;
        this.processStartDate = new Date();
    }

    public BitstreamInfo(boolean del, int storeNo, long sz, String bitstrmFmt, int bitstrmId, String usrFmtDesc, String intrnlId, String src, String chksumAlgorthm, String chksum, String nm, Date procEndDate, boolean toBeProc, Date procStartDate) {
        this.dspaceBitstream = new DSpaceBitstreamInfo(del, storeNo, sz, bitstrmFmt, bitstrmId, usrFmtDesc, intrnlId, src, chksumAlgorthm, chksum, nm, "");
        this.deleted = del;
        this.processEndDate = procEndDate;
        this.toBeProcessed = toBeProc;
        this.processStartDate = procStartDate;
        this.infoFound = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public int getStoreNumber() {
        return this.dspaceBitstream.getStoreNumber();
    }

    public void setStoreNumber(int storeNumber) {
        this.dspaceBitstream.setStoreNumber(storeNumber);
    }

    public long getSize() {
        return this.dspaceBitstream.getSize();
    }

    public void setSize(int size) {
        this.dspaceBitstream.setSize(size);
    }

    public String getBitstreamFormatId() {
        return this.dspaceBitstream.getBitstreamFormatId();
    }

    public void setBitstreamFormatId(String bitstrmFmt) {
        this.dspaceBitstream.setBitstreamFormatId(bitstrmFmt);
    }

    public int getBitstreamId() {
        return this.dspaceBitstream.getBitstreamId();
    }

    public String getUserFormatDescription() {
        return this.dspaceBitstream.getUserFormatDescription();
    }

    public void setUserFormatDescription(String userFormatDescription) {
        this.dspaceBitstream.setUserFormatDescription(userFormatDescription);
    }

    public String getInternalId() {
        return this.dspaceBitstream.getInternalId();
    }

    public void setInternalId(String internalId) {
        this.dspaceBitstream.setInternalId(internalId);
    }

    public String getSource() {
        return this.dspaceBitstream.getSource();
    }

    public void setSource(String source) {
        this.dspaceBitstream.setSource(source);
    }

    public String getChecksumAlgorithm() {
        return this.dspaceBitstream.getChecksumAlgorithm();
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.dspaceBitstream.setChecksumAlgorithm(checksumAlgorithm);
    }

    public String getStoredChecksum() {
        return this.dspaceBitstream.getStoredChecksum();
    }

    public void setStoredChecksum(String checksum) {
        this.dspaceBitstream.setStoredChecksum(checksum);
    }

    public String getName() {
        return this.dspaceBitstream.getName();
    }

    public void setName(String nm) {
        this.dspaceBitstream.setName(nm);
    }

    public String getCalculatedChecksum() {
        return this.calculatedChecksum;
    }

    public void setCalculatedChecksum(String calculatedChecksum) {
        this.calculatedChecksum = calculatedChecksum;
    }

    public boolean getInfoFound() {
        return this.infoFound;
    }

    public void setInfoFound(boolean found) {
        this.infoFound = found;
    }

    public boolean getBitstreamFound() {
        return this.bitstreamFound;
    }

    public void setBitstreamFound(boolean found) {
        this.bitstreamFound = found;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitstreamInfo)) {
            return false;
        }
        BitstreamInfo other = (BitstreamInfo)o;
        return this.getBitstreamId() == other.getBitstreamId();
    }

    public int hashCode() {
        return this.getBitstreamId();
    }

    public String toString() {
        return new StringBuffer("ChecksumInformation for id ").append(this.getBitstreamId()).toString();
    }

    public void setToBeProcessed(boolean toBeProcessed) {
        this.toBeProcessed = toBeProcessed;
    }

    public boolean getToBeProcessed() {
        return this.toBeProcessed;
    }

    public String getChecksumCheckResult() {
        return this.checksumCheckResult;
    }

    public void setChecksumCheckResult(String resultCode) {
        this.checksumCheckResult = resultCode;
    }

    public Date getProcessStartDate() {
        return this.processStartDate;
    }

    public void setProcessStartDate(Date startDate) {
        this.processStartDate = startDate;
    }

    public Date getProcessEndDate() {
        return this.processEndDate;
    }

    public void setProcessEndDate(Date endDate) {
        this.processEndDate = endDate;
    }
}

