/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowManager;

public class WorkflowItem
implements InProgressSubmission {
    private static Logger log = Logger.getLogger(WorkflowItem.class);
    private Item item;
    private Context ourContext;
    private TableRow wfRow;
    private Collection collection;
    private EPerson owner;

    WorkflowItem(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.wfRow = row;
        this.item = Item.find(context, this.wfRow.getIntColumn("item_id"));
        this.collection = Collection.find(context, this.wfRow.getIntColumn("collection_id"));
        this.owner = this.wfRow.isColumnNull("owner") ? null : EPerson.find(context, this.wfRow.getIntColumn("owner"));
        context.cache(this, row.getIntColumn("workflow_id"));
    }

    public static WorkflowItem find(Context context, int id) throws SQLException {
        WorkflowItem fromCache = (WorkflowItem)context.fromCache(WorkflowItem.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "workflowitem", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "not_found,workflow_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "workflow_id=" + id));
        }
        return new WorkflowItem(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findAll(Context c) throws SQLException {
        ArrayList<WorkflowItem> wfItems = new ArrayList<WorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", "SELECT * FROM workflowitem", new Object[0]);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = new WorkflowItem(c, row);
                wfItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        WorkflowItem[] wfArray = new WorkflowItem[wfItems.size()];
        wfArray = wfItems.toArray(wfArray);
        return wfArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findByEPerson(Context context, EPerson ep) throws SQLException {
        ArrayList<WorkflowItem> wfItems = new ArrayList<WorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "workflowitem", "SELECT workflowitem.* FROM workflowitem, item WHERE workflowitem.item_id=item.item_id AND item.submitter_id= ? ORDER BY workflowitem.workflow_id", ep.getID());
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = (WorkflowItem)context.fromCache(WorkflowItem.class, row.getIntColumn("workflow_id"));
                if (wi == null) {
                    wi = new WorkflowItem(context, row);
                }
                wfItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        WorkflowItem[] wfArray = new WorkflowItem[wfItems.size()];
        wfArray = wfItems.toArray(wfArray);
        return wfArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowItem[] findByCollection(Context context, Collection c) throws SQLException {
        ArrayList<WorkflowItem> wsItems = new ArrayList<WorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "workflowitem", "SELECT workflowitem.* FROM workflowitem WHERE workflowitem.collection_id= ? ", c.getID());
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                WorkflowItem wi = (WorkflowItem)context.fromCache(WorkflowItem.class, row.getIntColumn("workflow_id"));
                if (wi == null) {
                    wi = new WorkflowItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        WorkflowItem[] wsArray = new WorkflowItem[wsItems.size()];
        wsArray = wsItems.toArray(wsArray);
        return wsArray;
    }

    public int getID() {
        return this.wfRow.getIntColumn("workflow_id");
    }

    public EPerson getOwner() {
        return this.owner;
    }

    public void setOwner(EPerson ep) {
        this.owner = ep;
        if (ep == null) {
            this.wfRow.setColumnNull("owner");
        } else {
            this.wfRow.setColumn("owner", ep.getID());
        }
    }

    public int getState() {
        return this.wfRow.getIntColumn("state");
    }

    public void setState(int newstate) {
        this.wfRow.setColumn("state", newstate);
    }

    public void update() throws SQLException, IOException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_workflow_item", "workflow_item_id=" + this.getID()));
        this.item.update();
        DatabaseManager.update(this.ourContext, this.wfRow);
    }

    public void deleteWrapper() throws SQLException, IOException, AuthorizeException {
        this.ourContext.removeCached(this, this.getID());
        WorkflowManager.deleteTasks(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.wfRow);
    }

    public Item getItem() {
        return this.item;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public EPerson getSubmitter() throws SQLException {
        return this.item.getSubmitter();
    }

    public boolean hasMultipleFiles() {
        return this.wfRow.getBooleanColumn("multiple_files");
    }

    public void setMultipleFiles(boolean b) {
        this.wfRow.setColumn("multiple_files", b);
    }

    public boolean hasMultipleTitles() {
        return this.wfRow.getBooleanColumn("multiple_titles");
    }

    public void setMultipleTitles(boolean b) {
        this.wfRow.setColumn("multiple_titles", b);
    }

    public boolean isPublishedBefore() {
        return this.wfRow.getBooleanColumn("published_before");
    }

    public void setPublishedBefore(boolean b) {
        this.wfRow.setColumn("published_before", b);
    }
}

