/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEditChange {
    private Item item;
    private ArrayList<DCValue> adds;
    private ArrayList<DCValue> removes;
    private ArrayList<DCValue> constant;
    private ArrayList<DCValue> complete;
    private ArrayList<Collection> oldMappedCollections;
    private ArrayList<Collection> newMappedCollections;
    private Collection oldOwningCollection;
    private Collection newOwningCollection;
    private boolean newItem;
    private boolean empty;

    public BulkEditChange() {
        this.item = null;
        this.newItem = true;
        this.empty = true;
        this.oldOwningCollection = null;
        this.newOwningCollection = null;
        this.adds = new ArrayList();
        this.removes = new ArrayList();
        this.constant = new ArrayList();
        this.complete = new ArrayList();
        this.oldMappedCollections = new ArrayList();
        this.newMappedCollections = new ArrayList();
    }

    public BulkEditChange(Item i) {
        this.item = i;
        this.newItem = false;
        this.empty = true;
        this.adds = new ArrayList();
        this.removes = new ArrayList();
        this.constant = new ArrayList();
        this.complete = new ArrayList();
        this.oldMappedCollections = new ArrayList();
        this.newMappedCollections = new ArrayList();
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public void registerAdd(DCValue dcv) {
        this.adds.add(dcv);
        this.complete.add(dcv);
        this.empty = false;
    }

    public void registerRemove(DCValue dcv) {
        this.removes.add(dcv);
        this.empty = false;
    }

    public void registerConstant(DCValue dcv) {
        this.constant.add(dcv);
        this.complete.add(dcv);
    }

    public void registerNewMappedCollection(Collection c) {
        this.newMappedCollections.add(c);
        this.empty = false;
    }

    public void registerOldMappedCollection(Collection c) {
        boolean found = false;
        if (this.getOldOwningCollection() != null && this.getOldOwningCollection().getHandle().equals(c.getHandle())) {
            found = true;
        }
        for (Collection collection : this.oldMappedCollections) {
            if (!collection.getHandle().equals(c.getHandle())) continue;
            found = true;
        }
        if (!found) {
            this.oldMappedCollections.add(c);
            this.empty = false;
        }
    }

    public void changeOwningCollection(Collection oldC, Collection newC) {
        this.oldOwningCollection = oldC;
        this.newOwningCollection = newC;
        this.empty = false;
    }

    public void setOwningCollection(Collection newC) {
        this.newOwningCollection = newC;
    }

    public Item getItem() {
        return this.item;
    }

    public ArrayList<DCValue> getAdds() {
        return this.adds;
    }

    public ArrayList<DCValue> getRemoves() {
        return this.removes;
    }

    public ArrayList<DCValue> getConstant() {
        return this.constant;
    }

    public ArrayList<DCValue> getComplete() {
        return this.complete;
    }

    public ArrayList<Collection> getNewMappedCollections() {
        return this.newMappedCollections;
    }

    public ArrayList<Collection> getOldMappedCollections() {
        return this.oldMappedCollections;
    }

    public Collection getOldOwningCollection() {
        return this.oldOwningCollection;
    }

    public Collection getNewOwningCollection() {
        return this.newOwningCollection;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public boolean hasChanges() {
        return !this.empty;
    }
}

