/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.sql.SQLException;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.UpdateMetadataAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;

public class AddMetadataAction
extends UpdateMetadataAction {
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws AuthorizeException, SQLException {
        Item item = itarch.getItem();
        String dirname = itarch.getDirectoryName();
        block0: for (DtoMetadata dtom : itarch.getMetadataFields()) {
            for (String f : this.targetFields) {
                if (!dtom.matches(f, false)) continue;
                DCValue[] ardcv = null;
                ardcv = item.getMetadata(dtom.schema, dtom.element, dtom.qualifier, "*");
                boolean found = false;
                for (DCValue dcv : ardcv) {
                    if (!dcv.value.equals(dtom.value)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    ItemUpdate.pr("Warning:  No new metadata found to add to item " + dirname + " for element " + f);
                    continue block0;
                }
                if (isTest) {
                    ItemUpdate.pr("Metadata to add: " + dtom.toString());
                    MetadataSchema foundSchema = MetadataSchema.find(context, dtom.schema);
                    if (foundSchema == null) {
                        ItemUpdate.pr("ERROR: schema '" + dtom.schema + "' was not found in the registry; found on item " + dirname);
                        continue block0;
                    }
                    int schemaID = foundSchema.getSchemaID();
                    MetadataField foundField = MetadataField.findByElement(context, schemaID, dtom.element, dtom.qualifier);
                    if (foundField != null) continue block0;
                    ItemUpdate.pr("ERROR: Metadata field: '" + dtom.schema + "." + dtom.element + "." + dtom.qualifier + "' not found in registry; found on item " + dirname);
                    continue block0;
                }
                item.addMetadata(dtom.schema, dtom.element, dtom.qualifier, dtom.language, dtom.value);
                ItemUpdate.pr("Metadata added: " + dtom.toString());
                if (suppressUndo) continue block0;
                for (DCValue dcval : ardcv) {
                    itarch.addUndoMetadataField(DtoMetadata.create(dcval.schema, dcval.element, dcval.qualifier, dcval.language, dcval.value));
                }
                continue block0;
            }
        }
    }
}

