/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.launcher;

import java.lang.reflect.Method;
import java.util.List;
import org.dspace.core.ConfigurationManager;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.services.RequestService;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ScriptLauncher {
    private static transient DSpaceKernelImpl kernelImpl;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("You must provide at least one command argument");
            ScriptLauncher.display();
            System.exit(1);
        }
        try {
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start(ConfigurationManager.getProperty("dspace.dir"));
            }
        }
        catch (Exception e) {
            try {
                kernelImpl.destroy();
            }
            catch (Exception e1) {
                // empty catch block
            }
            String message = "Failure during filter init: " + e.getMessage();
            System.err.println(message + ":" + e);
            throw new RuntimeException(message, e);
        }
        Document doc = ScriptLauncher.getConfig();
        String request = args[0];
        Element root = doc.getRootElement();
        List commands = root.getChildren("command");
        for (Element command : commands) {
            if (!request.equalsIgnoreCase(command.getChild("name").getValue())) continue;
            List steps = command.getChildren("step");
            for (Element step : steps) {
                RequestService requestService;
                int i;
                String[] argsnew;
                String className;
                Class<?> target = null;
                if ("dsrun".equals(request)) {
                    if (args.length < 2) {
                        System.err.println("Error in launcher.xml: Missing class name");
                        System.exit(1);
                    }
                    className = args[1];
                } else {
                    className = step.getChild("class").getValue();
                }
                try {
                    target = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Error in launcher.xml: Invalid class name: " + className);
                    System.exit(1);
                }
                String[] useargs = (String[])args.clone();
                Class[] argTypes = new Class[]{useargs.getClass()};
                boolean passargs = true;
                if (step.getAttribute("passuserargs") != null && "false".equalsIgnoreCase(step.getAttribute("passuserargs").getValue())) {
                    passargs = false;
                }
                if (args.length == 1 || "dsrun".equals(request) && args.length == 2 || !passargs) {
                    useargs = new String[]{};
                } else {
                    int x = 1;
                    if ("dsrun".equals(request)) {
                        x = 2;
                    }
                    argsnew = new String[useargs.length - x];
                    for (i = x; i < useargs.length; ++i) {
                        argsnew[i - x] = useargs[i];
                    }
                    useargs = argsnew;
                }
                List bits = step.getChildren("argument");
                if (step.getChild("argument") != null) {
                    argsnew = new String[useargs.length + bits.size()];
                    i = 0;
                    for (Element arg : bits) {
                        argsnew[i++] = arg.getValue();
                    }
                    while (i < bits.size() + useargs.length) {
                        argsnew[i] = useargs[i - bits.size()];
                        ++i;
                    }
                    useargs = argsnew;
                }
                if ((requestService = (RequestService)kernelImpl.getServiceManager().getServiceByName(RequestService.class.getName(), RequestService.class)) == null) {
                    throw new IllegalStateException("Could not get the DSpace RequestService to start the request transaction");
                }
                requestService.startRequest();
                try {
                    Object[] arguments = new Object[]{useargs};
                    Method main = target.getMethod("main", argTypes);
                    Object output = main.invoke(null, arguments);
                    requestService.endRequest(null);
                }
                catch (Exception e) {
                    requestService.endRequest(e);
                    if (kernelImpl != null) {
                        kernelImpl.destroy();
                        kernelImpl = null;
                    }
                    Throwable cause = e.getCause();
                    System.err.println("Exception: " + cause.getMessage());
                    cause.printStackTrace();
                    System.exit(1);
                }
            }
            if (kernelImpl != null) {
                kernelImpl.destroy();
                kernelImpl = null;
            }
            System.exit(0);
        }
        if (kernelImpl != null) {
            kernelImpl.destroy();
            kernelImpl = null;
        }
        System.err.println("Command not found: " + args[0]);
        ScriptLauncher.display();
        System.exit(1);
    }

    private static Document getConfig() {
        String config = ConfigurationManager.getProperty("dspace.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "launcher.xml";
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxBuilder.build(config);
        }
        catch (Exception e) {
            System.err.println("Unable to load the launcher configuration file: [dspace]/config/launcher.xml");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return doc;
    }

    private static void display() {
        Document doc = ScriptLauncher.getConfig();
        List commands = doc.getRootElement().getChildren("command");
        System.out.println("Usage: dspace [command-name] {parameters}");
        for (Element command : commands) {
            System.out.println(" - " + command.getChild("name").getValue() + ": " + command.getChild("description").getValue());
        }
    }
}

