/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;

public class XPDF2Thumbnail
extends MediaFilter {
    private static Logger log = Logger.getLogger(XPDF2Thumbnail.class);
    private static final int MAX_PX = 800;
    private static final int MAX_DPI = 100;
    private static final String[] XPDF_PDFTOPPM_COMMAND = new String[]{"@COMMAND@", "-q", "-f", "1", "-l", "1", "-r", "@DPI@", "@FILE@", "@OUTPUTFILE@"};
    private static final String[] XPDF_PDFINFO_COMMAND = new String[]{"@COMMAND@", "-f", "1", "-l", "1", "-box", "@FILE@"};
    private String pdftoppmPath = null;
    private String pdfinfoPath = null;
    private static final Pattern MEDIABOX_PATT = Pattern.compile("^Page\\s+\\d+\\s+MediaBox:\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)");
    private int maxwidth = 0;
    private final int DEFAULT_MAXWIDTH = 500;

    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    public String getBundleName() {
        return "THUMBNAIL";
    }

    public String getFormatString() {
        return "JPEG";
    }

    public String getDescription() {
        return "Generated Thumbnail";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getDestinationStream(InputStream sourceStream) throws Exception {
        if (this.pdftoppmPath == null || this.pdfinfoPath == null) {
            this.pdftoppmPath = ConfigurationManager.getProperty("xpdf.path.pdftoppm");
            this.pdfinfoPath = ConfigurationManager.getProperty("xpdf.path.pdfinfo");
            if (this.pdftoppmPath == null) {
                throw new IllegalStateException("No value for key \"xpdf.path.pdftoppm\" in DSpace configuration!  Should be path to XPDF pdftoppm executable.");
            }
            if (this.pdfinfoPath == null) {
                throw new IllegalStateException("No value for key \"xpdf.path.pdfinfo\" in DSpace configuration!  Should be path to XPDF pdfinfo executable.");
            }
            this.maxwidth = ConfigurationManager.getIntProperty("thumbnail.maxwidth");
            if (this.maxwidth == 0) {
                this.maxwidth = 500;
            }
        }
        File sourceTmp = File.createTempFile("DSfilt", ".pdf");
        sourceTmp.deleteOnExit();
        int status = 0;
        BufferedImage source = null;
        try {
            FileOutputStream sto = new FileOutputStream(sourceTmp);
            Utils.copy(sourceStream, sto);
            ((OutputStream)sto).close();
            sourceStream.close();
            int dpi = 0;
            String[] pdfinfoCmd = (String[])XPDF_PDFINFO_COMMAND.clone();
            pdfinfoCmd[0] = this.pdfinfoPath;
            pdfinfoCmd[pdfinfoCmd.length - 1] = sourceTmp.toString();
            try {
                MatchResult mediaBox = null;
                Process pdfProc = Runtime.getRuntime().exec(pdfinfoCmd);
                BufferedReader lr = new BufferedReader(new InputStreamReader(pdfProc.getInputStream()));
                String line = lr.readLine();
                while (line != null) {
                    Matcher mm = MEDIABOX_PATT.matcher(line);
                    if (mm.matches()) {
                        mediaBox = mm.toMatchResult();
                    }
                    line = lr.readLine();
                }
                int istatus = pdfProc.waitFor();
                if (istatus != 0) {
                    log.error((Object)("XPDF pdfinfo proc failed, exit status=" + istatus + ", file=" + sourceTmp));
                }
                if (mediaBox == null) {
                    log.error((Object)("Sanity check: Did not find \"MediaBox\" line in output of XPDF pdfinfo, file=" + sourceTmp));
                    throw new IllegalArgumentException("Failed to get MediaBox of PDF with pdfinfo, cannot compute thumbnail.");
                }
                float x0 = Float.parseFloat(mediaBox.group(1));
                float y0 = Float.parseFloat(mediaBox.group(2));
                float x1 = Float.parseFloat(mediaBox.group(3));
                float y1 = Float.parseFloat(mediaBox.group(4));
                int maxdim = (int)Math.max(Math.abs(x1 - x0), Math.abs(y1 - y0));
                dpi = Math.min(100, 57600 / maxdim);
                log.debug((Object)("DPI: pdfinfo method got dpi=" + dpi + " for max dim=" + maxdim + " (points, 1/72\")"));
            }
            catch (InterruptedException e) {
                log.error((Object)"Failed transforming file for preview: ", (Throwable)e);
                throw new IllegalArgumentException("Failed transforming file for thumbnail: ", e);
            }
            catch (NumberFormatException e) {
                log.error((Object)"Failed interpreting pdfinfo results, check regexp: ", (Throwable)e);
                throw new IllegalArgumentException("Failed transforming file for thumbnail: ", e);
            }
            File outPrefixF = File.createTempFile("prevu", "out");
            String outPrefix = outPrefixF.toString();
            outPrefixF.delete();
            Object[] pdfCmd = (String[])XPDF_PDFTOPPM_COMMAND.clone();
            pdfCmd[0] = this.pdftoppmPath;
            pdfCmd[pdfCmd.length - 3] = String.valueOf(dpi);
            pdfCmd[pdfCmd.length - 2] = sourceTmp.toString();
            pdfCmd[pdfCmd.length - 1] = outPrefix;
            File outf = new File(outPrefix + "-000001.ppm");
            log.debug((Object)("Running xpdf command: " + Arrays.deepToString(pdfCmd)));
            try {
                Process pdfProc = Runtime.getRuntime().exec((String[])pdfCmd);
                status = pdfProc.waitFor();
                log.debug((Object)("PDFTOPPM output is: " + outf + ", exists=" + outf.exists()));
                source = ImageIO.read(outf);
            }
            catch (InterruptedException e) {
                log.error((Object)"Failed transforming file for preview: ", (Throwable)e);
                throw new IllegalArgumentException("Failed transforming file for preview: ", e);
            }
            finally {
                outf.delete();
            }
        }
        finally {
            sourceTmp.delete();
            if (status != 0) {
                log.error((Object)("PDF conversion proc failed, exit status=" + status + ", file=" + sourceTmp));
            }
        }
        if (source == null) {
            throw new IOException("Unknown failure while transforming file to preview: no image produced.");
        }
        BufferedImage toenail = XPDF2Thumbnail.scaleImage(source, this.maxwidth * 3 / 4, this.maxwidth);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)toenail, "jpeg", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static BufferedImage scaleImage(BufferedImage source, int min, int max) {
        int xsize = source.getWidth(null);
        int ysize = source.getHeight(null);
        int msize = Math.max(xsize, ysize);
        BufferedImage result = null;
        if (min == 0 && max == 0 || msize >= min && Math.min(xsize, ysize) <= max) {
            return source;
        }
        int xnew = xsize * max / msize;
        int ynew = ysize * max / msize;
        result = new BufferedImage(xnew, ynew, 1);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(source, 0, 0, xnew, ynew, null);
        return result;
    }
}

