/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.browse.BrowseOutput;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.Context;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexBrowse {
    private static Logger log = Logger.getLogger(IndexBrowse.class);
    private Context context;
    private boolean rebuild = false;
    private boolean delete = false;
    private int start = 1;
    private boolean execute = false;
    private boolean fileOut = false;
    private boolean stdOut = false;
    private String outFile = null;
    private boolean verbose = false;
    private BrowseIndex[] bis;
    private BrowseCreateDAO dao;
    private BrowseOutput output;

    public IndexBrowse() throws SQLException, BrowseException {
        this(new Context());
    }

    public IndexBrowse(Context context) throws SQLException, BrowseException {
        this.context = context;
        this.bis = BrowseIndex.getBrowseIndices();
        this.checkConfig();
        this.dao = BrowseDAOFactory.getCreateInstance(context);
        this.output = new BrowseOutput();
        for (int k = 0; k < this.bis.length; ++k) {
            this.bis[k].generateMdBits();
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.output.setVerbose(verbose);
    }

    public boolean rebuild() {
        return this.rebuild;
    }

    public void setRebuild(boolean bool) {
        this.rebuild = bool;
    }

    public boolean delete() {
        return this.delete;
    }

    public void setDelete(boolean bool) {
        this.delete = bool;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setExecute(boolean bool) {
        this.execute = bool;
    }

    public boolean execute() {
        return this.execute;
    }

    public void setFileOut(boolean bool) {
        this.fileOut = bool;
        this.output.setFile(bool);
    }

    public boolean isFileOut() {
        return this.fileOut;
    }

    public void setStdOut(boolean bool) {
        this.stdOut = bool;
        this.output.setPrint(bool);
    }

    public boolean toStdOut() {
        return this.stdOut;
    }

    public void setOutFile(String file) {
        this.outFile = file;
        this.output.setFileName(file);
    }

    public String getOutFile() {
        return this.outFile;
    }

    private void removeIndex(int itemID, String table) throws BrowseException {
        this.dao.deleteByItemID(table, itemID);
    }

    private void pruneIndexes() throws BrowseException {
        for (int i = 0; i < this.bis.length; ++i) {
            if (!this.bis[i].isMetadataIndex()) continue;
            log.debug((Object)("Pruning metadata index: " + this.bis[i].getTableName()));
            this.dao.pruneExcess(this.bis[i].getTableName(), this.bis[i].getMapTableName(), false);
            this.dao.pruneDistinct(this.bis[i].getDistinctTableName(), this.bis[i].getMapTableName());
        }
        this.dao.pruneExcess(BrowseIndex.getItemBrowseIndex().getTableName(), null, false);
        this.dao.pruneExcess(BrowseIndex.getWithdrawnBrowseIndex().getTableName(), null, true);
    }

    public void indexItem(Item item) throws BrowseException {
        if (item.isArchived() || item.isWithdrawn()) {
            this.indexItem(new ItemMetadataProxy(item));
            this.pruneIndexes();
        }
    }

    private void indexItem(ItemMetadataProxy item) throws BrowseException {
        HashMap itemMDMap = new HashMap();
        try {
            boolean reqCommunityMappings = false;
            Map<Integer, String> sortMap = this.getSortValues(item, itemMDMap);
            if (item.isArchived() && !item.isWithdrawn()) {
                if (!this.dao.updateIndex(BrowseIndex.getItemBrowseIndex().getTableName(), item.getID(), sortMap)) {
                    this.removeIndex(item.getID(), BrowseIndex.getWithdrawnBrowseIndex().getTableName());
                    this.dao.insertIndex(BrowseIndex.getItemBrowseIndex().getTableName(), item.getID(), sortMap);
                }
                reqCommunityMappings = true;
            } else if (item.isWithdrawn()) {
                if (!this.dao.updateIndex(BrowseIndex.getWithdrawnBrowseIndex().getTableName(), item.getID(), sortMap)) {
                    this.removeIndex(item.getID(), BrowseIndex.getItemBrowseIndex().getTableName());
                    this.dao.insertIndex(BrowseIndex.getWithdrawnBrowseIndex().getTableName(), item.getID(), sortMap);
                }
            } else {
                this.removeIndex(item.getID(), BrowseIndex.getItemBrowseIndex().getTableName());
                this.removeIndex(item.getID(), BrowseIndex.getWithdrawnBrowseIndex().getTableName());
            }
            if (reqCommunityMappings) {
                this.dao.updateCommunityMappings(item.getID());
            } else {
                this.dao.deleteCommunityMappings(item.getID());
            }
            for (int i = 0; i < this.bis.length; ++i) {
                log.debug((Object)("Indexing for item " + item.getID() + ", for index: " + this.bis[i].getTableName()));
                if (!this.bis[i].isMetadataIndex()) continue;
                HashSet<Integer> distIDSet = new HashSet<Integer>();
                if (item.isArchived() && !item.isWithdrawn()) {
                    block3: for (int mdIdx = 0; mdIdx < this.bis[i].getMetadataCount(); ++mdIdx) {
                        String[] md = this.bis[i].getMdBits(mdIdx);
                        DCValue[] values = item.getMetadata(md[0], md[1], md[2], "*");
                        if (values == null || values.length <= 0) continue;
                        int minConfidence = MetadataAuthorityManager.getManager().getMinConfidence(values[0].schema, values[0].element, values[0].qualifier);
                        for (int x = 0; x < values.length; ++x) {
                            if (StringUtils.isEmpty((String)values[x].value)) {
                                log.error((Object)("Null metadata value for item " + item.getID() + ", field: " + values[x].schema + "." + values[x].element + (values[x].qualifier == null ? "" : "." + values[x].qualifier)));
                                continue;
                            }
                            if (this.bis[i].isAuthorityIndex() && (values[x].authority == null || values[x].confidence < minConfidence)) {
                                log.debug((Object)("Skipping item=" + item.getID() + ", field=" + values[x].schema + "." + values[x].element + "." + values[x].qualifier + ", value=" + values[x].value + ", authority=" + values[x].authority + ", confidence=" + values[x].confidence + " (BAD AUTHORITY)"));
                                continue block3;
                            }
                            if (values[x].authority != null && values[x].confidence >= minConfidence) {
                                boolean isValueVariants = false;
                                List<String> variants = ChoiceAuthorityManager.getManager().getVariants(values[x].schema, values[x].element, values[x].qualifier, values[x].authority, values[x].language);
                                if (variants != null) {
                                    for (String var : variants) {
                                        String nVal = OrderFormat.makeSortString(var, values[x].language, this.bis[i].getDataType());
                                        distIDSet.add(this.dao.getDistinctID(this.bis[i].getDistinctTableName(), var, values[x].authority, nVal));
                                        if (!var.equals(values[x].value)) continue;
                                        isValueVariants = true;
                                    }
                                }
                                if (isValueVariants) continue;
                                String nVal = OrderFormat.makeSortString(values[x].value, values[x].language, this.bis[i].getDataType());
                                distIDSet.add(this.dao.getDistinctID(this.bis[i].getDistinctTableName(), values[x].value, values[x].authority, nVal));
                                continue;
                            }
                            String nVal = OrderFormat.makeSortString(values[x].value, values[x].language, this.bis[i].getDataType());
                            distIDSet.add(this.dao.getDistinctID(this.bis[i].getDistinctTableName(), values[x].value, null, nVal));
                        }
                    }
                }
                if (distIDSet.isEmpty()) {
                    this.removeIndex(item.getID(), this.bis[i].getMapTableName());
                    continue;
                }
                int[] distIDarr = new int[distIDSet.size()];
                int didx = 0;
                for (Integer distID : distIDSet) {
                    distIDarr[didx++] = distID;
                }
                this.dao.updateDistinctMappings(this.bis[i].getMapTableName(), item.getID(), distIDarr);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private Map<Integer, String> getSortValues(ItemMetadataProxy item, Map itemMDMap) throws BrowseException, SQLException {
        try {
            HashMap<Integer, String> sortMap = new HashMap<Integer, String>();
            for (SortOption so : SortOption.getSortOptions()) {
                Integer key = new Integer(so.getNumber());
                String metadata = so.getMetadata();
                DCValue value = null;
                if (itemMDMap != null) {
                    value = (DCValue)itemMDMap.get(metadata);
                }
                if (value == null) {
                    String[] somd = so.getMdBits();
                    DCValue[] dcv = item.getMetadata(somd[0], somd[1], somd[2], "*");
                    if (dcv == null) continue;
                    if (dcv.length > 0) {
                        value = dcv[0];
                        if (itemMDMap != null) {
                            itemMDMap.put(metadata, dcv[0]);
                        }
                    }
                }
                if (value == null || value.value == null) continue;
                String nValue = OrderFormat.makeSortString(value.value, value.language, so.getType());
                sortMap.put(key, nValue);
            }
            return sortMap;
        }
        catch (SortException se) {
            throw new BrowseException("Error in SortOptions", se);
        }
    }

    public boolean itemAdded(Item item) throws BrowseException {
        this.indexItem(item);
        return true;
    }

    public boolean itemChanged(Item item) throws BrowseException {
        this.indexItem(item);
        return true;
    }

    public boolean itemRemoved(Item item) throws BrowseException {
        return this.itemRemoved(item.getID());
    }

    public boolean itemRemoved(int itemID) throws BrowseException {
        for (int i = 0; i < this.bis.length; ++i) {
            if (!this.bis[i].isMetadataIndex()) continue;
            log.debug((Object)("Removing indexing for removed item " + itemID + ", for index: " + this.bis[i].getTableName()));
            this.removeIndex(itemID, this.bis[i].getMapTableName());
        }
        this.removeIndex(itemID, BrowseIndex.getItemBrowseIndex().getTableName());
        this.removeIndex(itemID, BrowseIndex.getWithdrawnBrowseIndex().getTableName());
        this.dao.deleteCommunityMappings(itemID);
        this.pruneIndexes();
        return true;
    }

    public static void main(String[] argv) throws SQLException, BrowseException, ParseException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        IndexBrowse indexer = new IndexBrowse(context);
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "tables", false, "create the tables only, do not attempt to index.  Mutually exclusive with -f and -i");
        options.addOption("i", "index", false, "actually do the indexing.  Mutually exclusive with -t and -f");
        options.addOption("f", "full", false, "make the tables, and do the indexing.  This forces -x.  Mutually exclusive with -t and -i");
        options.addOption("r", "rebuild", false, "should we rebuild all the indices, which removes old index tables and creates new ones.  For use with -f. Mutually exclusive with -d");
        options.addOption("d", "delete", false, "delete all the indices, but don't create new ones.  For use with -f. This is mutually exclusive with -r");
        options.addOption("o", "out", true, "[-o <filename>] write the remove and create SQL to the given file. For use with -t and -f");
        options.addOption("p", "print", false, "write the remove and create SQL to the stdout. For use with -t and -f");
        options.addOption("x", "execute", false, "execute all the remove and create SQL against the database. For use with -t and -f");
        options.addOption("s", "start", true, "[-s <int>] start from this index number and work upward (mostly only useful for debugging). For use with -t and -f");
        options.addOption("v", "verbose", false, "print extra information to the stdout.  If used in conjunction with -p, you cannot use the stdout to generate your database structure");
        options.addOption("h", "help", false, "show this help documentation.  Overrides all other arguments");
        CommandLine line = parser.parse(options, argv);
        if (line.hasOption("h")) {
            indexer.usage(options);
            return;
        }
        if (line.hasOption("v")) {
            indexer.setVerbose(true);
        }
        if (line.hasOption("i")) {
            indexer.createIndex();
            return;
        }
        if (line.hasOption("f")) {
            if (line.hasOption('r')) {
                indexer.setRebuild(true);
            } else if (line.hasOption("d")) {
                indexer.setDelete(true);
            }
        }
        if (line.hasOption("f") || line.hasOption("t")) {
            if (line.hasOption("s")) {
                indexer.setStart(Integer.parseInt(line.getOptionValue("s")));
            }
            if (line.hasOption("x")) {
                indexer.setExecute(true);
            }
            if (line.hasOption("p")) {
                indexer.setStdOut(true);
            }
            if (line.hasOption("o")) {
                indexer.setFileOut(true);
                indexer.setOutFile(line.getOptionValue("o"));
            }
        }
        if (line.hasOption("t")) {
            indexer.prepTables();
            return;
        }
        if (line.hasOption("f")) {
            indexer.setExecute(true);
            indexer.initBrowse();
            return;
        }
        indexer.usage(options);
        context.complete();
    }

    private void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("IndexBrowse", options);
    }

    private void prepTables() throws BrowseException {
        try {
            this.clearDatabase();
            this.createItemTables();
            for (int i = 0; i < this.bis.length; ++i) {
                this.createTables(this.bis[i]);
                StringBuffer logMe = new StringBuffer();
                for (SortOption so : SortOption.getSortOptions()) {
                    logMe.append(" ").append(so.getMetadata()).append(" ");
                }
                this.output.message("Creating browse index " + this.bis[i].getName() + ": index by " + this.bis[i].getMetadata() + " sortable by: " + logMe.toString());
            }
        }
        catch (SortException se) {
            throw new BrowseException("Error in SortOptions", se);
        }
    }

    public void clearDatabase() throws BrowseException {
        try {
            this.output.message("Deleting old indices");
            int i = this.getStart();
            while (true) {
                String tableName = BrowseIndex.getTableName(i, false, false, false, false);
                String distinctTableName = BrowseIndex.getTableName(i, false, false, true, false);
                String distinctMapName = BrowseIndex.getTableName(i, false, false, false, true);
                String sequence = BrowseIndex.getSequenceName(i, false, false);
                String mapSequence = BrowseIndex.getSequenceName(i, false, true);
                String distinctSequence = BrowseIndex.getSequenceName(i, true, false);
                String colViewName = BrowseIndex.getTableName(i, false, true, false, false);
                String comViewName = BrowseIndex.getTableName(i, true, false, false, false);
                String distinctColViewName = BrowseIndex.getTableName(i, false, true, false, true);
                String distinctComViewName = BrowseIndex.getTableName(i, true, false, false, true);
                this.output.message("Checking for " + tableName);
                if (this.dao.testTableExistance(tableName)) {
                    this.output.message("...found");
                    this.output.message("Deleting old index and associated resources: " + tableName);
                    String dropper = this.dao.dropIndexAndRelated(tableName, this.execute());
                    String dropSeq = this.dao.dropSequence(sequence, this.execute());
                    this.output.sql(dropper);
                    this.output.sql(dropSeq);
                    String dropColView = this.dao.dropView(colViewName, this.execute());
                    String dropComView = this.dao.dropView(comViewName, this.execute());
                    this.output.sql(dropColView);
                    this.output.sql(dropComView);
                }
                this.output.message("Checking for " + distinctTableName);
                if (!this.dao.testTableExistance(distinctTableName)) {
                    if (i >= this.bis.length && i >= 10) break;
                    this.output.message("... doesn't exist; but will carry on as there may be something that conflicts");
                } else {
                    this.output.message("...found");
                    this.output.message("Deleting old index and associated resources: " + distinctTableName);
                    String dropDistinctTable = this.dao.dropIndexAndRelated(distinctTableName, this.execute());
                    String dropMap = this.dao.dropIndexAndRelated(distinctMapName, this.execute());
                    String dropDistinctMapSeq = this.dao.dropSequence(mapSequence, this.execute());
                    String dropDistinctSeq = this.dao.dropSequence(distinctSequence, this.execute());
                    this.output.sql(dropDistinctTable);
                    this.output.sql(dropMap);
                    this.output.sql(dropDistinctMapSeq);
                    this.output.sql(dropDistinctSeq);
                    String dropDistinctColView = this.dao.dropView(distinctColViewName, this.execute());
                    String dropDistinctComView = this.dao.dropView(distinctComViewName, this.execute());
                    this.output.sql(dropDistinctColView);
                    this.output.sql(dropDistinctComView);
                }
                ++i;
            }
            this.output.message("... doesn't exist; no more tables to delete");
            this.dropItemTables(BrowseIndex.getItemBrowseIndex());
            this.dropItemTables(BrowseIndex.getWithdrawnBrowseIndex());
            if (this.execute()) {
                this.context.commit();
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private void dropItemTables(BrowseIndex bix) throws BrowseException {
        if (this.dao.testTableExistance(bix.getTableName())) {
            String tableName = bix.getTableName();
            String dropper = this.dao.dropIndexAndRelated(tableName, this.execute());
            String dropSeq = this.dao.dropSequence(bix.getSequenceName(false, false), this.execute());
            this.output.sql(dropper);
            this.output.sql(dropSeq);
            String colViewName = bix.getTableName(false, true, false, false);
            String comViewName = bix.getTableName(true, false, false, false);
            String dropColView = this.dao.dropView(colViewName, this.execute());
            String dropComView = this.dao.dropView(comViewName, this.execute());
            this.output.sql(dropColView);
            this.output.sql(dropComView);
        }
    }

    private void createItemTables() throws BrowseException {
        try {
            ArrayList<Integer> sortCols = new ArrayList<Integer>();
            for (SortOption so : SortOption.getSortOptions()) {
                sortCols.add(new Integer(so.getNumber()));
            }
            this.createItemTables(BrowseIndex.getItemBrowseIndex(), sortCols);
            this.createItemTables(BrowseIndex.getWithdrawnBrowseIndex(), sortCols);
            if (this.execute()) {
                this.context.commit();
            }
        }
        catch (SortException se) {
            throw new BrowseException("Error in SortOptions", se);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private void createItemTables(BrowseIndex bix, List<Integer> sortCols) throws BrowseException {
        String tableName = bix.getTableName();
        String itemSeq = this.dao.createSequence(bix.getSequenceName(false, false), this.execute());
        String itemTable = this.dao.createPrimaryTable(tableName, sortCols, this.execute);
        String[] itemIndices = this.dao.createDatabaseIndices(tableName, sortCols, false, this.execute());
        this.output.sql(itemSeq);
        this.output.sql(itemTable);
        for (int i = 0; i < itemIndices.length; ++i) {
            this.output.sql(itemIndices[i]);
        }
    }

    private void createTables(BrowseIndex bi) throws BrowseException {
        try {
            if (bi.isMetadataIndex()) {
                String distinctTableName = bi.getDistinctTableName();
                String distinctSeq = bi.getSequenceName(true, false);
                String distinctMapName = bi.getMapTableName();
                String mapSeq = bi.getSequenceName(false, true);
                String distinctTableSeq = this.dao.createSequence(distinctSeq, this.execute());
                String distinctMapSeq = this.dao.createSequence(mapSeq, this.execute());
                String createDistinctTable = this.dao.createDistinctTable(distinctTableName, this.execute());
                String createDistinctMap = this.dao.createDistinctMap(distinctTableName, distinctMapName, this.execute());
                String[] mapIndices = this.dao.createMapIndices(distinctTableName, distinctMapName, this.execute());
                this.output.sql(distinctTableSeq);
                this.output.sql(distinctMapSeq);
                this.output.sql(createDistinctTable);
                this.output.sql(createDistinctMap);
                for (int i = 0; i < mapIndices.length; ++i) {
                    this.output.sql(mapIndices[i]);
                }
            }
            if (this.execute()) {
                this.context.commit();
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    public void initBrowse() throws SQLException, BrowseException {
        Date start = new Date();
        this.output.message("Creating browse indexes for DSpace");
        Date initDate = new Date();
        long init = initDate.getTime() - start.getTime();
        this.output.message("init complete (" + Long.toString(init) + " ms)");
        if (this.delete()) {
            this.output.message("Deleting browse tables");
            this.clearDatabase();
            this.output.message("Browse tables deleted");
            return;
        }
        if (this.rebuild()) {
            this.output.message("Preparing browse tables");
            this.prepTables();
            this.output.message("Browse tables prepared");
        }
        Date prepDate = new Date();
        long prep = prepDate.getTime() - start.getTime();
        long prepinit = prepDate.getTime() - initDate.getTime();
        this.output.message("tables prepped (" + Long.toString(prep) + " ms, " + Long.toString(prepinit) + " ms)");
        int count = this.createIndex();
        this.context.complete();
        Date endDate = new Date();
        long end = endDate.getTime() - start.getTime();
        long endprep = endDate.getTime() - prepDate.getTime();
        this.output.message("content indexed (" + Long.toString(end) + " ms, " + Long.toString(endprep) + " ms)");
        this.output.message("Items indexed: " + Integer.toString(count));
        if (count > 0) {
            long overall = end / (long)count;
            long specific = endprep / (long)count;
            this.output.message("Overall average time per item: " + Long.toString(overall) + " ms");
            this.output.message("Index only average time per item: " + Long.toString(specific) + " ms");
        }
        this.output.message("Browse indexing completed");
    }

    private int createIndex() throws BrowseException {
        try {
            for (int k = 0; k < this.bis.length; ++k) {
                this.bis[k].generateMdBits();
            }
            BrowseItemDAO biDao = BrowseDAOFactory.getItemInstance(this.context);
            BrowseItem[] items = biDao.findAll();
            for (int j = 0; j < items.length; ++j) {
                this.indexItem(new ItemMetadataProxy(items[j].getID(), items[j]));
                this.context.commit();
                this.context.clearCache();
            }
            this.pruneIndexes();
            this.context.commit();
            return items.length;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    private void checkConfig() {
    }

    public String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }

    private class ItemMetadataProxy {
        private Item item;
        private BrowseItem browseItem;
        private int id;

        ItemMetadataProxy(Item item) {
            this.item = item;
            this.browseItem = null;
            this.id = 0;
        }

        ItemMetadataProxy(int id, BrowseItem browseItem) {
            this.item = null;
            this.browseItem = browseItem;
            this.id = id;
        }

        public DCValue[] getMetadata(String schema, String element, String qualifier, String lang) throws SQLException {
            if (this.item != null) {
                return this.item.getMetadata(schema, element, qualifier, lang);
            }
            return this.browseItem.getMetadata(schema, element, qualifier, lang);
        }

        public int getID() {
            if (this.item != null) {
                return this.item.getID();
            }
            return this.id;
        }

        public boolean isArchived() {
            if (this.item != null) {
                return this.item.isArchived();
            }
            return this.browseItem.isArchived();
        }

        public boolean isWithdrawn() {
            if (this.item != null) {
                return this.item.isWithdrawn();
            }
            return this.browseItem.isWithdrawn();
        }
    }
}

