/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoManager;
import org.dspace.handle.HandleManager;

public class InstallItem {
    public static Item installItem(Context c, InProgressSubmission is) throws SQLException, IOException, AuthorizeException {
        return InstallItem.installItem(c, is, null);
    }

    public static Item installItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        DCValue[] identifiers;
        DCValue[] currentDateIssued;
        Item item = is.getItem();
        DCDate liftDate = EmbargoManager.getEmbargoDate(c, item);
        DCDate now = DCDate.getCurrent();
        item.addDC("date", "accessioned", null, now.toString());
        if (liftDate == null) {
            item.addDC("date", "available", null, now.toString());
        }
        if ((currentDateIssued = item.getDC("date", "issued", "*")).length == 0) {
            DCDate issued = new DCDate();
            issued.setDateLocal(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
            item.addDC("date", "issued", null, issued.toString());
        }
        String handle = suppliedHandle == null ? HandleManager.createHandle(c, item) : HandleManager.createHandle(c, item, suppliedHandle);
        String handleref = HandleManager.getCanonicalForm(handle);
        boolean identifierExists = false;
        for (DCValue identifier : identifiers = item.getDC("identifier", "uri", "*")) {
            if (!handleref.equals(identifier.value)) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            item.addDC("identifier", "uri", null, handleref);
        }
        String provDescription = "Made available in DSpace on " + now + " (GMT). " + InstallItem.getBitstreamProvenanceMessage(item);
        if (currentDateIssued.length != 0) {
            DCDate d = new DCDate(currentDateIssued[0].value);
            provDescription = provDescription + "  Previous issue date: " + d.toString();
        }
        item.addDC("description", "provenance", "en", provDescription);
        is.getCollection().addItem(item);
        item.setOwningCollection(is.getCollection());
        item.setArchived(true);
        item.update();
        is.deleteWrapper();
        item.inheritCollectionDefaultPolicies(is.getCollection());
        if (liftDate != null) {
            EmbargoManager.setEmbargo(c, item, liftDate);
        }
        return item;
    }

    public static String getBitstreamProvenanceMessage(Item myitem) throws SQLException {
        Bitstream[] bitstreams = myitem.getNonInternalBitstreams();
        String mymessage = "No. of bitstreams: " + bitstreams.length + "\n";
        for (int j = 0; j < bitstreams.length; ++j) {
            mymessage = mymessage + bitstreams[j].getName() + ": " + bitstreams[j].getSize() + " bytes, checksum: " + bitstreams[j].getChecksum() + " (" + bitstreams[j].getChecksumAlgorithm() + ")\n";
        }
        return mymessage;
    }
}

