/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class I18nUtil {
    private static final Logger log = Logger.getLogger(I18nUtil.class);
    public static final Locale DEFAULTLOCALE = I18nUtil.getDefaultLocale();
    private static final String LOCALE_DELIMITERS = " _.";

    public static Locale getDefaultLocale() {
        Locale defaultLocale = null;
        if (ConfigurationManager.getProperty("default.locale") != null && ConfigurationManager.getProperty("default.locale") != "") {
            defaultLocale = I18nUtil.makeLocale(ConfigurationManager.getProperty("default.locale"));
        }
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    private static Locale makeLocale(String localeSpec) {
        StringTokenizer st = new StringTokenizer(localeSpec, LOCALE_DELIMITERS);
        int countTokens = st.countTokens();
        switch (countTokens) {
            case 1: {
                return new Locale(st.nextToken().trim());
            }
            case 2: {
                return new Locale(st.nextToken().trim(), st.nextToken().trim());
            }
            case 3: {
                return new Locale(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
            }
        }
        return null;
    }

    public static Locale getEPersonLocale(EPerson ep) {
        if (ep == null) {
            log.error((Object)"No EPerson specified, returning default locale");
            return I18nUtil.getDefaultLocale();
        }
        String lang = ep.getLanguage();
        if (StringUtils.isBlank((String)lang)) {
            log.error((Object)("No language specified for EPerson " + ep.getID()));
            return I18nUtil.getDefaultLocale();
        }
        return I18nUtil.getSupportedLocale(new Locale(lang));
    }

    public static Locale[] getSupportedLocales() {
        String ll = ConfigurationManager.getProperty("webui.supported.locales");
        if (ll != null) {
            return I18nUtil.parseLocales(ll);
        }
        Locale[] availableLocales = new Locale[]{DEFAULTLOCALE};
        return availableLocales;
    }

    public static Locale getSupportedLocale(Locale locale) {
        Locale[] availableLocales = I18nUtil.getSupportedLocales();
        boolean isSupported = false;
        Locale supportedLocale = null;
        String testLocale = "";
        if (availableLocales == null) {
            supportedLocale = DEFAULTLOCALE;
        } else {
            int i;
            if (!locale.getVariant().equals("")) {
                testLocale = locale.toString();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!testLocale.equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported || !locale.getCountry().equals("")) {
                testLocale = locale.getLanguage() + "_" + locale.getCountry();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!testLocale.equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported) {
                testLocale = locale.getLanguage();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!testLocale.equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported) {
                supportedLocale = DEFAULTLOCALE;
            }
        }
        return supportedLocale;
    }

    public static String getInputFormsFileName(Locale locale) {
        String fileName = "";
        String FORM_DEF_FILE = "input-forms";
        String FILE_TYPE = ".xml";
        String defsFilename = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "input-forms";
        fileName = I18nUtil.getFilename(locale, defsFilename, ".xml");
        return fileName;
    }

    public static String getMessage(String key) throws MissingResourceException {
        String message = I18nUtil.getMessage(key.trim(), DEFAULTLOCALE);
        return message;
    }

    public static String getMessage(String key, Locale locale) throws MissingResourceException {
        String message = "";
        if (locale == null) {
            locale = DEFAULTLOCALE;
        }
        ResourceBundle messages = ResourceBundle.getBundle("Messages", locale);
        message = messages.getString(key.trim());
        return message;
    }

    public static String getMessage(String key, Context c) throws MissingResourceException {
        String message = I18nUtil.getMessage(key.trim(), c.getCurrentLocale());
        return message;
    }

    public static String getDefaultLicense(Context context) {
        Locale locale = context.getCurrentLocale();
        String fileName = "";
        String DEF_LIC_FILE = "default";
        String FILE_TYPE = ".license";
        String defsFilename = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "default";
        fileName = I18nUtil.getFilename(locale, defsFilename, ".license");
        return fileName;
    }

    private static String getFilename(Locale locale, String fileName, String fileType) {
        File fileTmp;
        String localizedFileName = null;
        boolean fileFound = false;
        String fileNameLCV = null;
        String fileNameLC = null;
        String fileNameL = null;
        fileNameL = fileName + "_" + locale.getLanguage();
        if (fileType == null) {
            fileType = "";
        }
        if (!"".equals(locale.getCountry())) {
            fileNameLC = fileName + "_" + locale.getLanguage() + "_" + locale.getCountry();
            if (!"".equals(locale.getVariant())) {
                fileNameLCV = fileName + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
            }
        }
        if (fileNameLCV != null && !fileFound && (fileTmp = new File(fileNameLCV + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameLCV + fileType;
        }
        if (fileNameLC != null && !fileFound && (fileTmp = new File(fileNameLC + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameLC + fileType;
        }
        if (fileNameL != null && !fileFound && (fileTmp = new File(fileNameL + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameL + fileType;
        }
        if (!fileFound) {
            localizedFileName = fileName + fileType;
        }
        return localizedFileName;
    }

    public static String getEmailFilename(Locale locale, String name) {
        String templateName = "";
        String templateFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "emails" + File.separator + name;
        templateName = I18nUtil.getFilename(locale, templateFile, "");
        return templateName;
    }

    public static Locale[] parseLocales(String ll) {
        ArrayList<Locale> resultList = new ArrayList<Locale>();
        for (String ls : ll.trim().split("\\s*,\\s*")) {
            Locale lc = I18nUtil.makeLocale(ls);
            if (lc == null) continue;
            resultList.add(lc);
        }
        return resultList.toArray(new Locale[resultList.size()]);
    }
}

