/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestedItem;

public class HarvestConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(HarvestConsumer.class);

    public void initialize() throws Exception {
    }

    public void consume(Context context, Event event) throws Exception {
        int st = event.getSubjectType();
        int et = event.getEventType();
        int id = event.getSubjectID();
        switch (st) {
            case 2: {
                if (et != 32) break;
                HarvestedItem hi = HarvestedItem.find(context, id);
                if (hi != null) {
                    log.debug((Object)("Deleted item '" + id + "', also deleting associated harvested_item '" + hi.getOaiID() + "'."));
                    hi.delete();
                    hi.update();
                    break;
                }
                log.debug((Object)("Deleted item '" + id + "' and the associated harvested_item."));
                break;
            }
            case 3: {
                if (et == 32) {
                    HarvestedCollection hc = HarvestedCollection.find(context, id);
                    if (hc != null) {
                        log.debug((Object)("Deleted collection '" + id + "', also deleting associated harvested_collection '" + hc.getOaiSource() + ":" + hc.getOaiSetId() + "'."));
                        hc.delete();
                        hc.update();
                    } else {
                        log.debug((Object)("Deleted collection '" + id + "' and the associated harvested_collection."));
                    }
                }
            }
            default: {
                log.warn((Object)("consume() got unrecognized event: " + event.toString()));
            }
        }
    }

    public void end(Context ctx) throws Exception {
    }

    public void finish(Context ctx) {
    }
}

