/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.dspace.app.bulkedit.DSpaceCSV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSpaceCSVLine {
    private int id;
    private Hashtable<String, ArrayList> items;

    public DSpaceCSVLine(int id) {
        this.id = id;
        this.items = new Hashtable();
    }

    public DSpaceCSVLine() {
        this.id = -1;
        this.items = new Hashtable();
    }

    public int getID() {
        return this.id;
    }

    public void add(String key, String value) {
        if (this.items.get(key) == null) {
            this.items.put(key, new ArrayList());
        }
        if (value != null) {
            this.items.get(key).add(value);
        }
    }

    public ArrayList<String> get(String key) {
        return this.items.get(key);
    }

    public Enumeration<String> keys() {
        return this.items.keys();
    }

    protected String toCSV(ArrayList<String> headings) {
        String bits = "\"" + this.id + "\"" + DSpaceCSV.fieldSeparator;
        bits = bits + this.valueToCSV(this.items.get("collection")) + DSpaceCSV.fieldSeparator;
        Iterator<String> i = headings.iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (this.items.get(key) != null && !"collection".equals(key)) {
                bits = bits + this.valueToCSV(this.items.get(key));
            }
            if (!i.hasNext()) continue;
            bits = bits + DSpaceCSV.fieldSeparator;
        }
        return bits;
    }

    private String valueToCSV(ArrayList<String> values) {
        String s = "";
        if (values == null) {
            return s;
        }
        if (values.size() == 1) {
            s = values.get(0);
        } else {
            Iterator<String> i = values.iterator();
            while (i.hasNext()) {
                s = s + i.next();
                if (!i.hasNext()) continue;
                s = s + DSpaceCSV.valueSeparator;
            }
        }
        s = s.replaceAll("\"", "\"\"");
        s = "\"" + s + "\"";
        return s;
    }
}

