/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.itemupdate.UpdateBitstreamsAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class DeleteBitstreamsAction
extends UpdateBitstreamsAction {
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws IllegalArgumentException, IOException, SQLException, AuthorizeException, ParseException {
        File f = new File(itarch.getDirectory(), "delete_contents");
        if (!f.exists()) {
            ItemUpdate.pr("Warning: Delete_contents file for item " + itarch.getDirectoryName() + " not found.");
        } else {
            List<Integer> list = MetadataUtilities.readDeleteContentsFile(f);
            if (list.isEmpty()) {
                ItemUpdate.pr("Warning: empty delete_contents file for item " + itarch.getDirectoryName());
            } else {
                for (int id : list) {
                    try {
                        Bundle[] bundles;
                        Bitstream bs = Bitstream.find(context, id);
                        if (bs == null) {
                            ItemUpdate.pr("Bitstream not found by id: " + id);
                            continue;
                        }
                        for (Bundle b : bundles = bs.getBundles()) {
                            if (isTest) {
                                ItemUpdate.pr("Delete bitstream with id = " + id);
                                continue;
                            }
                            b.removeBitstream(bs);
                            ItemUpdate.pr("Deleted bitstream with id = " + id);
                        }
                        if (!this.alterProvenance) continue;
                        DtoMetadata dtom = DtoMetadata.create("dc.description.provenance", "en", "");
                        String append = "Bitstream " + bs.getName() + " deleted on " + DCDate.getCurrent() + "; ";
                        Item item = bundles[0].getItems()[0];
                        ItemUpdate.pr("Append provenance with: " + append);
                        if (isTest) continue;
                        MetadataUtilities.appendMetadata(item, dtom, false, append);
                    }
                    catch (SQLException e) {
                        ItemUpdate.pr("Error finding bitstream from id: " + id + " : " + e.toString());
                    }
                }
            }
        }
    }
}

