/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.packager;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

public class Packager {
    private static void usageError(String msg) {
        System.out.println(msg);
        System.out.println(" (run with -h flag for details)");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        String[] files;
        int i;
        Options options = new Options();
        options.addOption("c", "collection", true, "destination collection(s) Handle (repeatable)");
        options.addOption("e", "eperson", true, "email address of eperson doing importing");
        options.addOption("w", "install", false, "disable workflow; install immediately without going through collection's workflow");
        options.addOption("t", "type", true, "package type or MIMEtype");
        options.addOption("o", "option", true, "Packager option to pass to plugin, \"name=value\" (repeatable)");
        options.addOption("d", "disseminate", false, "Disseminate package (output); default is to submit.");
        options.addOption("i", "item", true, "Handle of item to disseminate.");
        options.addOption("h", "help", false, "help");
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(options, argv);
        String sourceFile = null;
        String eperson = null;
        String[] collections = null;
        boolean useWorkflow = true;
        String packageType = null;
        boolean submit = true;
        String itemHandle = null;
        PackageParameters pkgParams = new PackageParameters();
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("Packager  [options]  package-file|-\n", options);
            System.out.println("\nAvailable Submission Package (SIP) types:");
            String[] pn = PluginManager.getAllPluginNames(PackageIngester.class);
            for (i = 0; i < pn.length; ++i) {
                System.out.println("  " + pn[i]);
            }
            System.out.println("\nAvailable Dissemination Package (DIP) types:");
            pn = PluginManager.getAllPluginNames(PackageDisseminator.class);
            for (i = 0; i < pn.length; ++i) {
                System.out.println("  " + pn[i]);
            }
            System.exit(0);
        }
        if (line.hasOption('w')) {
            useWorkflow = false;
        }
        if (line.hasOption('e')) {
            eperson = line.getOptionValue('e');
        }
        if (line.hasOption('c')) {
            collections = line.getOptionValues('c');
        }
        if (line.hasOption('t')) {
            packageType = line.getOptionValue('t');
        }
        if (line.hasOption('i')) {
            itemHandle = line.getOptionValue('i');
        }
        if ((files = line.getArgs()).length > 0) {
            sourceFile = files[0];
        }
        if (line.hasOption('d')) {
            submit = false;
        }
        if (line.hasOption('o')) {
            String[] popt = line.getOptionValues('o');
            for (i = 0; i < popt.length; ++i) {
                String[] pair = popt[i].split("\\=", 2);
                if (pair.length == 2) {
                    pkgParams.addProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                if (pair.length == 1) {
                    pkgParams.addProperty(pair[0].trim(), "");
                    continue;
                }
                System.err.println("Warning: Illegal package option format: \"" + popt[i] + "\"");
            }
        }
        if (sourceFile == null || eperson == null || packageType == null || submit && collections == null) {
            System.err.println("Error - missing a REQUIRED argument or option.\n");
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("PackageManager  [options]  package-file|-\n", options);
            System.exit(0);
        }
        Context context = new Context();
        EPerson myEPerson = null;
        myEPerson = EPerson.findByEmail(context, eperson);
        if (myEPerson == null) {
            Packager.usageError("Error, eperson cannot be found: " + eperson);
        }
        context.setCurrentUser(myEPerson);
        if (submit) {
            InputStream source = sourceFile.equals("-") ? System.in : new FileInputStream(sourceFile);
            PackageIngester sip = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, packageType);
            if (sip == null) {
                Packager.usageError("Error, Unknown package type: " + packageType);
            }
            Collection[] mycollections = null;
            System.out.println("Destination collections:");
            mycollections = new Collection[collections.length];
            for (int i2 = 0; i2 < collections.length; ++i2) {
                DSpaceObject dso = HandleManager.resolveToObject(context, collections[i2]);
                if (dso == null) {
                    throw new IllegalArgumentException("Bad collection list -- Cannot resolve collection handle \"" + collections[i2] + "\"");
                }
                if (dso.getType() != 3) {
                    throw new IllegalArgumentException("Bad collection list -- Object at handle \"" + collections[i2] + "\" is not a collection!");
                }
                mycollections[i2] = (Collection)dso;
                System.out.println((i2 == 0 ? "  Owning " : "  ") + " Collection: " + mycollections[i2].getMetadata("name"));
            }
            try {
                WorkspaceItem wi = sip.ingest(context, mycollections[0], source, pkgParams, null);
                if (useWorkflow) {
                    String handle = null;
                    WorkflowItem wfi = WorkflowManager.startWithoutNotify(context, wi);
                    if (wfi.getState() == 7) {
                        Item ni = wfi.getItem();
                        handle = HandleManager.findHandle(context, ni);
                    }
                    if (handle == null) {
                        System.out.println("Created Workflow item, ID=" + String.valueOf(wfi.getID()));
                    } else {
                        System.out.println("Created and installed item, handle=" + handle);
                    }
                } else {
                    InstallItem.installItem(context, wi);
                    System.out.println("Created and installed item, handle=" + HandleManager.findHandle(context, wi.getItem()));
                }
                context.complete();
                System.exit(0);
            }
            catch (Exception e) {
                context.abort();
                e.printStackTrace();
                System.out.println(e);
                System.exit(1);
            }
        } else {
            DSpaceObject dso;
            OutputStream dest = sourceFile.equals("-") ? System.out : new FileOutputStream(sourceFile);
            PackageDisseminator dip = (PackageDisseminator)PluginManager.getNamedPlugin(PackageDisseminator.class, packageType);
            if (dip == null) {
                Packager.usageError("Error, Unknown package type: " + packageType);
            }
            if ((dso = HandleManager.resolveToObject(context, itemHandle)) == null) {
                throw new IllegalArgumentException("Bad Item handle -- Cannot resolve handle \"" + itemHandle);
            }
            dip.disseminate(context, dso, pkgParams, dest);
        }
    }
}

