/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseManager;

public class DAOSupport {
    private static final Logger LOG = Logger.getLogger(DAOSupport.class);

    protected void cleanup(Statement stmt, Connection conn) {
        this.cleanup(stmt);
        if (conn != null) {
            DatabaseManager.freeConnection(conn);
        }
    }

    protected void cleanup(Statement stmt, Connection conn, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)("Problem closing result set. " + e.getMessage()), (Throwable)e);
            }
        }
        this.cleanup(stmt);
        if (conn != null) {
            DatabaseManager.freeConnection(conn);
        }
    }

    protected void cleanup(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)("Problem closing prepared statement. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void cleanup(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)e);
            }
        }
    }
}

