/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumHistory;
import org.dspace.checker.DSpaceBitstreamInfo;
import org.dspace.checker.ReporterDAO;
import org.dspace.checker.SimpleReporter;
import org.dspace.core.I18nUtil;

public class SimpleReporterImpl
implements SimpleReporter {
    private static Logger LOG = Logger.getLogger(SimpleReporterImpl.class);
    private static final DateFormat DATE_FORMAT_MAX = DateFormat.getDateInstance(2);
    private static final DateFormat DATE_FORMAT_MIN = DateFormat.getDateInstance(3);
    private ReporterDAO reporter = new ReporterDAO();

    private String msg(String key) {
        return I18nUtil.getMessage("org.dspace.checker.SimpleReporterImpl." + key);
    }

    public int getDeletedBitstreamReport(Date startDate, Date endDate, OutputStreamWriter osw) throws IOException {
        List history = this.reporter.getBitstreamResultTypeReport(startDate, endDate, "BITSTREAM_MARKED_DELETED");
        osw.write("\n");
        osw.write(this.msg("deleted-bitstream-intro"));
        osw.write(DATE_FORMAT_MIN.format(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(DATE_FORMAT_MIN.format(endDate));
        osw.write("\n\n\n");
        if (history.size() == 0) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-to-delete"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    public int getChangedChecksumReport(Date startDate, Date endDate, OutputStreamWriter osw) throws IOException {
        List history = this.reporter.getBitstreamResultTypeReport(startDate, endDate, "CHECKSUM_NO_MATCH");
        osw.write("\n");
        osw.write(this.msg("checksum-did-not-match"));
        osw.write(" ");
        osw.write("\n");
        osw.write(DATE_FORMAT_MIN.format(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(DATE_FORMAT_MIN.format(endDate));
        osw.write("\n\n\n");
        if (history.size() == 0) {
            osw.write("\n\n");
            osw.write(this.msg("no-changed-bitstreams"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    public int getBitstreamNotFoundReport(Date startDate, Date endDate, OutputStreamWriter osw) throws IOException {
        List history = this.reporter.getBitstreamResultTypeReport(startDate, endDate, "BITSTREAM_NOT_FOUND");
        osw.write("\n");
        osw.write(this.msg("bitstream-not-found-report"));
        osw.write(DATE_FORMAT_MIN.format(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(DATE_FORMAT_MIN.format(endDate));
        osw.write("\n\n\n");
        if (history.size() == 0) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-changed"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    public int getNotToBeProcessedReport(Date startDate, Date endDate, OutputStreamWriter osw) throws IOException {
        List history = this.reporter.getNotProcessedBitstreamsReport(startDate, endDate);
        osw.write("\n");
        osw.write(this.msg("bitstream-will-no-longer-be-processed"));
        osw.write(" ");
        osw.write(DATE_FORMAT_MIN.format(startDate));
        osw.write(" ");
        osw.write(this.msg("date-range-to"));
        osw.write(" ");
        osw.write(DATE_FORMAT_MIN.format(endDate));
        osw.write("\n\n\n");
        if (history.size() == 0) {
            osw.write("\n\n");
            osw.write(this.msg("no-bitstreams-to-no-longer-be-processed"));
            osw.write("\n");
        } else {
            this.printHistoryRecords(history, osw);
        }
        return history.size();
    }

    public int getUncheckedBitstreamsReport(OutputStreamWriter osw) throws IOException {
        List bitstreams = this.reporter.getUnknownBitstreams();
        osw.write("\n");
        osw.write(this.msg("unchecked-bitstream-report"));
        osw.write(DATE_FORMAT_MIN.format(new Date()));
        osw.write("\n\n\n");
        if (bitstreams.size() == 0) {
            osw.write("\n\n");
            osw.write(this.msg("no-unchecked-bitstreams"));
            osw.write("\n");
        } else {
            osw.write(this.msg("howto-add-unchecked-bitstreams"));
            osw.write("\n\n\n");
            this.printDSpaceInfoRecords(bitstreams, osw);
        }
        return bitstreams.size();
    }

    private void printHistoryRecords(List history, OutputStreamWriter osw) throws IOException {
        for (ChecksumHistory historyInfo : history) {
            StringBuffer buf = new StringBuffer(1000);
            buf.append("------------------------------------------------ \n");
            buf.append(this.msg("bitstream-id")).append(" = ").append(historyInfo.getBitstreamId()).append("\n");
            buf.append(this.msg("process-start-date")).append(" = ").append(DATE_FORMAT_MAX.format(historyInfo.getProcessStartDate())).append("\n");
            buf.append(this.msg("process-end-date")).append(" = ").append(DATE_FORMAT_MAX.format(historyInfo.getProcessEndDate())).append("\n");
            buf.append(this.msg("checksum-expected")).append(" = ").append(historyInfo.getChecksumExpected()).append("\n");
            buf.append(this.msg("checksum-calculated")).append(" = ").append(historyInfo.getChecksumCalculated()).append("\n");
            buf.append(this.msg("result")).append(" = ").append(historyInfo.getResult()).append("\n");
            buf.append("----------------------------------------------- \n\n");
            osw.write(buf.toString());
        }
    }

    private void printDSpaceInfoRecords(List bitstreams, OutputStreamWriter osw) throws IOException {
        for (DSpaceBitstreamInfo info : bitstreams) {
            StringBuffer buf = new StringBuffer(1000);
            buf.append("------------------------------------------------ \n");
            buf.append(this.msg("format-id")).append(" =  ").append(info.getBitstreamFormatId()).append("\n");
            buf.append(this.msg("deleted")).append(" = ").append(info.getDeleted()).append("\n");
            buf.append(this.msg("bitstream-id")).append(" = ").append(info.getBitstreamId()).append("\n");
            buf.append(this.msg("checksum-algorithm")).append(" = ").append(info.getChecksumAlgorithm()).append("\n");
            buf.append(this.msg("internal-id")).append(" = ").append(info.getInternalId()).append("\n");
            buf.append(this.msg("name")).append(" = ").append(info.getName()).append("\n");
            buf.append(this.msg("size")).append(" = ").append(info.getSize()).append("\n");
            buf.append(this.msg("source")).append(" = ").append(info.getSource()).append("\n");
            buf.append(this.msg("checksum")).append(" = ").append(info.getStoredChecksum()).append("\n");
            buf.append(this.msg("store-number")).append(" = ").append(info.getStoreNumber()).append("\n");
            buf.append(this.msg("description")).append(" = ").append(info.getUserFormatDescription()).append("\n");
            buf.append("----------------------------------------------- \n\n");
            osw.write(buf.toString());
        }
    }
}

