/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class MetadataValue {
    private int fieldId = 0;
    private int valueId = 0;
    private int itemId;
    public String value;
    public String language;
    public int place = 1;
    public String authority = null;
    public int confidence = 0;
    private static Logger log = Logger.getLogger(MetadataValue.class);
    private TableRow row;

    public MetadataValue(TableRow row) {
        if (row != null) {
            this.fieldId = row.getIntColumn("metadata_field_id");
            this.valueId = row.getIntColumn("metadata_value_id");
            this.itemId = row.getIntColumn("item_id");
            this.value = row.getStringColumn("text_value");
            this.language = row.getStringColumn("text_lang");
            this.place = row.getIntColumn("place");
            this.authority = row.getStringColumn("authority");
            this.confidence = row.getIntColumn("confidence");
            this.row = row;
        }
    }

    public MetadataValue() {
    }

    public MetadataValue(MetadataField field) {
        this.fieldId = field.getFieldID();
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getPlace() {
        return this.place;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public int getValueId() {
        return this.valueId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String value) {
        this.authority = value;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public void setConfidence(int value) {
        this.confidence = value;
    }

    public void create(Context context) throws SQLException, AuthorizeException {
        this.row = DatabaseManager.row("MetadataValue");
        this.row.setColumn("item_id", this.itemId);
        this.row.setColumn("metadata_field_id", this.fieldId);
        this.row.setColumn("text_value", this.value);
        this.row.setColumn("text_lang", this.language);
        this.row.setColumn("place", this.place);
        this.row.setColumn("authority", this.authority);
        this.row.setColumn("confidence", this.confidence);
        DatabaseManager.insert(context, this.row);
        this.valueId = this.row.getIntColumn("metadata_value_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataValue find(Context context, int valueId) throws IOException, SQLException, AuthorizeException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataValue", "SELECT * FROM MetadataValue where metadata_value_id= ? ", valueId);
        TableRow row = null;
        try {
            if (tri.hasNext()) {
                row = tri.next();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        if (row == null) {
            return null;
        }
        return new MetadataValue(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection findByField(Context context, int fieldId) throws IOException, SQLException, AuthorizeException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataValue", "SELECT * FROM MetadataValue WHERE metadata_field_id= ? ", fieldId);
        TableRow row = null;
        ArrayList<MetadataValue> ret = new ArrayList<MetadataValue>();
        try {
            while (tri.hasNext()) {
                row = tri.next();
                ret.add(new MetadataValue(row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return ret;
    }

    public void update(Context context) throws SQLException, AuthorizeException {
        this.row.setColumn("item_id", this.itemId);
        this.row.setColumn("metadata_field_id", this.fieldId);
        this.row.setColumn("text_value", this.value);
        this.row.setColumn("text_lang", this.language);
        this.row.setColumn("place", this.place);
        this.row.setColumn("authority", this.authority);
        this.row.setColumn("confidence", this.confidence);
        DatabaseManager.update(context, this.row);
        log.info((Object)LogManager.getHeader(context, "update_metadatavalue", "metadata_value_id=" + this.getValueId()));
    }

    public void delete(Context context) throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(context, "delete_metadata_value", " metadata_value_id=" + this.getValueId()));
        DatabaseManager.delete(context, this.row);
    }
}

