/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class AccountManager {
    private static Logger log = Logger.getLogger(AccountManager.class);

    protected AccountManager() {
    }

    public static void sendRegistrationInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        AccountManager.sendInfo(context, email, true, true);
    }

    public static void sendForgotPasswordInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        AccountManager.sendInfo(context, email, false, true);
    }

    public static EPerson getEPerson(Context context, String token) throws SQLException, AuthorizeException {
        String email = AccountManager.getEmail(context, token);
        if (email == null) {
            return null;
        }
        EPerson ep = EPerson.findByEmail(context, email);
        return ep;
    }

    public static String getEmail(Context context, String token) throws SQLException {
        TableRow rd = DatabaseManager.findByUnique(context, "RegistrationData", "token", token);
        if (rd == null) {
            return null;
        }
        return rd.getStringColumn("email");
    }

    public static void deleteToken(Context context, String token) throws SQLException {
        DatabaseManager.deleteByValue(context, "RegistrationData", "token", token);
    }

    protected static TableRow sendInfo(Context context, String email, boolean isRegister, boolean send) throws SQLException, IOException, MessagingException, AuthorizeException {
        TableRow rd = DatabaseManager.findByUnique(context, "registrationdata", "email", email);
        if (rd == null) {
            rd = DatabaseManager.create(context, "RegistrationData");
            rd.setColumn("token", Utils.generateHexKey());
            rd.setColumn("email", email);
            DatabaseManager.update(context, rd);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created callback " + rd.getIntColumn("registrationdata_id") + " with token " + rd.getStringColumn("token") + " with email \"" + email + "\""));
            }
        }
        if (send) {
            AccountManager.sendEmail(context, email, isRegister, rd);
        }
        return rd;
    }

    private static void sendEmail(Context context, String email, boolean isRegister, TableRow rd) throws MessagingException, IOException, SQLException {
        String base = ConfigurationManager.getProperty("dspace.url");
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append(isRegister ? "register" : "forgot").append("?").append("token=").append(rd.getStringColumn("token")).toString();
        Locale locale = context.getCurrentLocale();
        Email bean = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(locale, isRegister ? "register" : "change_password"));
        bean.addRecipient(email);
        bean.addArgument(specialLink);
        bean.send();
        if (log.isInfoEnabled()) {
            log.info((Object)("Sent " + (isRegister ? "registration" : "account") + " information to " + email));
        }
    }

    private static Timestamp getDefaultExpirationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(3, 52);
        return new Timestamp(calendar.getTime().getTime());
    }
}

