/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public class XSLTIngestionCrosswalk
extends XSLTCrosswalk
implements IngestionCrosswalk {
    private static final Logger log = Logger.getLogger(XSLTIngestionCrosswalk.class);
    private static final String DIRECTION = "submission";
    private static String[] aliases = XSLTIngestionCrosswalk.makeAliases("submission");

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private static void applyDim(List<Element> dimList, Item item) throws MetadataValidationException {
        for (Element elt : dimList) {
            if ("field".equals(elt.getName()) && DIM_NS.equals((Object)elt.getNamespace())) {
                XSLTIngestionCrosswalk.applyDimField(elt, item);
                continue;
            }
            if ("dim".equals(elt.getName()) && DIM_NS.equals((Object)elt.getNamespace())) {
                XSLTIngestionCrosswalk.applyDim(elt.getChildren(), item);
                continue;
            }
            log.error((Object)("Got unexpected element in DIM list: " + elt.toString()));
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
    }

    private static void applyDimField(Element field, Item item) {
        String schema = field.getAttributeValue("mdschema");
        String element = field.getAttributeValue("element");
        String qualifier = field.getAttributeValue("qualifier");
        String lang = field.getAttributeValue("lang");
        String authority = field.getAttributeValue("authority");
        String sconf = field.getAttributeValue("confidence");
        if (qualifier != null && qualifier.equals("")) {
            qualifier = null;
        }
        if (authority != null && authority.length() > 0 || sconf != null && sconf.length() > 0) {
            int confidence = sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : -1;
            item.addMetadata(schema, element, qualifier, lang, field.getText(), authority, confidence);
        } else {
            item.addMetadata(schema, element, qualifier, lang, field.getText());
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            List dimList = xform.transform(metadata);
            XSLTIngestionCrosswalk.ingestDIM(context, dso, dimList);
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString(), e);
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            Document dimDoc = xform.transform(new Document((Element)root.clone()));
            XSLTIngestionCrosswalk.ingestDIM(context, dso, dimDoc.getRootElement().getChildren());
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString(), e);
        }
    }

    private static String getMetadataForDIM(Element field) {
        String element = field.getAttributeValue("element");
        String qualifier = field.getAttributeValue("qualifier");
        String fname = "dc." + element;
        if (qualifier != null) {
            fname = fname + "." + qualifier;
        }
        return PackageUtils.dcToContainerMetadata(fname);
    }

    public static void ingestDIM(Context context, DSpaceObject dso, Element dim) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        XSLTIngestionCrosswalk.ingestDIM(context, dso, dim.getChildren());
    }

    public static void ingestDIM(Context context, DSpaceObject dso, List<Element> fields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type == 2) {
            Item item = (Item)dso;
            XSLTIngestionCrosswalk.applyDim(fields, item);
        } else if (type == 3 || type == 4) {
            for (Element field : fields) {
                String schema = field.getAttributeValue("mdschema");
                if ("dim".equals(field.getName()) && DIM_NS.equals((Object)field.getNamespace())) {
                    XSLTIngestionCrosswalk.ingestDIM(context, dso, field.getChildren());
                    continue;
                }
                if ("field".equals(field.getName()) && DIM_NS.equals((Object)field.getNamespace()) && schema != null && "dc".equals(schema)) {
                    String md = XSLTIngestionCrosswalk.getMetadataForDIM(field);
                    if (md == null) {
                        log.warn((Object)("Cannot map to Coll/Comm metadata field, DIM element=" + field.getAttributeValue("element") + ", qualifier=" + field.getAttributeValue("qualifier")));
                        continue;
                    }
                    if (type == 3) {
                        ((Collection)dso).setMetadata(md, field.getText());
                        continue;
                    }
                    ((Community)dso).setMetadata(md, field.getText());
                    continue;
                }
                log.warn((Object)("ignoring unrecognized DIM element: " + field.toString()));
            }
        } else {
            throw new CrosswalkObjectNotSupported("XsltSubmissionionCrosswalk can only crosswalk to an Item.");
        }
    }

    public static void main(String[] argv) throws Exception {
        XSLTransformer xform;
        IngestionCrosswalk xwalk;
        if (argv.length < 2) {
            System.err.println("Usage:  java XSLTIngestionCrosswalk [-l] <crosswalk-name> <input-file>");
            System.exit(1);
        }
        int i = 0;
        boolean list = false;
        if (argv.length > 2 && argv[0].equals("-l")) {
            ++i;
            list = true;
        }
        if ((xwalk = (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, argv[i])) == null) {
            System.err.println("Error, cannot find an IngestionCrosswalk plugin for: \"" + argv[i] + "\"");
            System.exit(1);
        }
        if ((xform = ((XSLTIngestionCrosswalk)xwalk).getTransformer(DIRECTION)) == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        SAXBuilder builder = new SAXBuilder();
        Document inDoc = builder.build((InputStream)new FileInputStream(argv[i + 1]));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        Document dimDoc = null;
        List dimList = null;
        if (list) {
            dimList = xform.transform(inDoc.getRootElement().getChildren());
            outputter.output(dimList, (OutputStream)System.out);
        } else {
            dimDoc = xform.transform(inDoc);
            outputter.output(dimDoc, (OutputStream)System.out);
            dimList = dimDoc.getRootElement().getChildren();
        }
        Context context = new Context();
        for (Object o : dimList) {
            if (!(o instanceof Element)) continue;
            Element elt = (Element)o;
            if (elt.getName().equals("field") && elt.getNamespace().equals((Object)DIM_NS)) {
                MetadataField mf;
                String schema = elt.getAttributeValue("mdschema");
                String element = elt.getAttributeValue("element");
                String qualifier = elt.getAttributeValue("qualifier");
                MetadataSchema ms = MetadataSchema.find(context, schema);
                if (ms == null) {
                    System.err.println("DIM Error, Cannot find metadata schema for: schema=\"" + schema + "\" (... element=\"" + element + "\", qualifier=\"" + qualifier + "\")");
                    continue;
                }
                if (qualifier != null && qualifier.equals("")) {
                    System.err.println("DIM Warning, qualifier is empty string:  schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                    qualifier = null;
                }
                if ((mf = MetadataField.findByElement(context, ms.getSchemaID(), element, qualifier)) != null) continue;
                System.err.println("DIM Error, Cannot find metadata field for: schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                continue;
            }
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
    }
}

