/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.dspace.browse.IndexBrowse;
import org.dspace.core.Context;
import org.dspace.search.DSIndexer;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class UpdateHandlePrefix {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("\nUsage: update-handle-prefix <old handle> <new handle>\n");
        } else {
            String oldH = args[0];
            String newH = args[1];
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
            Context context = new Context();
            System.out.println("If you continue, all handles in your repository with prefix " + oldH + " will be updated to have handle prefix " + newH + "\n");
            String sql = "SELECT count(*) as count FROM handle WHERE handle LIKE '" + oldH + "%'";
            TableRow row = DatabaseManager.querySingle(context, sql, new Object[0]);
            long count = row.getLongColumn("count");
            System.out.println(count + " items will be updated.\n");
            System.out.print("Have you taken a backup, and are you ready to continue? [y/n]: ");
            String choiceString = input.readLine();
            if (choiceString.equalsIgnoreCase("y")) {
                System.out.print("Updating handle table... ");
                sql = "update handle set handle = '" + newH + "' || '/' || handle_id " + "where handle like '" + oldH + "/%'";
                int updated = DatabaseManager.updateQuery(context, sql, new Object[0]);
                System.out.println(updated + " items updated");
                System.out.print("Updating metadatavalues table... ");
                sql = "UPDATE metadatavalue SET text_value= (SELECT 'http://hdl.handle.net/' || handle FROM handle WHERE handle.resource_id=item_id AND handle.resource_type_id=2) WHERE  text_value LIKE 'http://hdl.handle.net/%';";
                updated = DatabaseManager.updateQuery(context, sql, new Object[0]);
                System.out.println(updated + " metadata values updated");
                context.complete();
                System.out.print("Re-creating browse and search indexes... ");
                IndexBrowse.main(new String[]{"-i"});
                try {
                    DSIndexer.main(new String[0]);
                }
                catch (Exception e) {
                    System.out.println("Error re-indexing:");
                    e.printStackTrace();
                    System.out.println("\nPlease manually run [dspace]/bin/index-all");
                }
                System.out.println("\nHandles successfully updated.");
            } else {
                System.out.println("No changes have been made to your data.");
            }
        }
    }
}

