/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.IPMatcher;
import org.dspace.authenticate.IPMatcherException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class IPAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(IPAuthentication.class);
    private static Boolean useProxies;
    private List<IPMatcher> ipMatchers = new ArrayList<IPMatcher>();
    private List<IPMatcher> ipNegativeMatchers = new ArrayList<IPMatcher>();
    private Map<IPMatcher, String> ipMatcherGroupNames;
    private Map<IPMatcher, Integer> ipMatcherGroupIDs = new HashMap<IPMatcher, Integer>();

    public IPAuthentication() {
        this.ipMatcherGroupNames = new HashMap<IPMatcher, String>();
        Enumeration<?> e = ConfigurationManager.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith("authentication.ip.")) continue;
            String[] nameParts = propName.split("\\.");
            if (nameParts.length == 3) {
                this.addMatchers(nameParts[2], ConfigurationManager.getProperty(propName));
                continue;
            }
            log.warn((Object)("Malformed configuration property name: " + propName));
        }
    }

    private void addMatchers(String groupName, String ipRanges) {
        String[] ranges;
        for (String entry : ranges = ipRanges.split("\\s*,\\s*")) {
            try {
                IPMatcher ipm;
                if (entry.startsWith("-")) {
                    ipm = new IPMatcher(entry.substring(1));
                    this.ipNegativeMatchers.add(ipm);
                } else {
                    ipm = new IPMatcher(entry);
                    this.ipMatchers.add(ipm);
                }
                this.ipMatcherGroupNames.put(ipm, groupName);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Configured " + entry + " for special group " + groupName));
            }
            catch (IPMatcherException ipme) {
                log.warn((Object)("Malformed IP range specified for group " + groupName), (Throwable)ipme);
            }
        }
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    @Override
    public int[] getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        Group group;
        String groupName;
        if (request == null) {
            return new int[0];
        }
        ArrayList<Integer> groupIDs = new ArrayList<Integer>();
        String addr = request.getRemoteAddr();
        if (useProxies == null) {
            useProxies = ConfigurationManager.getBooleanProperty("useProxies", false);
        }
        if (useProxies.booleanValue() && request.getHeader("X-Forwarded-For") != null) {
            for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                if (request.getHeader("X-Forwarded-For").contains(addr)) continue;
                addr = xfip.trim();
            }
        }
        for (IPMatcher ipm : this.ipMatchers) {
            try {
                if (!ipm.match(addr)) continue;
                Integer g = this.ipMatcherGroupIDs.get(ipm);
                if (g != null) {
                    groupIDs.add(g);
                    continue;
                }
                groupName = this.ipMatcherGroupNames.get(ipm);
                if (groupName == null) continue;
                group = Group.findByName(context, groupName);
                if (group != null) {
                    this.ipMatcherGroupIDs.put(ipm, group.getID());
                    this.ipMatcherGroupNames.remove(ipm);
                    groupIDs.add(group.getID());
                    continue;
                }
                log.warn((Object)LogManager.getHeader(context, "configuration_error", "unknown_group=" + groupName));
            }
            catch (IPMatcherException ipme) {
                log.warn((Object)LogManager.getHeader(context, "configuration_error", "bad_ip=" + addr), (Throwable)ipme);
            }
        }
        for (IPMatcher ipm : this.ipNegativeMatchers) {
            try {
                if (!ipm.match(addr)) continue;
                Integer g = this.ipMatcherGroupIDs.get(ipm);
                if (g != null) {
                    groupIDs.remove(g);
                    continue;
                }
                groupName = this.ipMatcherGroupNames.get(ipm);
                if (groupName == null) continue;
                group = Group.findByName(context, groupName);
                if (group != null) {
                    this.ipMatcherGroupIDs.put(ipm, group.getID());
                    this.ipMatcherGroupNames.remove(ipm);
                    groupIDs.remove((Object)group.getID());
                    continue;
                }
                log.warn((Object)LogManager.getHeader(context, "configuration_error", "unknown_group=" + groupName));
            }
            catch (IPMatcherException ipme) {
                log.warn((Object)LogManager.getHeader(context, "configuration_error", "bad_ip=" + addr), (Throwable)ipme);
            }
        }
        int[] results = new int[groupIDs.size()];
        for (int i = 0; i < groupIDs.size(); ++i) {
            results[i] = (Integer)groupIDs.get(i);
        }
        if (log.isDebugEnabled()) {
            StringBuffer gsb = new StringBuffer();
            for (int i = 0; i < results.length; ++i) {
                if (i > 0) {
                    gsb.append(",");
                }
                gsb.append(results[i]);
            }
            log.debug((Object)LogManager.getHeader(context, "authenticated", "special_groups=" + gsb.toString()));
        }
        return results;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        return 5;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    @Override
    public String loginPageTitle(Context context) {
        return null;
    }
}

